/*
 * Decompiled with CFR 0.152.
 */
package mx4j.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.persist.Persister;

public class FilePersister
extends Persister {
    private File m_store;

    public FilePersister(String location, String name) throws MBeanException {
        if (name == null) {
            throw new MBeanException(new IllegalArgumentException("Persist name cannot be null"));
        }
        if (location != null) {
            File dir = new File(location);
            if (!dir.exists()) {
                throw new MBeanException(new FileNotFoundException(location));
            }
            this.m_store = new File(dir, name);
        } else {
            this.m_store = new File(name);
        }
    }

    public String getFileName() {
        return this.m_store.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        FileInputStream fin = null;
        ObjectInputStream clois = null;
        Object result = null;
        FilePersister filePersister = this;
        synchronized (filePersister) {
            try {
                try {
                    fin = new FileInputStream(this.m_store);
                    clois = new ClassLoaderObjectInputStream(fin, Thread.currentThread().getContextClassLoader());
                    try {
                        result = clois.readObject();
                    }
                    catch (ClassNotFoundException ex2) {
                        try {
                            clois.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        fin = new FileInputStream(this.m_store);
                        clois = new ClassLoaderObjectInputStream(fin);
                        try {
                            result = clois.readObject();
                        }
                        catch (ClassNotFoundException e2) {
                            throw new MBeanException(e2);
                        }
                    }
                    Object var8_9 = null;
                }
                catch (IOException ex3) {
                    throw new MBeanException(ex3);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    clois.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            clois.close();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(Object data) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot store a null object."));
        }
        if (!(data instanceof Serializable)) {
            throw new MBeanException(new NotSerializableException(data.getClass().getName() + " must implement java.io.Serializable"));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        FilePersister filePersister = this;
        synchronized (filePersister) {
            try {
                fos = new FileOutputStream(this.m_store);
                oos = new ObjectOutputStream(fos);
            }
            catch (IOException ex2) {
                throw new MBeanException(ex2);
            }
            try {
                try {
                    oos.writeObject(data);
                    oos.flush();
                }
                catch (IOException ex4) {
                    throw new MBeanException(ex4);
                }
                Object var7_7 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException ex3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex3) {}
            oos.close();
            return;
        }
    }
}

