/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.ImplementationException;
import mx4j.log.Logger;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptorMBean;
import mx4j.util.Utils;

public class InvokerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor
implements InvokerMBeanServerInterceptorMBean {
    private MBeanServer m_server;

    public InvokerMBeanServerInterceptor(MBeanServer server) {
        this.m_server = server;
    }

    public String getType() {
        return "invoker";
    }

    public boolean isEnabled() {
        return true;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        ((NotificationBroadcaster)metadata.mbean).addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ((NotificationBroadcaster)metadata.mbean).removeNotificationListener(listener);
    }

    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        try {
            Class<?> cls = metadata.classloader.loadClass(className);
            Class[] signature = Utils.loadClasses(metadata.classloader, params);
            Constructor<?> ctor = cls.getConstructor(signature);
            metadata.mbean = ctor.newInstance(args);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (NoSuchMethodException x3) {
            throw new ReflectionException(x3);
        }
        catch (InstantiationException x4) {
            throw new ReflectionException(x4);
        }
        catch (IllegalAccessException x5) {
            throw new ReflectionException(x5);
        }
        catch (IllegalArgumentException x6) {
            throw new ReflectionException(x6);
        }
        catch (InvocationTargetException x7) {
            Throwable t2 = x7.getTargetException();
            if (t2 instanceof Error) {
                throw new RuntimeErrorException((Error)t2);
            }
            if (t2 instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t2);
            }
            throw new MBeanException((Exception)t2);
        }
    }

    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        if (!(metadata.mbean instanceof MBeanRegistration)) {
            return;
        }
        MBeanRegistration registrable = (MBeanRegistration)metadata.mbean;
        try {
            switch (operation) {
                case 1: {
                    ObjectName objName = registrable.preRegister(this.m_server, metadata.name);
                    if (objName != null) {
                        metadata.name = objName;
                    }
                    break;
                }
                case 2: {
                    registrable.postRegister(Boolean.TRUE);
                    break;
                }
                case 3: {
                    registrable.postRegister(Boolean.FALSE);
                    break;
                }
                case 4: {
                    registrable.preDeregister();
                    break;
                }
                case 5: {
                    registrable.postDeregister();
                    break;
                }
                default: {
                    throw new ImplementationException();
                }
            }
        }
        catch (Exception x2) {
            if (x2 instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x2;
            }
            throw new MBeanRegistrationException(x2);
        }
    }

    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        if (metadata.dynamic) {
            MBeanInfo info = ((DynamicMBean)metadata.mbean).getMBeanInfo();
            if (info == null) {
                return null;
            }
            metadata.info = info;
            String className = info.getClassName();
            if (!metadata.instance.getClassName().equals(className)) {
                metadata.instance = new ObjectInstance(metadata.name, className);
            }
        }
        return (MBeanInfo)metadata.info.clone();
    }

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to invoke() on dynamic MBean " + metadata.name);
            }
            try {
                return ((DynamicMBean)metadata.mbean).invoke(method, args, params);
            }
            catch (JMRuntimeException x2) {
                throw x2;
            }
            catch (RuntimeException x3) {
                throw new RuntimeMBeanException(x3);
            }
            catch (Error x4) {
                throw new RuntimeErrorException(x4);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Call to invoke() on standard MBean " + metadata.name);
        }
        return metadata.invoker.invoke(metadata, method, params, args);
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to getAttribute() on dynamic MBean " + metadata.name);
            }
            try {
                return ((DynamicMBean)metadata.mbean).getAttribute(attribute);
            }
            catch (JMRuntimeException x2) {
                throw x2;
            }
            catch (RuntimeException x3) {
                throw new RuntimeMBeanException(x3);
            }
            catch (Error x4) {
                throw new RuntimeErrorException(x4);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Call to getAttribute() on standard MBean " + metadata.name);
        }
        return metadata.invoker.getAttribute(metadata, attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to setAttribute() on dynamic MBean " + metadata.name);
            }
            try {
                ((DynamicMBean)metadata.mbean).setAttribute(attribute);
            }
            catch (JMRuntimeException x2) {
                throw x2;
            }
            catch (RuntimeException x3) {
                throw new RuntimeMBeanException(x3);
            }
            catch (Error x4) {
                throw new RuntimeErrorException(x4);
            }
        } else {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to setAttribute() on standard MBean " + metadata.name);
            }
            metadata.invoker.setAttribute(metadata, attribute);
        }
    }

    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to getAttributes() on dynamic MBean " + metadata.name);
            }
            try {
                return ((DynamicMBean)metadata.mbean).getAttributes(attributes);
            }
            catch (JMRuntimeException x2) {
                throw x2;
            }
            catch (RuntimeException x3) {
                throw new RuntimeMBeanException(x3);
            }
            catch (Error x4) {
                throw new RuntimeErrorException(x4);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Call to getAttributes() on standard MBean " + metadata.name);
        }
        AttributeList list = new AttributeList();
        int i2 = 0;
        while (i2 < attributes.length) {
            block10: {
                String name = attributes[i2];
                try {
                    Object value = this.getAttribute(metadata, name);
                    Attribute attr = new Attribute(name, value);
                    list.add(attr);
                }
                catch (Exception ignored) {
                    if (!logger.isEnabledFor(20)) break block10;
                    logger.info("Exception caught from getAttributes(), ignoring attribute " + name);
                }
            }
            ++i2;
        }
        return list;
    }

    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Call to setAttributes() on dynamic MBean " + metadata.name);
            }
            try {
                return ((DynamicMBean)metadata.mbean).setAttributes(attributes);
            }
            catch (JMRuntimeException x2) {
                throw x2;
            }
            catch (RuntimeException x3) {
                throw new RuntimeMBeanException(x3);
            }
            catch (Error x4) {
                throw new RuntimeErrorException(x4);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Call to setAttributes() on standard MBean " + metadata.name);
        }
        AttributeList list = new AttributeList();
        int i2 = 0;
        while (i2 < attributes.size()) {
            block10: {
                Attribute attr = (Attribute)attributes.get(i2);
                try {
                    this.setAttribute(metadata, attr);
                    list.add(attr);
                }
                catch (Exception ignored) {
                    if (!logger.isEnabledFor(20)) break block10;
                    logger.info("Exception caught from setAttributes(), ignoring attribute " + attr, ignored);
                }
            }
            ++i2;
        }
        return list;
    }
}

