/*
 * Decompiled with CFR 0.152.
 */
package mx4j.timer;

import java.util.Date;
import javax.management.timer.TimerNotification;
import mx4j.util.TimeTask;

public abstract class TimerTask
extends TimeTask {
    private TimerNotification m_notification;
    private long m_date;
    private long m_period;
    private long m_occurrences;
    private long m_initialOccurrences;
    private int m_hash;

    public TimerTask(TimerNotification n2, Date date, long period, long occurrences) {
        this.m_notification = n2;
        this.m_date = date.getTime();
        this.m_period = period;
        this.m_occurrences = occurrences;
        this.m_initialOccurrences = occurrences;
        this.m_hash = new Long(this.getDate()).hashCode() ^ new Long(this.getPeriod()).hashCode() ^ new Long(this.getInitialOccurrences()).hashCode();
        this.setNextExecutionTime(this.getDate());
    }

    public TimerNotification getNotification() {
        return this.m_notification;
    }

    public boolean isFinished() {
        return super.isFinished();
    }

    public void setFinished(boolean value) {
        super.setFinished(value);
    }

    public long getPeriod() {
        return this.m_period;
    }

    public boolean isPeriodic() {
        boolean periodic = this.getPeriod() > 0L && (this.getInitialOccurrences() == 0L || this.getOccurrences() > 0L);
        return periodic;
    }

    public long getNextExecutionTime() {
        return super.getNextExecutionTime();
    }

    public void setNextExecutionTime(long time) {
        super.setNextExecutionTime(time);
        --this.m_occurrences;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            TimerTask other = (TimerTask)obj;
            return this.getDate() == other.getDate() && this.getPeriod() == other.getPeriod() && this.getInitialOccurrences() == other.getInitialOccurrences();
        }
        catch (ClassCastException x2) {
            return false;
        }
    }

    public long getOccurrences() {
        return this.m_occurrences;
    }

    private long getInitialOccurrences() {
        return this.m_initialOccurrences;
    }

    public long getDate() {
        return this.m_date;
    }
}

