/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.core.jmx;

import com.ireasoning.core.jmx.AdaptorServer;
import com.ireasoning.core.jmx.AdaptorServerMBean;
import com.ireasoning.core.jmx.MBeanManager;
import com.ireasoning.util.Logger;
import com.ireasoning.util.config.ConfigFileManager;
import com.ireasoning.util.config.LoggerConfigManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class BaseAgent {
    protected MBeanServer _mbeanServer = null;
    boolean a = false;

    public BaseAgent() {
        this.a(null);
    }

    public BaseAgent(MBeanServer mBeanServer) {
        this.a(mBeanServer);
    }

    private void a(MBeanServer mBeanServer) {
        boolean bl;
        boolean bl2 = bl = System.getProperty("ibm.websphere.internalClassAccessMode") != null;
        if (bl) {
            ArrayList arrayList = MBeanServerFactory.findMBeanServer(null);
            if (arrayList.size() > 0) {
                Logger.info("Websphere. Use internal MBeanServer.");
                this._mbeanServer = (MBeanServer)arrayList.get(0);
            }
        } else {
            if (mBeanServer == null) {
                mBeanServer = MBeanManager.getInstance().getMBeanServer();
            }
            if (mBeanServer == null) {
                Logger.info("Start MBeanServer.");
                String string = System.getProperty("useInternalMBeanServer");
                if (string != null) {
                    ArrayList arrayList = MBeanServerFactory.findMBeanServer(null);
                    if (arrayList.size() > 0) {
                        Logger.info("Use internal MBeanServer.");
                        this._mbeanServer = (MBeanServer)arrayList.get(0);
                    } else {
                        Logger.warn("Internal MBeanServer not found.");
                        this._mbeanServer = MBeanServerFactory.createMBeanServer();
                    }
                } else {
                    this._mbeanServer = MBeanServerFactory.createMBeanServer();
                }
            } else {
                this._mbeanServer = mBeanServer;
            }
        }
        MBeanManager.getInstance().setMBeanServer(this._mbeanServer);
        this.registerHelperMBeans();
    }

    protected void registerHelperMBeans() {
        if (this.a) {
            return;
        }
        try {
            Object object;
            MBeanManager mBeanManager = MBeanManager.getInstance();
            if (!mBeanManager.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Start ConfigFileManager MBean.");
                object = new ConfigFileManager();
                mBeanManager.registerMBean(object, ConfigFileManager.OBJECT_NAME);
            }
            if (!mBeanManager.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Start LoggerConfigManager MBean.");
                object = new LoggerConfigManager();
                mBeanManager.registerMBean(object, LoggerConfigManager.OBJECT_NAME);
            }
            this.a = true;
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void unregisterHelperMBeans() {
        try {
            MBeanManager mBeanManager = MBeanManager.getInstance();
            if (mBeanManager.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Unregister config MBean");
                mBeanManager.unregisterMBean(ConfigFileManager.OBJECT_NAME);
            }
            if (mBeanManager.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Unregister logger MBean");
                mBeanManager.unregisterMBean(LoggerConfigManager.OBJECT_NAME);
                this.a = false;
            }
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2) throws Exception {
        this.startAdaptorServer(adaptorServerMBean, string, n2, null);
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2, InetAddress inetAddress) throws Exception {
        try {
            InetAddress inetAddress2 = inetAddress;
            if (inetAddress == null) {
                try {
                    inetAddress2 = InetAddress.getByName(null);
                }
                catch (UnknownHostException unknownHostException) {
                    Logger.error("Unknow local host", unknownHostException);
                }
            }
            ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, inetAddress2, n2));
            Logger.info("Start AdaptorServer, ObjectName [" + objectName + "]");
            MBeanManager mBeanManager = MBeanManager.getInstance();
            mBeanManager.registerMBean(adaptorServerMBean, objectName);
            Attribute attribute = new Attribute("Port", new Integer(n2));
            mBeanManager.setAttribute(objectName, attribute);
            attribute = new Attribute("IpAddress", inetAddress);
            mBeanManager.setAttribute(objectName, attribute);
            mBeanManager.invoke(objectName, "startService", null, null);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
    }

    protected void stopAdaptorServer(String string, int n2) throws Exception {
        this.stopAdaptorServer(string, n2, null);
    }

    protected void stopAdaptorServer(String string, int n2, InetAddress inetAddress) throws Exception {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress == null) {
            try {
                inetAddress2 = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                Logger.error("Unknow local host", unknownHostException);
            }
        }
        ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, inetAddress2, n2));
        Logger.info("Stop AdaptorServer, ObjectName [" + objectName + "]");
        MBeanManager mBeanManager = MBeanManager.getInstance();
        if (mBeanManager.isRegistered(objectName)) {
            try {
                mBeanManager.invoke(objectName, "stopService", null, null);
            }
            catch (MBeanException mBeanException) {
                throw mBeanException.getTargetException();
            }
            mBeanManager.unregisterMBean(objectName);
        }
    }

    public MBeanServer getMBeanServer() throws Exception {
        return this._mbeanServer;
    }
}

