/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.BasicOIDTreeNode;
import com.ireasoning.protocol.snmp.OIDTreeNode;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpInt;
import com.ireasoning.protocol.snmp.SnmpIpAddress;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTableEntry;
import com.ireasoning.protocol.snmp.SnmpTableMBean;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.Logger;
import com.ireasoning.util.dd;
import com.ireasoning.util.l;
import com.ireasoning.util.tb;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class SnmpTable
implements SnmpTableMBean {
    protected OIDTreeNode _tableNode;
    protected Vector _rows = new Vector();
    protected long _updateInterval = -1L;
    protected long _lastUpdateTime = -1L;
    boolean a;

    public SnmpTable(OIDTreeNode oIDTreeNode, String string) {
        this._tableNode = (OIDTreeNode)oIDTreeNode.search(new SnmpOID(string));
        this._tableNode.m = this;
        this._tableNode.setRegistered(true);
        if (this._updateInterval > 0L) {
            this._lastUpdateTime = System.currentTimeMillis();
        }
    }

    public OIDTreeNode getTableNode() {
        return this._tableNode;
    }

    public void setTableNode(OIDTreeNode oIDTreeNode) {
        this._tableNode = oIDTreeNode;
    }

    public abstract SnmpTableEntry newEntryInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList addRow(SnmpTableEntry snmpTableEntry, String string) {
        BasicOIDTreeNode basicOIDTreeNode;
        BasicOIDTreeNode basicOIDTreeNode2;
        ArrayList<BasicOIDTreeNode> arrayList = new ArrayList<BasicOIDTreeNode>();
        if (string == null) {
            return arrayList;
        }
        if (!this.preAddRow(snmpTableEntry)) {
            return arrayList;
        }
        BasicOIDTreeNode basicOIDTreeNode3 = basicOIDTreeNode2 = (BasicOIDTreeNode)basicOIDTreeNode.getRoot();
        synchronized (basicOIDTreeNode3) {
            for (basicOIDTreeNode = (BasicOIDTreeNode)this._tableNode.getFirstChild().getFirstChild(); basicOIDTreeNode != null; basicOIDTreeNode = (BasicOIDTreeNode)basicOIDTreeNode.getNextSibling()) {
                BasicOIDTreeNode basicOIDTreeNode4 = new BasicOIDTreeNode(new SnmpOID(basicOIDTreeNode.getName().toString() + string));
                BasicOIDTreeNode basicOIDTreeNode5 = (BasicOIDTreeNode)basicOIDTreeNode.addChild(basicOIDTreeNode4);
                basicOIDTreeNode5.setTableEntryObject(snmpTableEntry);
                arrayList.add(basicOIDTreeNode4);
            }
        }
        this._rows.add(snmpTableEntry);
        this.postAddRow(snmpTableEntry);
        return arrayList;
    }

    public ArrayList addRow(SnmpTableEntry snmpTableEntry) {
        String string = snmpTableEntry.getIndexSuffix();
        return this.addRow(snmpTableEntry, string);
    }

    public ArrayList addRow(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        try {
            SnmpOID snmpOID;
            SnmpVarBind snmpVarBind;
            OIDTreeNode oIDTreeNode;
            OIDTreeNode oIDTreeNode2 = oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild();
            SnmpTableEntry snmpTableEntry = this.newEntryInstance();
            String string = null;
            int n2 = 0;
            ArrayList<OIDTreeNode> arrayList = new ArrayList<OIDTreeNode>();
            String[] stringArray = ((OIDTreeNode)this._tableNode.getFirstChild()).getIndice();
            OIDTreeNode[] oIDTreeNodeArray = oIDTreeNode2.d();
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    for (int i3 = 0; i3 < oIDTreeNodeArray.length; ++i3) {
                        for (oIDTreeNode2 = (OIDTreeNode)oIDTreeNodeArray[i3].getFirstChild().getFirstChild(); oIDTreeNode2 != null; oIDTreeNode2 = (OIDTreeNode)oIDTreeNode2.getNextSibling()) {
                            if (!oIDTreeNode2.isIndexNode() || !oIDTreeNode2.getMibNodeName().equalsIgnoreCase(stringArray[i2])) continue;
                            arrayList.add(oIDTreeNode2);
                        }
                    }
                }
            }
            oIDTreeNode2 = oIDTreeNode;
            while (oIDTreeNode2 != null) {
                SnmpOID snmpOID2 = (SnmpOID)oIDTreeNode2.getName();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    snmpVarBind = (SnmpVarBind)iterator.next();
                    if (snmpVarBind == null || string != null || !(snmpOID = snmpVarBind.getName()).startsWith(snmpOID2)) continue;
                    string = snmpOID.suboid(snmpOID2.getLength(), snmpOID.getLength()).toString();
                }
                oIDTreeNode2 = (OIDTreeNode)oIDTreeNode2.getNextSibling();
                ++n2;
            }
            if (string != null) {
                this.a(string, arrayList, collection);
                n2 = 0;
                oIDTreeNode2 = oIDTreeNode;
                while (oIDTreeNode2 != null) {
                    SnmpOID snmpOID3 = (SnmpOID)oIDTreeNode2.getName();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        snmpVarBind = (SnmpVarBind)iterator.next();
                        if (snmpVarBind == null || !(snmpOID = snmpVarBind.getName()).startsWith(snmpOID3)) continue;
                        snmpTableEntry.set(n2, snmpVarBind.getValue());
                    }
                    oIDTreeNode2 = (OIDTreeNode)oIDTreeNode2.getNextSibling();
                    ++n2;
                }
                snmpTableEntry.setIndexSuffix(string);
            }
            return this.addRow(snmpTableEntry);
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    private void a(String string, ArrayList arrayList, Collection collection) {
        ArrayList arrayList2 = new ArrayList(arrayList);
        int[] nArray = new SnmpOID(string).getValue();
        HashSet hashSet = new HashSet();
        tb tb2 = new tb(0);
        tb tb3 = new tb(nArray.length);
        this.a(string, nArray, arrayList2, collection, hashSet, tb2, false);
        if (hashSet.size() > 0) {
            l.reverse(nArray);
            Collections.reverse(arrayList2);
            this.a(string, nArray, arrayList2, collection, hashSet, tb3, true);
            l.reverse(nArray);
            Collections.reverse(arrayList2);
        }
        if (hashSet.size() == 1) {
            int n2 = tb2.getValue();
            int n3 = nArray.length - tb3.getValue();
            Iterator iterator = hashSet.iterator();
            int n4 = (Integer)iterator.next();
            OIDTreeNode oIDTreeNode = (OIDTreeNode)arrayList.get(n4);
            byte by = oIDTreeNode.getRealSyntaxType();
            String string2 = dd.getObjectFullName(by, true);
            try {
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                if (obj instanceof SnmpOctetString) {
                    SnmpOctetString snmpOctetString = (SnmpOctetString)obj;
                    int n5 = n3 - n2;
                    byte[] byArray = new byte[n5];
                    for (int i2 = n2; i2 < n3; ++i2) {
                        byArray[i2 - n2] = (byte)nArray[i2];
                    }
                    snmpOctetString.setValue(byArray);
                    collection.add(new SnmpVarBind(new SnmpOID(oIDTreeNode.getName() + string), (SnmpDataType)snmpOctetString));
                }
            }
            catch (Exception exception) {
                Logger.error(exception);
            }
        }
        if (hashSet.size() == 0 && tb2.getValue() != nArray.length) {
            Logger.warn("Too many indexes values. startIndex=" + tb2.getValue() + ", endIndex=" + tb3.getValue() + ", suffix.len=" + nArray.length);
        }
    }

    private void a(String string, int[] nArray, ArrayList arrayList, Collection collection, HashSet hashSet, tb tb2, boolean bl) {
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            OIDTreeNode oIDTreeNode = (OIDTreeNode)arrayList.get(i2);
            SnmpOID snmpOID = (SnmpOID)oIDTreeNode.getName();
            Object var13_13 = null;
            byte by = oIDTreeNode.getRealSyntaxType();
            if (by == 2 || by == 3 || by == 4 || by == 6 || by == 5 || by == 7) {
                int n4 = -1;
                n4 = nArray[n2++];
                object = dd.getObjectFullName(by, true);
                try {
                    Class<?> clazz = Class.forName((String)object);
                    Object obj = clazz.newInstance();
                    Method method = null;
                    method = obj instanceof SnmpInt ? clazz.getMethod("setValue", Integer.TYPE) : clazz.getMethod("setValue", Long.TYPE);
                    method.invoke(obj, new Integer(n4));
                    SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(oIDTreeNode.getName() + string), (SnmpDataType)obj);
                    collection.add(snmpVarBind);
                }
                catch (Exception exception) {
                    Logger.error(exception);
                }
                tb2.setValue(n2);
                continue;
            }
            if (by == 8) {
                byte[] byArray = new byte[4];
                for (int i3 = 0; i3 < byArray.length && n2 < nArray.length; ++i3) {
                    if (bl) {
                        byArray[4 - i3] = (byte)nArray[n2++];
                        continue;
                    }
                    byArray[i3] = (byte)nArray[n2++];
                }
                object = new SnmpIpAddress(byArray);
                collection.add(new SnmpVarBind(new SnmpOID(oIDTreeNode.getName() + string), (SnmpDataType)object));
                tb2.setValue(n2);
                continue;
            }
            Integer n5 = null;
            n5 = bl ? new Integer(arrayList.size() - i2 - 1) : new Integer(i2);
            hashSet.add(n5);
            tb2.setValue(n2);
            return;
        }
    }

    public ArrayList deleteRow(int n2) {
        if (n2 >= this._rows.size() || n2 < 0) {
            return new ArrayList();
        }
        return this.deleteRow((SnmpTableEntry)this._rows.get(n2));
    }

    public ArrayList deleteRow(String string) {
        int n2 = this._rows.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpTableEntry snmpTableEntry = (SnmpTableEntry)this._rows.get(i2);
            String string2 = snmpTableEntry.getIndexSuffix();
            if (!string2.equals(string)) continue;
            return this.deleteRow(snmpTableEntry);
        }
        SnmpTableEntry snmpTableEntry = null;
        return this.deleteRow(snmpTableEntry);
    }

    public ArrayList deleteRow(SnmpTableEntry snmpTableEntry) {
        ArrayList arrayList = new ArrayList();
        if (snmpTableEntry == null) {
            return arrayList;
        }
        if (!this.preDeleteRow(snmpTableEntry)) {
            return arrayList;
        }
        boolean bl = this._rows.remove(snmpTableEntry);
        if (!bl) {
            return arrayList;
        }
        String string = snmpTableEntry.getIndexSuffix();
        arrayList = this.a(string);
        ArrayList arrayList2 = snmpTableEntry.deleteDependentRows();
        arrayList.addAll(arrayList2);
        this.postDeleteRow(snmpTableEntry);
        return arrayList;
    }

    public void deleteAllRows() {
        Vector vector = new Vector(this._rows.size());
        vector.addAll(this._rows);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.deleteRow((SnmpTableEntry)vector.get(i2));
        }
    }

    public String getIndexSuffix(int n2) {
        this.a(n2);
        SnmpTableEntry snmpTableEntry = (SnmpTableEntry)this._rows.get(n2);
        return snmpTableEntry.getIndexSuffix();
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public int getColumnCount() {
        return this._tableNode.getFirstChild().getChildNodeCount();
    }

    public Vector getRows() {
        return this._rows;
    }

    public SnmpTableEntry getRow(int n2) {
        this.a(n2);
        return (SnmpTableEntry)this._rows.get(n2);
    }

    public SnmpTableEntry getRow(String string) {
        int n2 = this._rows.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpTableEntry snmpTableEntry = (SnmpTableEntry)this._rows.get(i2);
            String string2 = snmpTableEntry.getIndexSuffix();
            if (!string2.equals(string)) continue;
            return snmpTableEntry;
        }
        return null;
    }

    public boolean isTimeToUpdate() {
        if (this._updateInterval < 0L) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this._lastUpdateTime > this._updateInterval) {
            this._lastUpdateTime = l2;
            return true;
        }
        return false;
    }

    public void update(SnmpPdu snmpPdu, SnmpOID snmpOID) {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void update() {
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void setUpdateInterval(long l2) {
        this._updateInterval = l2;
    }

    public long getUpdateInterval() {
        return this._updateInterval;
    }

    public void setLastUpdateTime(long l2) {
        this._lastUpdateTime = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList a(String string) {
        OIDTreeNode oIDTreeNode;
        BasicOIDTreeNode basicOIDTreeNode;
        ArrayList<SnmpOID> arrayList = new ArrayList<SnmpOID>();
        boolean bl = true;
        BasicOIDTreeNode basicOIDTreeNode2 = basicOIDTreeNode = (BasicOIDTreeNode)oIDTreeNode.getRoot();
        synchronized (basicOIDTreeNode2) {
            for (oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild(); oIDTreeNode != null; oIDTreeNode = (OIDTreeNode)oIDTreeNode.getNextSibling()) {
                SnmpOID snmpOID = new SnmpOID(oIDTreeNode.getName().toString() + string);
                if (!oIDTreeNode.removeChild(snmpOID)) continue;
                arrayList.add(snmpOID);
            }
        }
        return arrayList;
    }

    private void a(int n2) {
        if (n2 >= this._rows.size() || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this._rows.size());
        }
    }

    public boolean preAddRow(SnmpTableEntry snmpTableEntry) {
        return true;
    }

    public void postAddRow(SnmpTableEntry snmpTableEntry) {
    }

    public boolean preDeleteRow(SnmpTableEntry snmpTableEntry) {
        return true;
    }

    public void postDeleteRow(SnmpTableEntry snmpTableEntry) {
    }

    public void preSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, SnmpPdu snmpPdu) {
    }

    public boolean preSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, Collection collection) {
        return true;
    }

    public void postSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, SnmpPdu snmpPdu) {
    }

    public void postSetValue(SnmpTableEntry snmpTableEntry, SnmpVarBind snmpVarBind, Collection collection) {
    }

    public void setProcessSnmpRequestDirectly(boolean bl) {
        this.a = bl;
    }

    public boolean isProcessSnmpRequestDirectly() {
        return this.a;
    }

    public SnmpTableEntry getNextOID(SnmpOID snmpOID, SnmpPdu snmpPdu) {
        return this.getNextOID(snmpOID);
    }

    public SnmpTableEntry getNextOID(SnmpOID snmpOID) {
        return null;
    }

    public SnmpTableEntry getOID(SnmpOID snmpOID, SnmpPdu snmpPdu) {
        return this.getOID(snmpOID);
    }

    public SnmpTableEntry getOID(SnmpOID snmpOID) {
        return null;
    }

    public ArrayList getColumnOIDs() {
        ArrayList<SnmpOID> arrayList = new ArrayList<SnmpOID>();
        for (OIDTreeNode oIDTreeNode = (OIDTreeNode)this._tableNode.getFirstChild().getFirstChild(); oIDTreeNode != null; oIDTreeNode = (OIDTreeNode)oIDTreeNode.getNextSibling()) {
            arrayList.add((SnmpOID)oIDTreeNode.getName());
        }
        return arrayList;
    }
}

