/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpDecodingException;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpIpAddress;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpTrap;
import com.ireasoning.protocol.snmp.SnmpV2Notification;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.VarBindContainer;
import com.ireasoning.protocol.snmp.cb;
import com.ireasoning.protocol.snmp.db;
import com.ireasoning.util.Logger;
import com.ireasoning.util.ge;
import com.ireasoning.util.qd;
import com.ireasoning.util.ub;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpV1Trap
extends VarBindContainer
implements SnmpDataType {
    static SnmpIpAddress b = null;
    SnmpOID c;
    SnmpIpAddress d = b;
    InetAddress e;
    int f = 0;
    int g = 0;
    long h = 0L;
    String i;
    static ub j;
    public static final int COLD_START_TRAP = 0;
    public static final int WARM_START_TRAP = 1;
    public static final int LINK_DOWN_TRAP = 2;
    public static final int LINK_UP_TRAP = 3;
    public static final int AUTHENTICATION_FAILURE_TRAP = 4;
    public static final int EGPNEIGHBOR_LOSS_TRAP = 5;
    private static final String[] k;
    static final SnmpOID l;
    static final SnmpOID m;
    static final SnmpOID[] n;

    SnmpV1Trap() {
    }

    public SnmpV1Trap(SnmpOID snmpOID) {
        this();
        this.c = new SnmpOID(snmpOID);
    }

    public SnmpV1Trap(String string) {
        this(new SnmpOID(string));
    }

    public SnmpV1Trap(SnmpV1Trap snmpV1Trap) {
        super(snmpV1Trap);
        this.c = snmpV1Trap.c;
        this.d = snmpV1Trap.d;
        this.f = snmpV1Trap.f;
        this.g = snmpV1Trap.g;
        this.h = snmpV1Trap.h;
        this.i = qd.cloneString(snmpV1Trap.i);
    }

    public static SnmpV1Trap decodeV1Trap(byte[] byArray, int n2) throws SnmpDecodingException {
        cb cb2 = new cb(byArray, n2);
        return (SnmpV1Trap)cb2.a(false);
    }

    public static byte[] encodeV1Trap(SnmpV1Trap snmpV1Trap) throws SnmpEncodingException {
        db db2 = new db();
        db2.a(snmpV1Trap, snmpV1Trap.getCommunity());
        byte[] byArray = db2.a();
        int n2 = db2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public SnmpOID getEnterprise() {
        return this.c;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this.c = new SnmpOID(snmpOID);
    }

    public void setEnterprise(String string) {
        this.c = new SnmpOID(string);
    }

    public SnmpIpAddress getIpAddress() {
        return this.d;
    }

    public InetAddress getTrapSenderIpAddress() {
        return this.e;
    }

    public void setTrapSenderIpAddress(InetAddress inetAddress) {
        this.e = inetAddress;
    }

    public void setIpAddress(SnmpIpAddress snmpIpAddress) {
        this.d = snmpIpAddress;
    }

    public void setIpAddress(String string) {
        this.d = SnmpIpAddress.isValidIpAddress(string) ? new SnmpIpAddress(string) : new SnmpIpAddress();
    }

    public void setIpAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        this.d = byArray != null && byArray.length == 4 ? new SnmpIpAddress(inetAddress.getHostAddress()) : new SnmpIpAddress();
    }

    public int getGeneric() {
        return this.f;
    }

    public String getGenericString() {
        if (this.f < 0 || this.f >= k.length) {
            return null;
        }
        return k[this.f];
    }

    public void setGeneric(int n2) {
        this.f = n2;
        if (this.f < 6) {
            this.g = 0;
        }
    }

    public int getSpecific() {
        return this.g;
    }

    public void setSpecific(int n2) {
        this.g = n2;
        if (n2 > 0) {
            this.f = 6;
        }
    }

    public long getTimestamp() {
        return this.h;
    }

    public void setTimestamp(long l2) {
        this.h = l2;
    }

    public String getTimestampString() {
        return "" + new ge(this.h * 10L);
    }

    public String getCommunity() {
        return this.i;
    }

    public void setCommunity(String string) {
        this.i = string;
    }

    public SnmpVarBind[] getVariables() {
        return this.getVarBinds();
    }

    public int getType() {
        return -92;
    }

    public String getTypeString() {
        return "V1Trap";
    }

    public SnmpTrap toV2Trap() {
        return this.toV2Trap(false);
    }

    public SnmpTrap toV2Trap(boolean bl) {
        Object object;
        long l2 = this.h;
        SnmpOID snmpOID = null;
        if (this.f == 6) {
            snmpOID = new SnmpOID(this.c);
            object = new long[]{0L, this.g};
            snmpOID.append((long[])object);
        } else {
            snmpOID = new SnmpOID((SnmpOID)j.get(this.f));
        }
        object = new SnmpTrap(l2, snmpOID, this.a.toArray());
        if (bl) {
            SnmpDataType snmpDataType;
            int n2;
            boolean[] blArray = new boolean[3];
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                snmpDataType = this.a.get(n2);
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (!snmpDataType.getName().equals(n[i2])) continue;
                    blArray[i2] = true;
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (blArray[n2]) continue;
                snmpDataType = null;
                if (n2 == 0) {
                    snmpDataType = this.d;
                } else if (n2 == 1) {
                    snmpDataType = new SnmpOctetString(this.i);
                } else if (n2 == 2) {
                    snmpDataType = this.c;
                }
                SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(n[n2]), snmpDataType);
                object.addVarBind(snmpVarBind);
            }
        }
        object.setIpAddress(this.d.toString());
        return object;
    }

    public SnmpDataType copy() {
        return new SnmpV1Trap(this);
    }

    public int encode(db db2) throws SnmpEncodingException {
        return db2.a(this);
    }

    public String toString() {
        String string = "";
        string = string + "Community:\t\t" + qd.convertNull(this.i) + "\r\n";
        string = string + "Enterprise OID:\t\t" + this.getEnterprise() + "\r\n";
        string = string + "Ip Address:\t\t" + this.getIpAddress() + "\r\n";
        string = string + "Generic:\t\t" + this.getGenericString() + "\r\n";
        string = string + "Specific:\t\t" + this.getSpecific() + "\r\n";
        string = string + "TimeStamp:\t\t" + this.getTimestampString() + "\r\n";
        int n2 = this.getVarBindCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = this.getVarBind(i2);
            string = string + snmpVarBind.toString() + "\r\n";
        }
        return string;
    }

    static {
        try {
            b = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            Logger.error(unknownHostException);
            b = new SnmpIpAddress("0.0.0.0");
        }
        j = new ub();
        j.put(0, SnmpV2Notification.COLD_START_TRAP_OID);
        j.put(1, SnmpV2Notification.WARM_START_TRAP_OID);
        j.put(2, SnmpV2Notification.LINK_DOWN_TRAP_OID);
        j.put(3, SnmpV2Notification.LINK_UP_TRAP_OID);
        j.put(4, SnmpV2Notification.AUTHENTICATION_FAILURE_TRAP_OID);
        j.put(5, SnmpV2Notification.EGPNEIGHBOR_LOSS_OID);
        k = new String[]{"coldStart", "warmStart", "linkDown", "linkUp", "authenticationFailure", "egpNeighborLoss", "enterpriseSpecific"};
        l = new SnmpOID(".1.3.6.1.6.3.18.1.3.0");
        m = new SnmpOID(".1.3.6.1.6.3.18.1.4.0");
        n = new SnmpOID[]{l, m, SnmpTrap.SNMP_TRAP_ENTERPRISE_OID};
    }
}

