/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class RC2
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("RC2");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("RC2", 2, 3);
    private static final int[] S_BOX = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    public static final int BLOCK_SIZE = 8;
    private long native_cookie;
    private Object native_lock;
    private int[] sKey = new int[64];

    private static void debug(String string) {
        err.println("RC2: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(RC2.getLibMajorVersion(), RC2.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    RC2.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                RC2.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    RC2.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 8;
                    n4 += 8;
                    ++n6;
                }
            }
        } else if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                this.blockEncrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n5) {
                this.blockDecrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n8;
            }
        }
        return n3;
    }

    private void makeKey(Key key) throws KeyException {
        Object object;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null RC2 user key");
        }
        int n2 = byArray.length;
        if (n2 > 128) {
            throw new KeyException("Invalid RC2 user key size");
        }
        if (this.native_lock != null) {
            object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        RC2.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        object = new int[128];
        int n3 = 0;
        while (n3 < n2) {
            object[n3] = byArray[n3] & 0xFF;
            ++n3;
        }
        n3 = n2;
        while (n3 < 128) {
            object[n3] = S_BOX[object[n3 - n2] + object[n3 - 1] & 0xFF];
            ++n3;
        }
        object[128 - n2] = S_BOX[object[128 - n2] & 0xFF];
        n3 = 127 - n2;
        while (n3 >= 0) {
            object[n3] = S_BOX[object[n3 + n2] ^ object[n3 + 1]];
            --n3;
        }
        n3 = 63;
        while (n3 >= 0) {
            this.sKey[n3] = (object[n3 * 2 + 1] << 8 | object[n3 * 2]) & 0xFFFF;
            --n3;
        }
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
        int n5 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
        int n6 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
        int n7 = byArray[n2++] & 0xFF | (byArray[n2] & 0xFF) << 8;
        int n8 = 0;
        int n9 = 0;
        while (n9 < 16) {
            n4 = n4 + (n5 & ~n7) + (n6 & n7) + this.sKey[n8++] & 0xFFFF;
            n4 = n4 << 1 | n4 >>> 15;
            n5 = n5 + (n6 & ~n4) + (n7 & n4) + this.sKey[n8++] & 0xFFFF;
            n5 = n5 << 2 | n5 >>> 14;
            n6 = n6 + (n7 & ~n5) + (n4 & n5) + this.sKey[n8++] & 0xFFFF;
            n6 = n6 << 3 | n6 >>> 13;
            n7 = n7 + (n4 & ~n6) + (n5 & n6) + this.sKey[n8++] & 0xFFFF;
            n7 = n7 << 5 | n7 >>> 11;
            if (n9 == 4 || n9 == 10) {
                n6 += this.sKey[(n5 += this.sKey[(n4 += this.sKey[n7 & 0x3F]) & 0x3F]) & 0x3F];
                n7 += this.sKey[n6 & 0x3F];
            }
            ++n9;
        }
        byArray2[n3++] = (byte)n4;
        byArray2[n3++] = (byte)(n4 >>> 8);
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)n6;
        byArray2[n3++] = (byte)(n6 >>> 8);
        byArray2[n3++] = (byte)n7;
        byArray2[n3] = (byte)(n7 >>> 8);
    }

    private void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
        int n5 = byArray[n2 + 2] & 0xFF | (byArray[n2 + 3] & 0xFF) << 8;
        int n6 = byArray[n2 + 4] & 0xFF | (byArray[n2 + 5] & 0xFF) << 8;
        int n7 = byArray[n2 + 6] & 0xFF | (byArray[n2 + 7] & 0xFF) << 8;
        int n8 = 63;
        int n9 = 15;
        while (n9 >= 0) {
            n7 = (n7 >>> 5 | n7 << 11) & 0xFFFF;
            n7 = n7 - (n4 & ~n6) - (n5 & n6) - this.sKey[n8--] & 0xFFFF;
            n6 = (n6 >>> 3 | n6 << 13) & 0xFFFF;
            n6 = n6 - (n7 & ~n5) - (n4 & n5) - this.sKey[n8--] & 0xFFFF;
            n5 = (n5 >>> 2 | n5 << 14) & 0xFFFF;
            n5 = n5 - (n6 & ~n4) - (n7 & n4) - this.sKey[n8--] & 0xFFFF;
            n4 = (n4 >>> 1 | n4 << 15) & 0xFFFF;
            n4 = n4 - (n5 & ~n7) - (n6 & n7) - this.sKey[n8--] & 0xFFFF;
            if (n9 == 11 || n9 == 5) {
                n7 = n7 - this.sKey[n6 & 0x3F] & 0xFFFF;
                n6 = n6 - this.sKey[n5 & 0x3F] & 0xFFFF;
                n5 = n5 - this.sKey[n4 & 0x3F] & 0xFFFF;
                n4 = n4 - this.sKey[n7 & 0x3F] & 0xFFFF;
            }
            --n9;
        }
        byArray2[n3++] = (byte)n4;
        byArray2[n3++] = (byte)(n4 >>> 8);
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)n6;
        byArray2[n3++] = (byte)(n6 >>> 8);
        byArray2[n3++] = (byte)n7;
        byArray2[n3] = (byte)(n7 >>> 8);
    }

    public RC2() {
        super(false, false, "Cryptix");
        this.link();
    }
}

