/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultProcessor
implements ProcessorMBean {
    private static final String ENCODING = "UTF-8";
    private boolean canonical = false;

    public String getName() {
        return "Default XML Processor";
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        out.setCode(200);
        out.setHeader("Content-Type", "text/xml");
        out.sendHeaders();
        this.print(new PrintWriter(out), document);
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        this.print(new PrintWriter(o2), document);
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info(new String(o2.toByteArray()));
        }
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e2) throws IOException {
        if (e2 instanceof HttpException) {
            out.setCode(((HttpException)e2).getCode());
            out.setHeader("Content-Type", "text/xml");
            out.sendHeaders();
            this.print(new PrintWriter(out), ((HttpException)e2).getResponseDoc());
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/server";
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        throw new HttpException(404, "Path " + path + " not found");
    }

    protected void print(PrintWriter out, Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(out, children.item(iChild));
                    ++iChild;
                }
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i2 = 0;
                while (i2 < attrs.length) {
                    Attr attr = attrs[i2];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(this.normalize(attr.getNodeValue()));
                    out.print('\"');
                    ++i2;
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i3 = 0;
                while (i3 < len) {
                    this.print(out, children.item(i3));
                    ++i3;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i4 = 0;
                    while (i4 < len) {
                        this.print(out, children.item(i4));
                        ++i4;
                    }
                    break;
                }
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
        }
        out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i2 = 0;
        while (i2 < len) {
            array[i2] = (Attr)attrs.item(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < len - 1) {
            String name = array[i3].getNodeName();
            int index = i3;
            int j2 = i3 + 1;
            while (j2 < len) {
                String curName = array[j2].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j2;
                }
                ++j2;
            }
            if (index != i3) {
                Attr temp = array[i3];
                array[i3] = array[index];
                array[index] = temp;
            }
            ++i3;
        }
        return array;
    }

    protected String normalize(String s2) {
        StringBuffer str = new StringBuffer();
        int len = s2 != null ? s2.length() : 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = s2.charAt(i2);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i2;
        }
        return str.toString();
    }
}

