/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceDatabasePopulator
implements DatabasePopulator {
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private String separator = ";";
    private String commentPrefix = "--";
    private String blockCommentStartDelimiter = "/*";
    private String blockCommentEndDelimiter = "*/";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public ResourceDatabasePopulator() {
    }

    public ResourceDatabasePopulator(Resource ... scripts) {
        this();
        this.setScripts(scripts);
    }

    public ResourceDatabasePopulator(boolean continueOnError, boolean ignoreFailedDrops, String sqlScriptEncoding, Resource ... scripts) {
        this(scripts);
        this.continueOnError = continueOnError;
        this.ignoreFailedDrops = ignoreFailedDrops;
        this.setSqlScriptEncoding(sqlScriptEncoding);
    }

    public void addScript(Resource script) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        this.getScripts().add(script);
    }

    public void addScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.getScripts().addAll(Arrays.asList(scripts));
    }

    public void setScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.scripts = new ArrayList<Resource>(Arrays.asList(scripts));
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = StringUtils.hasText((String)sqlScriptEncoding) ? sqlScriptEncoding : null;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setBlockCommentStartDelimiter(String blockCommentStartDelimiter) {
        Assert.hasText((String)blockCommentStartDelimiter, (String)"BlockCommentStartDelimiter must not be null or empty");
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
    }

    public void setBlockCommentEndDelimiter(String blockCommentEndDelimiter) {
        Assert.hasText((String)blockCommentEndDelimiter, (String)"BlockCommentEndDelimiter must not be null or empty");
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws ScriptException {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        for (Resource script : this.getScripts()) {
            ScriptUtils.executeSqlScript(connection, this.encodeScript(script), this.continueOnError, this.ignoreFailedDrops, this.commentPrefix, this.separator, this.blockCommentStartDelimiter, this.blockCommentEndDelimiter);
        }
    }

    public void execute(DataSource dataSource) throws ScriptException {
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        DatabasePopulatorUtils.execute(this, dataSource);
    }

    final List<Resource> getScripts() {
        return this.scripts;
    }

    private EncodedResource encodeScript(Resource script) {
        Assert.notNull((Object)script, (String)"Script must not be null");
        return new EncodedResource(script, this.sqlScriptEncoding);
    }

    private void assertContentsOfScriptArray(Resource ... scripts) {
        Assert.notNull((Object)scripts, (String)"Scripts must not be null");
        Assert.noNullElements((Object[])scripts, (String)"Scripts array must not contain null elements");
    }
}

