/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.token.grant.code;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.filter.state.DefaultStateKeyGenerator;
import org.springframework.security.oauth2.client.filter.state.StateKeyGenerator;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserApprovalRequiredException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseExtractor;

public class AuthorizationCodeAccessTokenProvider
extends OAuth2AccessTokenSupport
implements AccessTokenProvider {
    private StateKeyGenerator stateKeyGenerator = new DefaultStateKeyGenerator();
    private String scopePrefix = "scope.";

    public void setScopePrefix(String scopePrefix) {
        this.scopePrefix = scopePrefix;
    }

    public void setStateKeyGenerator(StateKeyGenerator stateKeyGenerator) {
        this.stateKeyGenerator = stateKeyGenerator;
    }

    @Override
    public boolean supportsResource(OAuth2ProtectedResourceDetails resource) {
        return resource instanceof AuthorizationCodeResourceDetails && "authorization_code".equals(resource.getGrantType());
    }

    @Override
    public boolean supportsRefresh(OAuth2ProtectedResourceDetails resource) {
        return this.supportsResource(resource);
    }

    public String obtainAuthorizationCode(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, UserApprovalRequiredException, AccessDeniedException, OAuth2AccessDeniedException {
        String code;
        AuthorizationCodeResourceDetails resource = (AuthorizationCodeResourceDetails)details;
        HttpHeaders headers = this.getHeadersForTokenRequest(request);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        if (request.containsKey("user_oauth_approval")) {
            form.set((Object)"user_oauth_approval", (Object)((String)request.getFirst("user_oauth_approval")));
            for (String scope : details.getScope()) {
                form.set((Object)(String.valueOf(this.scopePrefix) + scope), (Object)((String)request.getFirst("user_oauth_approval")));
            }
        } else {
            form.putAll(this.getParametersForAuthorizeRequest(resource, request));
        }
        ResponseEntity response = (ResponseEntity)this.getRestTemplate().execute(resource.getUserAuthorizationUri(), HttpMethod.POST, this.getRequestCallback(resource, (MultiValueMap<String, String>)form, headers), this.getAuthorizationResponseExtractor(), form.toSingleValueMap());
        if (response.getStatusCode() == HttpStatus.OK) {
            throw this.getUserApprovalSignal(resource, request);
        }
        URI location = response.getHeaders().getLocation();
        String query = location.getQuery();
        Map<String, String> map = OAuth2Utils.extractMap(query);
        if (map.containsKey("state")) {
            request.setStateKey(map.get("state"));
            if (request.getPreservedState() == null) {
                String redirectUri = resource.getRedirectUri(request);
                if (redirectUri != null) {
                    request.setPreservedState(redirectUri);
                } else {
                    request.setPreservedState(new Object());
                }
            }
        }
        if ((code = map.get("code")) == null) {
            throw new UserRedirectRequiredException(location.toString(), form.toSingleValueMap());
        }
        request.set("code", code);
        return code;
    }

    protected ResponseExtractor<ResponseEntity<Void>> getAuthorizationResponseExtractor() {
        return new ResponseExtractor<ResponseEntity<Void>>(){

            public ResponseEntity<Void> extractData(ClientHttpResponse response) throws IOException {
                return new ResponseEntity((MultiValueMap)response.getHeaders(), response.getStatusCode());
            }
        };
    }

    @Override
    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails details, AccessTokenRequest request) throws UserRedirectRequiredException, UserApprovalRequiredException, AccessDeniedException, OAuth2AccessDeniedException {
        AuthorizationCodeResourceDetails resource = (AuthorizationCodeResourceDetails)details;
        if (request.getAuthorizationCode() == null) {
            if (request.getStateKey() == null) {
                throw this.getRedirectForAuthorization(resource, request);
            }
            this.obtainAuthorizationCode(resource, request);
        }
        return this.retrieveToken(this.getParametersForTokenRequest(resource, request), this.getHeadersForTokenRequest(request), resource);
    }

    @Override
    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails resource, OAuth2RefreshToken refreshToken, AccessTokenRequest request) throws UserRedirectRequiredException, OAuth2AccessDeniedException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"refresh_token");
        form.add((Object)"refresh_token", (Object)refreshToken.getValue());
        try {
            return this.retrieveToken((MultiValueMap<String, String>)form, this.getHeadersForTokenRequest(request), resource);
        }
        catch (OAuth2AccessDeniedException e) {
            throw this.getRedirectForAuthorization((AuthorizationCodeResourceDetails)resource, request);
        }
    }

    private HttpHeaders getHeadersForTokenRequest(AccessTokenRequest request) {
        HttpHeaders headers = new HttpHeaders();
        if (request.getCookie() != null) {
            headers.set("Cookie", request.getCookie());
        }
        return headers;
    }

    private MultiValueMap<String, String> getParametersForTokenRequest(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.set((Object)"grant_type", (Object)"authorization_code");
        form.set((Object)"code", (Object)request.getAuthorizationCode());
        Object preservedState = request.getPreservedState();
        if (request.getStateKey() != null && preservedState == null) {
            throw new InvalidRequestException("Possible CSRF detected - state parameter was present but no state could be found");
        }
        String redirectUri = null;
        redirectUri = preservedState instanceof String ? String.valueOf(preservedState) : resource.getRedirectUri(request);
        if (redirectUri != null && !"NONE".equals(redirectUri)) {
            form.set((Object)"redirect_uri", (Object)redirectUri);
        }
        return form;
    }

    private MultiValueMap<String, String> getParametersForAuthorizeRequest(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.set((Object)"response_type", (Object)"code");
        form.set((Object)"client_id", (Object)resource.getClientId());
        if (request.get("scope") != null) {
            form.set((Object)"scope", (Object)((String)request.getFirst("scope")));
        } else {
            form.set((Object)"scope", (Object)OAuth2Utils.formatParameterList(resource.getScope()));
        }
        String redirectUri = resource.getPreEstablishedRedirectUri();
        Object preservedState = request.getPreservedState();
        redirectUri = redirectUri == null && preservedState != null ? String.valueOf(preservedState) : request.getCurrentUri();
        String stateKey = request.getStateKey();
        if (stateKey != null) {
            form.set((Object)"state", (Object)stateKey);
            if (preservedState == null) {
                throw new InvalidRequestException("Possible CSRF detected - state parameter was present but no state could be found");
            }
        }
        if (redirectUri != null) {
            form.set((Object)"redirect_uri", (Object)redirectUri);
        }
        return form;
    }

    private UserRedirectRequiredException getRedirectForAuthorization(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        TreeMap<String, String> requestParameters = new TreeMap<String, String>();
        requestParameters.put("response_type", "code");
        requestParameters.put("client_id", resource.getClientId());
        String redirectUri = resource.getRedirectUri(request);
        if (redirectUri != null) {
            requestParameters.put("redirect_uri", redirectUri);
        }
        if (resource.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List<String> scope = resource.getScope();
            if (scope != null) {
                Iterator<String> scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append(scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            requestParameters.put("scope", builder.toString());
        }
        UserRedirectRequiredException redirectException = new UserRedirectRequiredException(resource.getUserAuthorizationUri(), requestParameters);
        String stateKey = this.stateKeyGenerator.generateKey(resource);
        redirectException.setStateKey(stateKey);
        request.setStateKey(stateKey);
        redirectException.setStateToPreserve(redirectUri);
        request.setPreservedState(redirectUri);
        return redirectException;
    }

    protected UserApprovalRequiredException getUserApprovalSignal(AuthorizationCodeResourceDetails resource, AccessTokenRequest request) {
        String message = String.format("Do you approve the client '%s' to access your resources with scope=%s", resource.getClientId(), resource.getScope());
        return new UserApprovalRequiredException(resource.getUserAuthorizationUri(), Collections.singletonMap("user_oauth_approval", message), resource.getClientId(), resource.getScope());
    }
}

