/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.util.Assert;

public class ApprovalStoreUserApprovalHandler
implements UserApprovalHandler,
InitializingBean {
    private static Log logger = LogFactory.getLog(ApprovalStoreUserApprovalHandler.class);
    private String scopePrefix = "scope.";
    private ApprovalStore approvalStore;
    private int approvalExpiryInMillis = -1;
    private ClientDetailsService clientDetailsService;
    private OAuth2RequestFactory requestFactory;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setScopePrefix(String scopePrefix) {
        this.scopePrefix = scopePrefix;
    }

    public void setApprovalStore(ApprovalStore store) {
        this.approvalStore = store;
    }

    public void setRequestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setApprovalExpiryInSeconds(int approvalExpirySeconds) {
        this.approvalExpiryInMillis = approvalExpirySeconds * 1000;
    }

    public void afterPropertiesSet() {
        Assert.state((this.approvalStore != null ? 1 : 0) != 0, (String)"ApprovalStore must be provided");
        Assert.state((this.requestFactory != null ? 1 : 0) != 0, (String)"OAuth2RequestFactory must be provided");
    }

    @Override
    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest.isApproved();
    }

    @Override
    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        String clientId = authorizationRequest.getClientId();
        Set requestedScopes = authorizationRequest.getScope();
        HashSet<String> approvedScopes = new HashSet<String>();
        HashSet<String> validUserApprovedScopes = new HashSet<String>();
        if (this.clientDetailsService != null) {
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
                for (String scope : requestedScopes) {
                    if (!client.isAutoApprove(scope) && !client.isAutoApprove("all")) continue;
                    approvedScopes.add(scope);
                }
                if (approvedScopes.containsAll(requestedScopes)) {
                    authorizationRequest.setApproved(true);
                    return authorizationRequest;
                }
            }
            catch (ClientRegistrationException e) {
                logger.warn((Object)("Client registration problem prevent autoapproval check for client=" + clientId));
            }
        }
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up user approved authorizations for ");
            builder.append("client_id=" + clientId);
            builder.append(" and username=" + userAuthentication.getName());
            logger.debug((Object)builder.toString());
        }
        Collection<Approval> userApprovals = this.approvalStore.getApprovals(userAuthentication.getName(), clientId);
        Date today = new Date();
        for (Approval approval : userApprovals) {
            if (!approval.getExpiresAt().after(today)) continue;
            validUserApprovedScopes.add(approval.getScope());
            if (approval.getStatus() != Approval.ApprovalStatus.APPROVED) continue;
            approvedScopes.add(approval.getScope());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Valid user approved/denied scopes are " + validUserApprovedScopes));
        }
        if (validUserApprovedScopes.containsAll(requestedScopes)) {
            approvedScopes.retainAll(requestedScopes);
            authorizationRequest.setScope(approvedScopes);
            authorizationRequest.setApproved(true);
        }
        return authorizationRequest;
    }

    private Date computeExpiry() {
        Calendar expiresAt = Calendar.getInstance();
        if (this.approvalExpiryInMillis == -1) {
            expiresAt.add(2, 1);
        } else {
            expiresAt.add(14, this.approvalExpiryInMillis);
        }
        return expiresAt.getTime();
    }

    @Override
    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Set requestedScopes = authorizationRequest.getScope();
        HashSet<String> approvedScopes = new HashSet<String>();
        HashSet<Approval> approvals = new HashSet<Approval>();
        Date expiry = this.computeExpiry();
        Map<String, String> approvalParameters = authorizationRequest.getApprovalParameters();
        for (String requestedScope : requestedScopes) {
            String approvalParameter = String.valueOf(this.scopePrefix) + requestedScope;
            String value = approvalParameters.get(approvalParameter);
            String string = value = value == null ? "" : value.toLowerCase();
            if ("true".equals(value) || value.startsWith("approve")) {
                approvedScopes.add(requestedScope);
                approvals.add(new Approval(userAuthentication.getName(), authorizationRequest.getClientId(), requestedScope, expiry, Approval.ApprovalStatus.APPROVED));
                continue;
            }
            approvals.add(new Approval(userAuthentication.getName(), authorizationRequest.getClientId(), requestedScope, expiry, Approval.ApprovalStatus.DENIED));
        }
        this.approvalStore.addApprovals(approvals);
        authorizationRequest.setScope(approvedScopes);
        boolean approved = !approvedScopes.isEmpty() || requestedScopes.isEmpty();
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }
}

