/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.expression;

import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public abstract class OAuth2ExpressionUtils {
    public static boolean clientHasAnyRole(Authentication authentication, String ... roles) {
        OAuth2Request clientAuthentication;
        Collection<? extends GrantedAuthority> clientAuthorities;
        if (authentication instanceof OAuth2Authentication && (clientAuthorities = (clientAuthentication = ((OAuth2Authentication)authentication).getOAuth2Request()).getAuthorities()) != null) {
            Set roleSet = AuthorityUtils.authorityListToSet(clientAuthorities);
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (roleSet.contains(role)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isOAuth(Authentication authentication) {
        return authentication instanceof OAuth2Authentication;
    }

    public static boolean isOAuthClientAuth(Authentication authentication) {
        if (authentication instanceof OAuth2Authentication) {
            return authentication.isAuthenticated() && ((OAuth2Authentication)authentication).isClientOnly();
        }
        return false;
    }

    public static boolean isOAuthUserAuth(Authentication authentication) {
        if (authentication instanceof OAuth2Authentication) {
            return authentication.isAuthenticated() && !((OAuth2Authentication)authentication).isClientOnly();
        }
        return false;
    }

    public static boolean hasAnyScope(Authentication authentication, String[] scopes) {
        OAuth2Request clientAuthentication;
        Set assigned;
        if (authentication instanceof OAuth2Authentication && (assigned = (clientAuthentication = ((OAuth2Authentication)authentication).getOAuth2Request()).getScope()) != null) {
            String[] stringArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                if (assigned.contains(scope)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean hasAnyScopeMatching(Authentication authentication, String[] scopesRegex) {
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Request clientAuthentication = ((OAuth2Authentication)authentication).getOAuth2Request();
            for (String scope : clientAuthentication.getScope()) {
                String[] stringArray = scopesRegex;
                int n = scopesRegex.length;
                int n2 = 0;
                while (n2 < n) {
                    String regex = stringArray[n2];
                    if (scope.matches(regex)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }
}

