/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizeTag {
    private String access;
    private String url;
    private String method = "GET";
    private String ifAllGranted;
    private String ifAnyGranted;
    private String ifNotGranted;

    protected abstract ServletRequest getRequest();

    protected abstract ServletResponse getResponse();

    protected abstract ServletContext getServletContext();

    public boolean authorize() throws IOException {
        boolean isAuthorized = StringUtils.hasText((String)this.getAccess()) ? this.authorizeUsingAccessExpression() : (StringUtils.hasText((String)this.getUrl()) ? this.authorizeUsingUrlCheck() : this.authorizeUsingGrantedAuthorities());
        return isAuthorized;
    }

    public boolean authorizeUsingGrantedAuthorities() {
        Set<String> expectNoneOfRoles;
        Set<String> expectOneOfRoles;
        Set<String> requiredRoles;
        boolean hasTextAllGranted = StringUtils.hasText((String)this.getIfAllGranted());
        boolean hasTextAnyGranted = StringUtils.hasText((String)this.getIfAnyGranted());
        boolean hasTextNotGranted = StringUtils.hasText((String)this.getIfNotGranted());
        if (!(hasTextAllGranted || hasTextAnyGranted || hasTextNotGranted)) {
            return false;
        }
        Collection<? extends GrantedAuthority> granted = this.getPrincipalAuthorities();
        Set<String> grantedRoles = this.authoritiesToRoles(granted);
        if (hasTextAllGranted && !grantedRoles.containsAll(requiredRoles = this.splitRoles(this.getIfAllGranted()))) {
            return false;
        }
        if (hasTextAnyGranted && !this.containsAnyValue(grantedRoles, expectOneOfRoles = this.splitRoles(this.getIfAnyGranted()))) {
            return false;
        }
        return !hasTextNotGranted || !this.containsAnyValue(expectNoneOfRoles = this.splitRoles(this.getIfNotGranted()), grantedRoles);
    }

    public boolean authorizeUsingAccessExpression() throws IOException {
        Expression accessExpression;
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return false;
        }
        SecurityExpressionHandler<FilterInvocation> handler = this.getExpressionHandler();
        try {
            accessExpression = handler.getExpressionParser().parseExpression(this.getAccess());
        }
        catch (ParseException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        return ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)this.createExpressionEvaluationContext(handler));
    }

    protected EvaluationContext createExpressionEvaluationContext(SecurityExpressionHandler<FilterInvocation> handler) {
        FilterInvocation f = new FilterInvocation(this.getRequest(), this.getResponse(), new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                throw new UnsupportedOperationException();
            }
        });
        return handler.createEvaluationContext(SecurityContextHolder.getContext().getAuthentication(), (Object)f);
    }

    public boolean authorizeUsingUrlCheck() throws IOException {
        String contextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        return this.getPrivilegeEvaluator().isAllowed(contextPath, this.getUrl(), this.getMethod(), currentUser);
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method != null ? method.toUpperCase() : null;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public void setIfAllGranted(String ifAllGranted) {
        this.ifAllGranted = ifAllGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) {
        this.ifAnyGranted = ifAnyGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    public void setIfNotGranted(String ifNotGranted) {
        this.ifNotGranted = ifNotGranted;
    }

    private Collection<? extends GrantedAuthority> getPrincipalAuthorities() {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (null == currentUser) {
            return Collections.emptyList();
        }
        return currentUser.getAuthorities();
    }

    private Set<String> splitRoles(String authorityString) {
        String[] rolesArray = StringUtils.tokenizeToStringArray((String)authorityString, (String)",");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        for (String role : rolesArray) {
            roles.add(role);
        }
        return roles;
    }

    private boolean containsAnyValue(Set<String> toTest, Collection<String> values) {
        for (String value : values) {
            if (!toTest.contains(value)) continue;
            return true;
        }
        return false;
    }

    private Set<String> authoritiesToRoles(Collection<? extends GrantedAuthority> c) {
        HashSet<String> target = new HashSet<String>();
        for (GrantedAuthority grantedAuthority : c) {
            if (null == grantedAuthority.getAuthority()) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + grantedAuthority.toString());
            }
            target.add(grantedAuthority.getAuthority());
        }
        return target;
    }

    private SecurityExpressionHandler<FilterInvocation> getExpressionHandler() throws IOException {
        WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map handlers = appContext.getBeansOfType(SecurityExpressionHandler.class);
        for (SecurityExpressionHandler h : handlers.values()) {
            if (!FilterInvocation.class.equals((Object)GenericTypeResolver.resolveTypeArgument(h.getClass(), SecurityExpressionHandler.class))) continue;
            return h;
        }
        throw new IOException("No visible WebSecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in JSP 'authorize' tags.");
    }

    private WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() throws IOException {
        WebInvocationPrivilegeEvaluator privEvaluatorFromRequest = (WebInvocationPrivilegeEvaluator)this.getRequest().getAttribute(WebAttributes.WEB_INVOCATION_PRIVILEGE_EVALUATOR_ATTRIBUTE);
        if (privEvaluatorFromRequest != null) {
            return privEvaluatorFromRequest;
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map wipes = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (wipes.size() == 0) {
            throw new IOException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support the use of URL access checks in 'authorize' tags.");
        }
        return (WebInvocationPrivilegeEvaluator)wipes.values().toArray()[0];
    }
}

