/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.jdbc.JdbcTestUtils;

public abstract class SimpleJdbcTestUtils {
    private static final Log logger = LogFactory.getLog(SimpleJdbcTestUtils.class);

    public static int countRowsInTable(SimpleJdbcTemplate simpleJdbcTemplate, String tableName) {
        return simpleJdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName, new Object[0]);
    }

    public static int deleteFromTables(SimpleJdbcTemplate simpleJdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        for (int i = 0; i < tableNames.length; ++i) {
            int rowCount = simpleJdbcTemplate.update("DELETE FROM " + tableNames[i], new Object[0]);
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Deleted " + rowCount + " rows from table " + tableNames[i]));
        }
        return totalRowCount;
    }

    public static void executeSqlScript(SimpleJdbcTemplate simpleJdbcTemplate, ResourceLoader resourceLoader, String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = resourceLoader.getResource(sqlResourcePath);
        SimpleJdbcTestUtils.executeSqlScript(simpleJdbcTemplate, resource, continueOnError);
    }

    public static void executeSqlScript(SimpleJdbcTemplate simpleJdbcTemplate, Resource resource, boolean continueOnError) throws DataAccessException {
        SimpleJdbcTestUtils.executeSqlScript(simpleJdbcTemplate, new EncodedResource(resource), continueOnError);
    }

    public static void executeSqlScript(SimpleJdbcTemplate simpleJdbcTemplate, EncodedResource resource, boolean continueOnError) throws DataAccessException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing SQL script from " + resource));
        }
        long startTime = System.currentTimeMillis();
        LinkedList statements = new LinkedList();
        try {
            LineNumberReader lnr = new LineNumberReader(resource.getReader());
            String script = JdbcTestUtils.readScript(lnr);
            char delimiter = ';';
            if (!JdbcTestUtils.containsSqlScriptDelimiters(script, delimiter)) {
                delimiter = '\n';
            }
            JdbcTestUtils.splitSqlScript(script, delimiter, statements);
            for (String statement : statements) {
                try {
                    int rowsAffected = simpleJdbcTemplate.update(statement, new Object[0]);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(rowsAffected + " rows affected by SQL: " + statement));
                }
                catch (DataAccessException ex) {
                    if (continueOnError) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("SQL: " + statement + " failed"), (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Done executing SQL scriptBuilder from " + resource + " in " + elapsedTime + " ms."));
            }
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script from " + resource, (Throwable)ex);
        }
    }
}

