/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UniversalConnectionPoolManagerMBeanImpl
implements UniversalConnectionPoolManagerMBean {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolManagerMBeanImpl.class.getCanonicalName());
    private static UniversalConnectionPoolManagerMBeanImpl m_poolManagerBeanInstance = null;
    private static UniversalConnectionPoolManagerHelper m_poolManagerHelper = null;
    private static UniversalConnectionPoolManager m_poolManagerInstance = null;
    private static MBeanServer m_mbeanServer = (MBeanServer)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            return UniversalConnectionPoolManagerMBeanImpl.createMBeanServer();
        }
    });

    private UniversalConnectionPoolManagerMBeanImpl() {
    }

    public static synchronized UniversalConnectionPoolManagerMBean getUniversalConnectionPoolManagerMBean() throws UniversalConnectionPoolException {
        try {
            if (m_mbeanServer != null) {
                m_poolManagerInstance = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                if (m_poolManagerBeanInstance == null) {
                    m_poolManagerBeanInstance = new UniversalConnectionPoolManagerMBeanImpl();
                    String objectName = "oracle.ucp.admin:name=UniversalConnectionPoolManagerMBean";
                    String beanDisplayName = "UniversalConnectionPoolManagerMBean";
                    String objectReference = "ObjectReference";
                    final ObjectName name = new ObjectName("oracle.ucp.admin:name=UniversalConnectionPoolManagerMBean");
                    ModelMBeanInfo mbeanInfo = UniversalConnectionPoolManagerMBeanImpl.getMBeanInfo(name, "UniversalConnectionPoolManagerMBean");
                    final RequiredModelMBean rmm = new RequiredModelMBean(mbeanInfo);
                    rmm.setManagedResource(m_poolManagerBeanInstance, "ObjectReference");
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                            m_mbeanServer.registerMBean(rmm, name);
                            return null;
                        }
                    });
                    logger.fine("Universal Connection Pool Manager MBean created");
                }
            } else {
                m_poolManagerInstance.setJmxEnabled(false);
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        logger.log(Level.FINEST, "returns {0}", m_poolManagerBeanInstance);
        return m_poolManagerBeanInstance;
    }

    public void startConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.startConnectionPool(poolName);
    }

    public void stopConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.stopConnectionPool(poolName);
    }

    public void refreshConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.refreshConnectionPool(poolName);
    }

    public void recycleConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.recycleConnectionPool(poolName);
    }

    public void purgeConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.purgeConnectionPool(poolName);
    }

    public UniversalConnectionPoolMBean createConnectionPool(UniversalConnectionPoolAdapter ucpAdapter) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "parameter ucpAdapter: {0}", ucpAdapter);
        try {
            m_poolManagerInstance.createConnectionPool(ucpAdapter);
            UniversalConnectionPoolMBean poolMBean = ucpAdapter.createUniversalConnectionPoolMBean();
            assert (poolMBean != null);
            this.registerUniversalConnectionPoolMBean(poolMBean);
            return poolMBean;
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(386, e);
            return null;
        }
    }

    public void destroyConnectionPool(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.destroyConnectionPool(poolName);
    }

    public String[] getConnectionPoolNames() throws UniversalConnectionPoolException {
        return m_poolManagerInstance.getConnectionPoolNames();
    }

    public synchronized void registerUniversalConnectionPoolMBean(UniversalConnectionPoolMBean poolMBean) throws UniversalConnectionPoolException {
        if (poolMBean == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(380);
        }
        try {
            String mbeanDisplayName = "UniversalConnectionPoolMBean";
            String objectReference = "ObjectReference";
            m_poolManagerHelper = new UniversalConnectionPoolManagerHelper(m_poolManagerInstance.getConnectionPool(poolMBean.getName()));
            String uniquePoolID = m_poolManagerHelper.getManagerPoolID();
            String beanName = "oracle.ucp.admin.UniversalConnectionPoolMBean:name=" + uniquePoolID;
            logger.log(Level.FINEST, "registering  UniversalConnectionPoolMBean {0} for {1}", new Object[]{beanName, poolMBean.getName()});
            final ObjectName name = new ObjectName(beanName);
            if (m_mbeanServer != null) {
                ModelMBeanInfo mbeanInfo = poolMBean.getMBeanInfo(name, "UniversalConnectionPoolMBean");
                final RequiredModelMBean rmm = new RequiredModelMBean(mbeanInfo);
                rmm.setManagedResource(poolMBean, "ObjectReference");
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                        m_mbeanServer.registerMBean(rmm, name);
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
    }

    public synchronized void unregisterUniversalConnectionPoolMBean(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        logger.log(Level.FINEST, " unregistering  UniversalConnectionPoolMBean for {0}", poolName);
        try {
            String objectName = "oracle.ucp.admin.UniversalConnectionPoolMBean:name=";
            m_poolManagerHelper = new UniversalConnectionPoolManagerHelper(m_poolManagerInstance.getConnectionPool(poolName));
            final ObjectName name = new ObjectName("oracle.ucp.admin.UniversalConnectionPoolMBean:name=" + m_poolManagerHelper.getManagerPoolID());
            if (m_mbeanServer != null) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, MBeanRegistrationException {
                        m_mbeanServer.unregisterMBean(name);
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
    }

    public void startMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.startMetricsCollection(poolName);
    }

    public void stopMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "poolName: {0}", poolName);
        m_poolManagerInstance.stopMetricsCollection(poolName);
    }

    public synchronized void setMetricUpdateInterval(int interval) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "interval: {0}", interval);
        m_poolManagerInstance.setMetricUpdateInterval(interval);
    }

    public int getMetricUpdateInterval() {
        return m_poolManagerInstance.getMetricUpdateInterval();
    }

    public UniversalConnectionPoolLifeCycleState getConnectionPoolLifeCycleState(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        UniversalConnectionPool pool = m_poolManagerInstance.getConnectionPool(poolName);
        logger.log(Level.FINEST, "{0} returns {1}", new Object[]{poolName, pool.getLifeCycleState()});
        return pool.getLifeCycleState();
    }

    public void setLogLevel(Level newLogLevel) {
        m_poolManagerInstance.setLogLevel(newLogLevel);
    }

    public Level getLogLevel() {
        return m_poolManagerInstance.getLogLevel();
    }

    private static ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanManagerDisplayName) throws UniversalConnectionPoolException {
        assert (mbeanObjName != null);
        assert (mbeanManagerDisplayName != null);
        logger.finest("constructing MBeanInfo");
        ModelMBeanInfoSupport modelMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanManagerName = "oracle.ucp.admin.UniversalConnectionPoolManagerMBean";
            String mbeanManagerDescription = "UniversalConnectionPoolManagerMBeanImpl Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + mbeanObjName, "descriptorType=mbean", "displayName=" + mbeanManagerDisplayName);
            modelMBeanInfo = new ModelMBeanInfoSupport("oracle.ucp.admin.UniversalConnectionPoolManagerMBean", "UniversalConnectionPoolManagerMBeanImpl Object", UniversalConnectionPoolManagerMBeanImpl.getAttributesInfo(), UniversalConnectionPoolManagerMBeanImpl.getConstructorsInfo(), UniversalConnectionPoolManagerMBeanImpl.getOperationsInfo(), UniversalConnectionPoolManagerMBeanImpl.getNotificationsInfo());
            modelMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(361, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(360, e);
        }
        return modelMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] constInfo = new ModelMBeanConstructorInfo[]{};
        return constInfo;
    }

    private static ModelMBeanAttributeInfo[] getAttributesInfo() throws UniversalConnectionPoolException {
        ModelMBeanAttributeInfo[] managerAtributesInfo = new ModelMBeanAttributeInfo[2];
        logger.finest("constructing AttributesInfo");
        try {
            DescriptorSupport metricUpdateIntervalAttribute = new DescriptorSupport();
            metricUpdateIntervalAttribute.setField("name", "MetricUpdateInterval");
            metricUpdateIntervalAttribute.setField("descriptorType", "attribute");
            metricUpdateIntervalAttribute.setField("displayName", UCPErrorHandler.findMessage("MetricUpdateIntervalAttrDisplayName"));
            metricUpdateIntervalAttribute.setField("getMethod", "getMetricUpdateInterval");
            metricUpdateIntervalAttribute.setField("setMethod", "setMetricUpdateInterval");
            metricUpdateIntervalAttribute.setField("currencyTimeLimit", "0");
            managerAtributesInfo[0] = new ModelMBeanAttributeInfo("MetricUpdateInterval", "int", UCPErrorHandler.findMessage("MetricUpdateIntervalAttrDescription"), true, true, false, metricUpdateIntervalAttribute);
            DescriptorSupport logLevelAttribute = new DescriptorSupport();
            logLevelAttribute.setField("name", "LogLevel");
            logLevelAttribute.setField("descriptorType", "attribute");
            logLevelAttribute.setField("displayName", UCPErrorHandler.findMessage("LogLevelAttrDisplayName"));
            logLevelAttribute.setField("getMethod", "getLogLevel");
            logLevelAttribute.setField("setMethod", "setLogLevel");
            logLevelAttribute.setField("currencyTimeLimit", "0");
            managerAtributesInfo[1] = new ModelMBeanAttributeInfo("LogLevel", "java.util.logging.Level", UCPErrorHandler.findMessage("LogLevelAttrDescription"), true, true, false, logLevelAttribute);
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(363, e);
        }
        return managerAtributesInfo;
    }

    private static ModelMBeanOperationInfo[] getOperationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanOperationInfo[] managerOperationsInfo = new ModelMBeanOperationInfo[15];
        logger.finest("constructing OperationsInfo");
        try {
            MBeanParameterInfo[] params = null;
            String mBeanName = "oracle.ucp.admin.UniversalConnectionPoolManagerMBean";
            DescriptorSupport startConnectionPoolOperation = new DescriptorSupport();
            startConnectionPoolOperation.setField("name", "startConnectionPool");
            startConnectionPoolOperation.setField("descriptorType", "operation");
            startConnectionPoolOperation.setField("class", mBeanName);
            startConnectionPoolOperation.setField("role", "operation");
            managerOperationsInfo[0] = new ModelMBeanOperationInfo("startConnectionPool", UCPErrorHandler.findMessage("StartConnectionPoolOperationDescription"), params, "void", 1, startConnectionPoolOperation);
            DescriptorSupport stopConnectionPoolOperation = new DescriptorSupport();
            stopConnectionPoolOperation.setField("name", "stopConnectionPool");
            stopConnectionPoolOperation.setField("descriptorType", "operation");
            stopConnectionPoolOperation.setField("class", mBeanName);
            stopConnectionPoolOperation.setField("role", "operation");
            managerOperationsInfo[1] = new ModelMBeanOperationInfo("stopConnectionPool", UCPErrorHandler.findMessage("StopConnectionPoolOperationDescription"), params, "void", 1, stopConnectionPoolOperation);
            DescriptorSupport destroyConnectionPoolOPeration = new DescriptorSupport();
            destroyConnectionPoolOPeration.setField("name", "destroyConnectionPool");
            destroyConnectionPoolOPeration.setField("descriptorType", "operation");
            destroyConnectionPoolOPeration.setField("class", mBeanName);
            destroyConnectionPoolOPeration.setField("role", "operation");
            managerOperationsInfo[2] = new ModelMBeanOperationInfo("destroyConnectionPool", UCPErrorHandler.findMessage("DestroyConnectionPoolOperationDescription"), params, "void", 1, destroyConnectionPoolOPeration);
            DescriptorSupport startMetricsCollectionOperation = new DescriptorSupport();
            startMetricsCollectionOperation.setField("name", "startMetricsCollection");
            startMetricsCollectionOperation.setField("descriptorType", "operation");
            startMetricsCollectionOperation.setField("class", mBeanName);
            startMetricsCollectionOperation.setField("role", "operation");
            managerOperationsInfo[3] = new ModelMBeanOperationInfo("startMetricsCollection", UCPErrorHandler.findMessage("StartMetricCollectionOperationDescription"), params, "void", 1, startMetricsCollectionOperation);
            DescriptorSupport stopMetricsCollectionOperation = new DescriptorSupport();
            stopMetricsCollectionOperation.setField("name", "stopMetricsCollection");
            stopMetricsCollectionOperation.setField("descriptorType", "operation");
            stopMetricsCollectionOperation.setField("class", mBeanName);
            stopMetricsCollectionOperation.setField("role", "operation");
            managerOperationsInfo[4] = new ModelMBeanOperationInfo("stopMetricsCollection", UCPErrorHandler.findMessage("StopMetricCollectionOperationDescription"), params, "void", 1, stopMetricsCollectionOperation);
            DescriptorSupport refreshConnectionPoolOperation = new DescriptorSupport();
            refreshConnectionPoolOperation.setField("name", "refreshConnectionPool");
            refreshConnectionPoolOperation.setField("descriptorType", "operation");
            refreshConnectionPoolOperation.setField("class", mBeanName);
            refreshConnectionPoolOperation.setField("role", "operation");
            managerOperationsInfo[5] = new ModelMBeanOperationInfo("refreshConnectionPool", UCPErrorHandler.findMessage("RefreshConnectionPoolOperationDescription"), params, "void", 1, refreshConnectionPoolOperation);
            DescriptorSupport recycleConnectionPoolOperation = new DescriptorSupport();
            recycleConnectionPoolOperation.setField("name", "recycleConnectionPool");
            recycleConnectionPoolOperation.setField("descriptorType", "operation");
            recycleConnectionPoolOperation.setField("class", mBeanName);
            recycleConnectionPoolOperation.setField("role", "operation");
            managerOperationsInfo[6] = new ModelMBeanOperationInfo("recycleConnectionPool", UCPErrorHandler.findMessage("RecycleConnectionPoolOperationDescription"), params, "void", 1, recycleConnectionPoolOperation);
            DescriptorSupport purgeConnectionPoolOperation = new DescriptorSupport();
            purgeConnectionPoolOperation.setField("name", "purgeConnectionPool");
            purgeConnectionPoolOperation.setField("descriptorType", "operation");
            purgeConnectionPoolOperation.setField("class", mBeanName);
            purgeConnectionPoolOperation.setField("role", "operation");
            managerOperationsInfo[7] = new ModelMBeanOperationInfo("purgeConnectionPool", UCPErrorHandler.findMessage("PurgeConnectionPoolOperationDescription"), params, "void", 1, purgeConnectionPoolOperation);
            DescriptorSupport getConnectionPoolNamesOperation = new DescriptorSupport();
            getConnectionPoolNamesOperation.setField("name", "getConnectionPoolNames");
            getConnectionPoolNamesOperation.setField("descriptorType", "operation");
            getConnectionPoolNamesOperation.setField("class", mBeanName);
            getConnectionPoolNamesOperation.setField("role", "operation");
            managerOperationsInfo[8] = new ModelMBeanOperationInfo("getConnectionPoolNames", UCPErrorHandler.findMessage("GetConnectionPoolNamesOperationDescription"), params, "void", 1, getConnectionPoolNamesOperation);
            DescriptorSupport getConnectionPoolLifeCycleStateOperation = new DescriptorSupport();
            getConnectionPoolLifeCycleStateOperation.setField("name", "getConnectionPoolLifeCycleState");
            getConnectionPoolLifeCycleStateOperation.setField("descriptorType", "operation");
            getConnectionPoolLifeCycleStateOperation.setField("class", mBeanName);
            getConnectionPoolLifeCycleStateOperation.setField("role", "operation");
            managerOperationsInfo[9] = new ModelMBeanOperationInfo("getConnectionPoolLifeCycleState", UCPErrorHandler.findMessage("GetConnectionPoolLifeCycleStateOperationDescription"), params, "UniversalConnectionPoolLifeCycleState", 1, getConnectionPoolLifeCycleStateOperation);
            DescriptorSupport getMetricUpdateIntervalOperation = new DescriptorSupport();
            getMetricUpdateIntervalOperation.setField("name", "getMetricUpdateInterval");
            getMetricUpdateIntervalOperation.setField("descriptorType", "operation");
            getMetricUpdateIntervalOperation.setField("class", mBeanName);
            getMetricUpdateIntervalOperation.setField("role", "getter");
            managerOperationsInfo[10] = new ModelMBeanOperationInfo("getMetricUpdateInterval", UCPErrorHandler.findMessage("GetMetricUpdateIntervalOperationDescription"), params, "int", 0, getMetricUpdateIntervalOperation);
            DescriptorSupport setMetricUpdateIntervalOperation = new DescriptorSupport();
            setMetricUpdateIntervalOperation.setField("name", "setMetricUpdateInterval");
            setMetricUpdateIntervalOperation.setField("descriptorType", "operation");
            setMetricUpdateIntervalOperation.setField("class", mBeanName);
            setMetricUpdateIntervalOperation.setField("role", "setter");
            String setMetricUpdateIntervalOperationDescription = UCPErrorHandler.findMessage("SetMetricUpdateIntervalOperationDescription");
            MBeanParameterInfo[] metricIntervalParams = new MBeanParameterInfo[]{new MBeanParameterInfo("interval", "java.lang.Integer", setMetricUpdateIntervalOperationDescription)};
            managerOperationsInfo[11] = new ModelMBeanOperationInfo("setMetricUpdateInterval", setMetricUpdateIntervalOperationDescription, metricIntervalParams, "void", 1, setMetricUpdateIntervalOperation);
            DescriptorSupport getLogLevelOperation = new DescriptorSupport();
            getLogLevelOperation.setField("name", "getLogLevel");
            getLogLevelOperation.setField("descriptorType", "operation");
            getLogLevelOperation.setField("class", mBeanName);
            getLogLevelOperation.setField("role", "getter");
            managerOperationsInfo[12] = new ModelMBeanOperationInfo("getLogLevel", UCPErrorHandler.findMessage("GetLogLevelOperationDescription"), params, "java.util.logging.Level", 0, getLogLevelOperation);
            DescriptorSupport setLogLevelOperation = new DescriptorSupport();
            setLogLevelOperation.setField("name", "setLogLevel");
            setLogLevelOperation.setField("descriptorType", "operation");
            setLogLevelOperation.setField("class", mBeanName);
            setLogLevelOperation.setField("role", "setter");
            String setLogLevelOperationDescription = UCPErrorHandler.findMessage("SetLogLevelOperationDescription");
            MBeanParameterInfo[] logParams = new MBeanParameterInfo[]{new MBeanParameterInfo("newLogLevel", "java.util.logging.Level", setLogLevelOperationDescription)};
            managerOperationsInfo[13] = new ModelMBeanOperationInfo("setLogLevel", setLogLevelOperationDescription, logParams, "void", 1, setLogLevelOperation);
            DescriptorSupport createConnectionPoolOperation = new DescriptorSupport();
            createConnectionPoolOperation.setField("name", "createConnectionPool");
            createConnectionPoolOperation.setField("descriptorType", "operation");
            createConnectionPoolOperation.setField("class", mBeanName);
            createConnectionPoolOperation.setField("role", "operation");
            String createConnectionPoolOperationDescription = UCPErrorHandler.findMessage("CreateConnectionPoolOperationDescription");
            MBeanParameterInfo[] poolConfigParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ucpAdapter", "oracle.ucp.UniversalConnectionPoolAdapter", createConnectionPoolOperationDescription)};
            managerOperationsInfo[14] = new ModelMBeanOperationInfo("createConnectionPool", createConnectionPoolOperationDescription, poolConfigParams, "oracle.ucp.admin.UniversalConnectionPoolMBean", 1, createConnectionPoolOperation);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(364, e);
        }
        return managerOperationsInfo;
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanNotificationInfo[] notifInfo = new ModelMBeanNotificationInfo[]{};
        return notifInfo;
    }

    private static MBeanServer createMBeanServer() {
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
            logger.log(Level.FINEST, "returns JDK's MBeanServer {0}", mbeanServer);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Cannot create Platform MBean Server. ", e);
        }
        return mbeanServer;
    }

    static {
        try {
            ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory", true, clsLoader);
            Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
            m_mbeanServer = (MBeanServer)mthd.invoke(cls.newInstance(), new Object[0]);
            logger.log(Level.FINEST, "AS MBeanServer loaded {0}", m_mbeanServer);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Failed to get OracleAS MBean Server. Continue to use the JDK Platform MBean Server.", e);
        }
    }
}

