/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class JDBCConnectionPool
extends UniversalConnectionPoolImpl {
    private static final Logger logger = UCPLoggerFactory.createLogger(JDBCConnectionPool.class.getCanonicalName());
    private String m_SQLForValidateConnection = null;
    private int m_maxStatements = 0;

    public JDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        JDBCUniversalPooledConnection conn;
        if (SQLString != null && SQLString.equals("")) {
            SQLException sqle = UCPErrorHandler.newSQLException(22);
            logger.throwing(this.getClass().getName(), "setSQLForValidateConnection", sqle);
            throw sqle;
        }
        if (this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING && null != SQLString && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            Statement stmt = null;
            try {
                stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                stmt.execute(SQLString);
            }
            catch (SQLException e) {
                int err = e.getErrorCode();
                for (int perr : this.getWrongSQLCodes()) {
                    if (perr != err) continue;
                    this.setValidateConnectionOnBorrow(false);
                    throw e;
                }
            }
            finally {
                if (null != stmt) {
                    stmt.close();
                }
                this.closePhysicalConnection(conn.getPhysicalConnection());
            }
        }
        this.m_SQLForValidateConnection = SQLString;
    }

    public String getSQLForValidateConnection() {
        return this.m_SQLForValidateConnection;
    }

    public void setMaxStatements(int maxStatements) throws SQLException {
        if (maxStatements < 0) {
            SQLException sqle = UCPErrorHandler.newSQLException(22);
            logger.throwing(this.getClass().getName(), "setMaxStatements", sqle);
            throw sqle;
        }
        this.m_maxStatements = maxStatements;
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)super.borrowConnection(connectionRetrievalInfo);
        try {
            jdbcPooledConnection.setMaxStatements(this.getMaxStatements());
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e);
        }
        return jdbcPooledConnection;
    }

    protected int[] getWrongSQLCodes() {
        return new int[0];
    }
}

