/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.VimConnection;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VimPortType;
import java.util.Arrays;
import java.util.List;

public class TaskHelper {
    private VimConnection connection;

    TaskHelper(VimConnection vimConnection) {
        this.connection = vimConnection;
    }

    public boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws Exception {
        boolean bl = false;
        Object[] objectArray = this.waitForValues(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    private Object[] waitForValues(ManagedObjectReference managedObjectReference, String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Exception {
        VimPortType vimPortType = this.connection.getVimPort();
        ServiceContent serviceContent = this.connection.getServiceContent();
        String string = "";
        Object[] objectArray2 = new Object[stringArray2.length];
        Object[] objectArray3 = new Object[stringArray.length];
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.getPathSet().addAll(Arrays.asList(stringArray));
        propertySpec.setType(managedObjectReference.getType());
        propertyFilterSpec.getPropSet().add(propertySpec);
        ManagedObjectReference managedObjectReference2 = vimPortType.createFilter(serviceContent.getPropertyCollector(), propertyFilterSpec, true);
        boolean bl = false;
        UpdateSet updateSet = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        while (!bl) {
            updateSet = vimPortType.waitForUpdates(serviceContent.getPropertyCollector(), string);
            if (updateSet == null || updateSet.getFilterSet() == null) continue;
            string = updateSet.getVersion();
            list = updateSet.getFilterSet();
            for (PropertyFilterUpdate propertyFilterUpdate : list) {
                list2 = propertyFilterUpdate.getObjectSet();
                for (ObjectUpdate objectUpdate : list2) {
                    if (objectUpdate.getKind() != ObjectUpdateKind.MODIFY && objectUpdate.getKind() != ObjectUpdateKind.ENTER && objectUpdate.getKind() != ObjectUpdateKind.LEAVE) continue;
                    list3 = objectUpdate.getChangeSet();
                    for (PropertyChange propertyChange : list3) {
                        this.updateValues(stringArray2, objectArray2, propertyChange);
                        this.updateValues(stringArray, objectArray3, propertyChange);
                    }
                }
            }
            Object object = null;
            for (int i = 0; i < objectArray2.length && !bl; ++i) {
                for (int j = 0; j < objectArray[i].length && !bl; ++j) {
                    object = objectArray[i][j];
                    bl = object.equals(objectArray2[i]) || bl;
                }
            }
        }
        vimPortType.destroyPropertyFilter(managedObjectReference2);
        return objectArray3;
    }

    private void updateValues(String[] stringArray, Object[] objectArray, PropertyChange propertyChange) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (propertyChange.getName().lastIndexOf(stringArray[i]) < 0) continue;
            objectArray[i] = propertyChange.getOp() == PropertyChangeOp.REMOVE ? "" : propertyChange.getVal();
        }
    }
}

