/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public class WorkflowMessageFactory {
    private static final Logger logger = Logger.getLogger(WorkflowMessageFactory.class);

    public static WorkflowMessage createControlMessage(String uid) {
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        WorkflowMessage message = WorkflowMessageFactory.createWorkflowMessage(messageUid, null, WorkflowMessage.MessageType.control);
        message.setResponseDestination(WorkflowMessageFactory.createResponseDestination());
        return message;
    }

    public static WorkflowMessage createControlMessage(String uid, ExecutionContext ec) {
        IMessageKey key = WorkflowMessageFactory.createMessageKey(ec);
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        WorkflowMessage message = WorkflowMessageFactory.createWorkflowMessage(messageUid, key, WorkflowMessage.MessageType.control);
        message.setResponseDestination(WorkflowMessageFactory.createResponseDestination());
        return message;
    }

    public static WorkflowMessage createAckMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.createWorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
    }

    public static WorkflowMessage createNackMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.createWorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.nack);
    }

    protected static WorkflowMessage createWorkflowMessage(IMessageUID uid, IMessageKey key, WorkflowMessage.MessageType type) {
        WorkflowMessage message = new WorkflowMessage(uid, key, type);
        message.setSource(WorkflowMessageFactory.createSource());
        logger.debug((Object)("Creating Message with UID: " + uid.getUID()));
        return message;
    }

    protected static ISource createSource() {
        return (ISource)DeviceTypeUtil.createWorkflowDevice();
    }

    protected static IDestination createResponseDestination() {
        logger.debug((Object)"Creating the response destination...");
        IDestination responseDestination = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String connectionType = properties.getProperty("ResponseDestination.ConnectionType");
            String connectionString = properties.getProperty("ResponseDestination.ConnectionString");
            responseDestination = (IDestination)DeviceTypeUtil.createDevice(connectionType, connectionString);
        }
        catch (Exception ex) {
            throw new RuntimeException("Response destination cannot be set", ex);
        }
        return responseDestination;
    }

    protected static IMessageKey createMessageKey(ExecutionContext ec) {
        DefaultMessageKeyGenerator keyGenStrategy = new DefaultMessageKeyGenerator();
        IMessageKey key = keyGenStrategy.generate(ec.getToken());
        logger.debug((Object)("Message Key Created: " + key));
        return key;
    }
}

