/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.jacc.PolicyContext;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.GeneralizedAuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.web.tomcat.security.ExtendedRealm;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;

public class JBossExtendedSecurityMgrRealm
extends JBossSecurityMgrRealm
implements ExtendedRealm {
    private static Logger logger = Logger.getLogger(JBossExtendedSecurityMgrRealm.class);
    protected ObjectName authenticationManagerService = null;
    protected ObjectName authorizationManagerService = null;

    public JBossExtendedSecurityMgrRealm() {
        try {
            this.authenticationManagerService = new ObjectName("jboss.security:service=JASPISecurityManager");
            this.authorizationManagerService = new ObjectName("jboss.security:service=AuthorizationManager");
        }
        catch (JMException jme) {
            log.error((Object)"Error in instantiating object names:", (Throwable)jme);
        }
    }

    public void setAuthenticationManagerService(String oname) {
        ObjectName temp = null;
        try {
            temp = new ObjectName(oname);
        }
        catch (JMException jme) {
            log.error((Object)"Error in setAuthenticationManagerService:", (Throwable)jme);
        }
        if (temp != null) {
            this.authenticationManagerService = temp;
        }
    }

    public void setAuthorizationManagerService(String oname) {
        ObjectName temp = null;
        try {
            temp = new ObjectName(oname);
        }
        catch (JMException jme) {
            log.error((Object)"Error in setAuthorizationManagerService:", (Throwable)jme);
        }
        if (temp != null) {
            this.authorizationManagerService = temp;
        }
    }

    public Principal authenticate(Request request, Response response, LoginConfig config) throws Exception {
        log.debug((Object)"ExtendedSecurityMgrRealm:authenticate");
        GenericMessageInfo authParam = new GenericMessageInfo((Object)request, (Object)response);
        GeneralizedAuthenticationManager gam = this.getAuthenticationManager();
        Subject clientSubject = new Subject();
        Subject serviceSubject = new Subject();
        Map sharedState = this.getSharedState(request, config);
        AuthStatus status = AuthStatus.FAILURE;
        while (!status.equals(AuthStatus.SEND_CONTINUE)) {
            status = gam.validateRequest((MessageInfo)authParam, clientSubject, serviceSubject);
            if (!status.equals(AuthStatus.FAILURE)) continue;
            throw new SecurityException("Authentication failed");
        }
        Principal authenticatedPrincipal = this.getAuthenticatedPrincipal(clientSubject);
        return null;
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isAuthorized = super.hasResourcePermission(request, response, constraints, context);
        log.debug((Object)("Super class has authorized=" + isAuthorized));
        AuthorizationManager authzManager = null;
        try {
            authzManager = this.getAuthorizationManager();
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining Authorization Manager:", (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalina.request", request);
        map.put("catalina.constraints", constraints);
        map.put("catalina.context", context);
        map.put("authorizationManager", authzManager);
        WebResource resource = new WebResource(map);
        try {
            int check = authzManager.authorize((Resource)resource);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            log.error((Object)"Error in authorization:", (Throwable)e);
        }
        log.debug((Object)("Final Authorization Result=" + isAuthorized));
        if (!isAuthorized) {
            response.setStatus(403);
        }
        return isAuthorized;
    }

    private Map getSharedState(Request request, LoginConfig config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (config.getAuthMethod().equals("FORM")) {
            map.put("javax.security.auth.login.name", this.getPrincipal(request.getParameter("j_username")));
            map.put("javax.security.auth.login.password", request.getParameter("j_password"));
        }
        return map;
    }

    protected Principal getCachingPrincipal(AuthorizationManager authzManager, Principal authPrincipal, Principal callerPrincipal, Object credential, Subject subject) {
        Set userRoles = authzManager.getUserRoles(authPrincipal);
        ArrayList<String> roles = new ArrayList<String>();
        if (userRoles != null) {
            for (Principal role : userRoles) {
                roles.add(role.getName());
            }
        }
        JBossGenericPrincipal gp = new JBossGenericPrincipal(this, subject, authPrincipal, callerPrincipal, credential, roles, userRoles);
        return gp;
    }

    private Principal getAuthenticatedPrincipal(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject is null");
        }
        Principal authPrincipal = null;
        Iterator<SimplePrincipal> iter = subject.getPrincipals(SimplePrincipal.class).iterator();
        while (iter.hasNext() && (authPrincipal = (Principal)iter.next()) instanceof Group) {
        }
        return authPrincipal;
    }

    private GeneralizedAuthenticationManager getAuthenticationManager() throws Exception {
        String contextID = PolicyContext.getContextID();
        MBeanServer server = MBeanServerLocator.locateJBoss();
        String securityDomain = (String)server.invoke(this.authenticationManagerService, "getSecurityDomain", new String[]{contextID}, new String[]{"java.lang.String"});
        return (GeneralizedAuthenticationManager)server.invoke(this.authenticationManagerService, "getSecurityManager", new String[]{securityDomain}, new String[]{"java.lang.String"});
    }

    private AuthorizationManager getAuthorizationManager() throws Exception {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        GeneralizedAuthenticationManager gam = this.getAuthenticationManager();
        String securityDomain = gam.getSecurityDomain();
        return (AuthorizationManager)server.invoke(this.authorizationManagerService, "getAuthorizationManager", new String[]{securityDomain}, new String[]{"java.lang.String"});
    }
}

