/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Proxy;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.ClassResolver;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.persister.Persister;

public class ClassReferencePersister
implements Persister {
    byte id;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void writeData(ClassMetaData clazzMetaData, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        Class clazz = (Class)obj;
        boolean isProxy = clazzMetaData.isProxy();
        output.writeBoolean(isProxy);
        if (isProxy) {
            Class<?>[] interfaces = clazz.getInterfaces();
            output.writeInt(interfaces.length);
            for (int i = 0; i < interfaces.length; ++i) {
                output.writeUTF(interfaces[i].getName());
            }
        } else {
            output.writeUTF(clazz.getName());
        }
    }

    public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        boolean isProxy = input.readBoolean();
        if (isProxy) {
            int size = input.readInt();
            Class[] interfaces = new Class[size];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = this.lookupClass(cache.getClassResolver(), loader, input.readUTF());
            }
            Class<?> proxyReturn = Proxy.getProxyClass(loader, interfaces);
            cache.putObjectInCacheRead(referenceId, proxyReturn);
            return proxyReturn;
        }
        String name = input.readUTF();
        Class classReturn = this.lookupClass(cache.getClassResolver(), loader, name);
        cache.putObjectInCacheRead(referenceId, classReturn);
        return classReturn;
    }

    private Class lookupClass(ClassResolver resolver, ClassLoader loader, String name) throws IOException {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        ClassMetaData metaData = ClassMetamodelFactory.getClassMetaData(name, resolver, loader, false);
        return metaData.getClazz();
    }

    public boolean canPersist(Object obj) {
        return false;
    }
}

