/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.system.server.NoAnnotationURLClassLoader;
import org.jboss.system.server.Server;

public class ServerLoader {
    public static final String DEFAULT_BOOT_LIBRARY_LIST = "log4j-boot.jar,jboss-common.jar,jboss-system.jar,jboss-xml-binding.jar,namespace.jar";
    public static final String DEFAULT_SERVER_TYPE = "org.jboss.system.server.ServerImpl";
    protected Properties props;
    protected URL libraryURL;
    protected List extraClasspath = new LinkedList();

    public ServerLoader(Properties props) throws Exception {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        this.props = props;
        URL homeURL = this.getURL("jboss.home.url");
        if (homeURL == null) {
            throw new Exception("Missing configuration value for: jboss.home.url");
        }
        this.libraryURL = this.getURL("jboss.lib.url");
        if (this.libraryURL == null) {
            this.libraryURL = new URL(homeURL, "lib/");
        }
        if (homeURL.getProtocol().startsWith("http")) {
            this.addLibrary("webdavlib.jar");
            this.addLibrary("commons-httpclient.jar");
            this.addLibrary("commons-logging.jar");
        }
    }

    public void addLibrary(String filename) throws MalformedURLException {
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        URL jarURL = new URL(this.libraryURL, filename);
        this.extraClasspath.add(jarURL);
    }

    public void addLibraries(String filenames) throws MalformedURLException {
        if (filenames == null) {
            throw new IllegalArgumentException("filenames is null");
        }
        StringTokenizer stok = new StringTokenizer(filenames, ",");
        while (stok.hasMoreElements()) {
            this.addLibrary(stok.nextToken().trim());
        }
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        this.extraClasspath.add(url);
    }

    public void addEndorsedJars() throws MalformedURLException {
        File endorsedDir = new File(this.libraryURL.getPath() + "/endorsed");
        if (endorsedDir.exists()) {
            String[] list = endorsedDir.list();
            for (int i = 0; list != null && i < list.length; ++i) {
                String jarname = list[i];
                this.addLibrary("endorsed/" + jarname);
            }
        }
    }

    protected URL getURL(String name) throws MalformedURLException {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            return new URL(value);
        }
        return null;
    }

    protected URL[] getBootClasspath() throws MalformedURLException {
        LinkedList<URL> list = new LinkedList<URL>();
        list.addAll(this.extraClasspath);
        String value = this.props.getProperty("jboss.boot.library.list", DEFAULT_BOOT_LIBRARY_LIST);
        StringTokenizer stok = new StringTokenizer(value, ",");
        while (stok.hasMoreElements()) {
            URL url = new URL(this.libraryURL, stok.nextToken().trim());
            list.add(url);
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server load(ClassLoader parent) throws Exception {
        Server server;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            URL[] urls = this.getBootClasspath();
            NoAnnotationURLClassLoader classLoader = new NoAnnotationURLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            String typename = this.props.getProperty("jboss.server.type", DEFAULT_SERVER_TYPE);
            server = this.createServer(typename, (ClassLoader)classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return server;
    }

    protected Server createServer(String typename, ClassLoader classLoader) throws Exception {
        Class<?> type = classLoader.loadClass(typename);
        Server server = (Server)type.newInstance();
        return server;
    }
}

