/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.InputStream;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.XmlConfigurationParser2x;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.jmx.PlatformMBeanServerRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheFactory<K, V>
extends ComponentFactory
implements CacheFactory<K, V> {
    private ClassLoader defaultClassLoader;

    @Deprecated
    public static CacheFactory getInstance() {
        return new DefaultCacheFactory();
    }

    @Override
    public Cache<K, V> createCache() throws ConfigurationException {
        return this.createCache(true);
    }

    @Override
    public Cache<K, V> createCache(boolean start) throws ConfigurationException {
        return this.createCache(new Configuration(), start);
    }

    @Override
    public Cache<K, V> createCache(String configFileName) throws ConfigurationException {
        return this.createCache(configFileName, true);
    }

    @Override
    public Cache<K, V> createCache(String configFileName, boolean start) throws ConfigurationException {
        Configuration c;
        block5: {
            XmlConfigurationParser parser = new XmlConfigurationParser();
            try {
                c = parser.parseFile(configFileName);
            }
            catch (ConfigurationException e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Had problems parsing configuration file.", (Throwable)e);
                    this.log.trace((Object)"Attempting to use a legacy parser.");
                }
                try {
                    XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
                    c = oldParser.parseFile(configFileName);
                }
                catch (Exception e2) {
                    throw e;
                }
                if (c == null || !this.log.isInfoEnabled()) break block5;
                this.log.info((Object)"Detected legacy configuration file format when parsing configuration file.  Migrating to the new (3.x) file format is recommended.  See FAQs for details.");
            }
        }
        return this.createCache(c, start);
    }

    @Override
    public Cache<K, V> createCache(Configuration configuration) throws ConfigurationException {
        return this.createCache(configuration, true);
    }

    @Override
    public Cache<K, V> createCache(Configuration configuration, boolean start) throws ConfigurationException {
        try {
            CacheSPI<K, V> cache = this.createAndWire(configuration);
            if (start) {
                cache.start();
            }
            return cache;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CacheSPI<K, V> createAndWire(Configuration configuration) throws Exception {
        CacheInvocationDelegate spi = new CacheInvocationDelegate();
        this.bootstrap(spi, configuration);
        return spi;
    }

    private void bootstrap(CacheSPI spi, Configuration configuration) {
        this.componentRegistry = new ComponentRegistry(configuration, spi);
        this.componentRegistry.registerDefaultClassLoader(this.defaultClassLoader);
        this.configuration = configuration;
        this.componentRegistry.registerComponent(spi, CacheSPI.class);
        this.componentRegistry.registerComponent(new PlatformMBeanServerRegistration(), PlatformMBeanServerRegistration.class);
    }

    public void setDefaultClassLoader(ClassLoader loader) {
        this.defaultClassLoader = loader;
    }

    @Override
    public Cache<K, V> createCache(InputStream is) throws ConfigurationException {
        Configuration c;
        block5: {
            XmlConfigurationParser parser = new XmlConfigurationParser();
            c = null;
            try {
                c = parser.parseStream(is);
            }
            catch (ConfigurationException e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Had problems parsing configuration file.", (Throwable)e);
                    this.log.trace((Object)"Attempting to use a legacy parser.");
                }
                try {
                    XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
                    c = oldParser.parseStream(is);
                }
                catch (Exception e2) {
                    throw e;
                }
                if (c == null || !this.log.isInfoEnabled()) break block5;
                this.log.info((Object)"Detected legacy configuration file format when parsing configuration file.  Migrating to the new (3.x) file format is recommended.  See FAQs for details.");
            }
        }
        return this.createCache(c);
    }

    @Override
    public Cache<K, V> createCache(InputStream is, boolean start) throws ConfigurationException {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseStream(is);
        return this.createCache(c, start);
    }

    @Override
    protected <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

