/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing.element;

import java.util.Map;
import java.util.Properties;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlParserBase;
import org.w3c.dom.Element;

public class BuddyElementParser
extends XmlParserBase {
    public BuddyReplicationConfig parseBuddyElement(Element element) {
        String buddyCommunicationTimeout;
        this.assertNotLegacyElement(element);
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        String enabled = this.getAttributeValue(element, "enabled");
        brc.setEnabled(this.getBoolean(enabled));
        String buddyPoolName = this.getAttributeValue(element, "poolName");
        if (this.existsAttribute(buddyPoolName)) {
            brc.setBuddyPoolName(buddyPoolName);
        }
        if (this.existsAttribute(buddyCommunicationTimeout = this.getAttributeValue(element, "communicationTimeout"))) {
            brc.setBuddyCommunicationTimeout(this.getInt(buddyCommunicationTimeout));
        }
        this.parseDataGravitationElement(this.getSingleElementInCoreNS("dataGravitation", element), brc);
        BuddyReplicationConfig.BuddyLocatorConfig blc = this.parseBuddyLocatorConfig(this.getSingleElementInCoreNS("locator", element));
        brc.setBuddyLocatorConfig(blc);
        return brc;
    }

    private BuddyReplicationConfig.BuddyLocatorConfig parseBuddyLocatorConfig(Element element) {
        if (element == null) {
            return this.defaultBuddyLocatorConfig();
        }
        BuddyReplicationConfig.BuddyLocatorConfig result = new BuddyReplicationConfig.BuddyLocatorConfig();
        String buddyLocatorClass = this.getAttributeValue(element, "class");
        if (this.existsAttribute(buddyLocatorClass)) {
            result.setBuddyLocatorClass(buddyLocatorClass);
        }
        Properties existing = new Properties();
        Properties configured = XmlConfigHelper.readPropertiesContents(element, "properties");
        existing.putAll((Map<?, ?>)configured);
        result.setBuddyLocatorClass(buddyLocatorClass);
        result.setBuddyLocatorProperties(existing);
        return result;
    }

    private BuddyReplicationConfig.BuddyLocatorConfig defaultBuddyLocatorConfig() {
        BuddyReplicationConfig.BuddyLocatorConfig result = new BuddyReplicationConfig.BuddyLocatorConfig();
        result.setBuddyLocatorClass(NextMemberBuddyLocator.class.getName());
        Properties props = new Properties();
        result.setBuddyLocatorProperties(props);
        return result;
    }

    private void parseDataGravitationElement(Element element, BuddyReplicationConfig brc) {
        String searchBackupTrees;
        String removeOnFind;
        if (element == null) {
            return;
        }
        String auto = this.getAttributeValue(element, "auto");
        if (this.existsAttribute(auto)) {
            brc.setAutoDataGravitation(this.getBoolean(auto));
        }
        if (this.existsAttribute(removeOnFind = this.getAttributeValue(element, "removeOnFind"))) {
            brc.setDataGravitationRemoveOnFind(this.getBoolean(removeOnFind));
        }
        if (this.existsAttribute(searchBackupTrees = this.getAttributeValue(element, "searchBackupTrees"))) {
            brc.setDataGravitationSearchBackupTrees(this.getBoolean(searchBackupTrees));
        }
    }
}

