/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoader;
import org.jboss.cache.util.Util;

public class AdjListJDBCCacheLoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = -8371846151643130281L;
    private static final boolean CREATE_TABLE_DEFAULT = true;
    private static final boolean DROP_TABLE_DEFAULT = false;
    private static final String PARENT_COLUMN_DEFAULT = "parent";
    private static final String NODE_TYPE_DEFAULT = "BLOB";
    private static final String NODE_COLUMN_DEFAULT = "node";
    private static final String FQN_TYPE_DEFAULT = "VARCHAR(255)";
    private static final String FQN_COLUMN_DEFAULT = "fqn";
    private static final String PRIMARY_KEY_DEFAULT = "jbosscache_pk";
    private static final String TABLE_DEFAULT = "jbosscache";
    protected boolean createTable = true;
    protected String createTableDDL;
    protected String datasourceName;
    protected String deleteAllSql;
    protected String deleteNodeSql;
    protected boolean dropTable = false;
    protected String dropTableDDL;
    protected String driverClass;
    protected String insertNodeSql;
    protected String jdbcURL;
    protected String jdbcUser;
    protected String jdbcPassword;
    protected String selectChildFqnsSql;
    protected String selectChildNamesSql;
    protected String selectNodeSql;
    protected String updateNodeSql;
    protected String updateTableSql;
    protected String existsSql;
    protected String connectionFactoryClass;
    protected String primaryKey = "jbosscache_pk";
    protected String fqnType = "VARCHAR(255)";
    protected String nodeType = "BLOB";
    protected String parentColumn = "parent";
    protected String table = "jbosscache";
    protected String nodeColumn = "node";
    protected String fqnColumn = "fqn";

    public AdjListJDBCCacheLoaderConfig() {
    }

    AdjListJDBCCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.populateFromBaseConfig(base);
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.testImmutability("createTable");
        this.createTable = createTable;
    }

    public String getCreateTableDDL() {
        if (this.createTableDDL == null) {
            this.setCreateTableDDL(this.constructCreateTableDDL());
        }
        return this.createTableDDL;
    }

    public void setCreateTableDDL(String createTableDDL) {
        this.testImmutability("createTableDDL");
        this.createTableDDL = createTableDDL;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.testImmutability("datasourceName");
        this.datasourceName = datasourceName;
    }

    public String getDeleteAllSql() {
        if (this.deleteAllSql == null) {
            this.setDeleteAllSql(this.constructDeleteAllSql());
        }
        return this.deleteAllSql;
    }

    public void setDeleteAllSql(String deleteAllSql) {
        this.testImmutability("deleteAllSql");
        this.deleteAllSql = deleteAllSql;
    }

    public String getDeleteNodeSql() {
        if (this.deleteNodeSql == null) {
            this.setDeleteNodeSql(this.constructDeleteNodeSql());
        }
        return this.deleteNodeSql;
    }

    public void setDeleteNodeSql(String deleteNodeSql) {
        this.testImmutability("deleteNodeSql");
        this.deleteNodeSql = deleteNodeSql;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.testImmutability("driverClass");
        this.driverClass = driverClass;
    }

    public boolean getDropTable() {
        return this.dropTable;
    }

    public void setDropTable(boolean dropTable) {
        this.testImmutability("dropTable");
        this.dropTable = dropTable;
    }

    public String getInsertNodeSql() {
        if (this.insertNodeSql == null) {
            this.setInsertNodeSql(this.constructInsertNodeSql());
        }
        return this.insertNodeSql;
    }

    public String getExistsSql() {
        if (this.existsSql == null) {
            this.setExistsSql(this.constructExistsSql());
        }
        return this.existsSql;
    }

    public void setExistsSql(String existsSql) {
        this.testImmutability("existsSql");
        this.existsSql = existsSql;
    }

    public void setInsertNodeSql(String insertNodeSql) {
        this.testImmutability("insertNodeSql");
        this.insertNodeSql = insertNodeSql;
    }

    public String getSelectChildFqnsSql() {
        if (this.selectChildFqnsSql == null) {
            this.setSelectChildFqnsSql(this.constructSelectChildNamesSql());
        }
        return this.selectChildFqnsSql;
    }

    public void setSelectChildFqnsSql(String selectChildFqnsSql) {
        this.testImmutability("selectChildFqnsSql");
        this.selectChildFqnsSql = selectChildFqnsSql;
    }

    public String getSelectNodeSql() {
        if (this.selectNodeSql == null) {
            this.setSelectNodeSql(this.constructSelectNodeSql());
        }
        return this.selectNodeSql;
    }

    public void setSelectNodeSql(String selectNodeSql) {
        this.testImmutability("selectNodeSql");
        this.selectNodeSql = selectNodeSql;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.testImmutability("table");
        this.table = table;
    }

    public String getUpdateTableSql() {
        return this.updateTableSql;
    }

    public void setUpdateTableSql(String updateTableSql) {
        this.testImmutability("updateTableSql");
        this.updateTableSql = updateTableSql;
    }

    public String getDropTableDDL() {
        if (this.dropTableDDL == null) {
            this.setDropTableDDL(this.constructDropTableDDL());
        }
        return this.dropTableDDL;
    }

    public void setDropTableDDL(String dropTableDDL) {
        this.testImmutability("dropTableDDL");
        this.dropTableDDL = dropTableDDL;
    }

    public String getSelectChildNamesSql() {
        if (this.selectChildNamesSql == null) {
            this.setSelectChildNamesSql(this.constructSelectChildNamesSql());
        }
        return this.selectChildNamesSql;
    }

    public void setSelectChildNamesSql(String selectChildNamesSql) {
        this.testImmutability("selectChildNamesSql");
        this.selectChildNamesSql = selectChildNamesSql;
    }

    public String getUpdateNodeSql() {
        if (this.updateNodeSql == null) {
            this.setUpdateNodeSql(this.constructUpdateNodeSql());
        }
        return this.updateNodeSql;
    }

    public void setUpdateNodeSql(String updateNodeSql) {
        this.testImmutability("updateNodeSql");
        this.updateNodeSql = updateNodeSql;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.testImmutability("jdbcPassword");
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.testImmutability("jdbcURL");
        this.jdbcURL = jdbcURL;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.testImmutability("jdbcUser");
        this.jdbcUser = jdbcUser;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryClass");
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.testImmutability("primaryKey");
        this.primaryKey = primaryKey;
    }

    public String getFqnType() {
        return this.fqnType;
    }

    public void setFqnType(String fqnType) {
        this.testImmutability("fqnType");
        this.fqnType = fqnType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.testImmutability("nodeType");
        this.nodeType = nodeType;
    }

    public String getParentColumn() {
        return this.parentColumn;
    }

    public void setParentColumn(String parentColumn) {
        this.testImmutability("parentColumn");
        this.parentColumn = parentColumn;
    }

    public String getNodeColumn() {
        return this.nodeColumn;
    }

    public void setNodeColumn(String nodeColumn) {
        this.testImmutability("nodeColumn");
        this.nodeColumn = nodeColumn;
    }

    public String getFqnColumn() {
        return this.fqnColumn;
    }

    public void setFqnColumn(String fqnColumn) {
        this.testImmutability("fqnColumn");
        this.fqnColumn = fqnColumn;
    }

    public void setProperties(Properties props) {
        String prop;
        super.setProperties(props);
        this.datasourceName = props.getProperty("cache.jdbc.datasource");
        if (this.datasourceName == null) {
            this.driverClass = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.driver");
            this.jdbcURL = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.url");
            this.jdbcUser = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.user");
            this.jdbcPassword = AdjListJDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.password");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Properties: cache.jdbc.url=" + this.jdbcURL + ", cache.jdbc.driver=" + this.driverClass + ", cache.jdbc.user=" + this.jdbcUser + ", cache.jdbc.password=" + this.jdbcPassword + ", cache.jdbc.table=" + this.table));
            }
        }
        this.createTable = (prop = props.getProperty("cache.jdbc.table.create")) == null ? true : Boolean.valueOf(prop);
        prop = props.getProperty("cache.jdbc.table.drop");
        this.dropTable = prop == null ? false : Boolean.valueOf(prop);
        this.table = props.getProperty("cache.jdbc.table.name", TABLE_DEFAULT);
        this.primaryKey = props.getProperty("cache.jdbc.table.primarykey", PRIMARY_KEY_DEFAULT);
        this.fqnColumn = props.getProperty("cache.jdbc.fqn.column", FQN_COLUMN_DEFAULT);
        this.fqnType = props.getProperty("cache.jdbc.fqn.type", FQN_TYPE_DEFAULT);
        this.nodeColumn = props.getProperty("cache.jdbc.node.column", NODE_COLUMN_DEFAULT);
        this.nodeType = props.getProperty("cache.jdbc.node.type", NODE_TYPE_DEFAULT);
        this.parentColumn = props.getProperty("cache.jdbc.parent.column", PARENT_COLUMN_DEFAULT);
        this.selectChildNamesSql = this.constructSelectChildNamesSql();
        this.deleteNodeSql = this.constructDeleteNodeSql();
        this.deleteAllSql = this.constructDeleteAllSql();
        this.selectChildFqnsSql = this.constructSelectChildNamesSql();
        this.insertNodeSql = this.constructInsertNodeSql();
        this.updateNodeSql = this.constructUpdateNodeSql();
        this.selectNodeSql = this.constructSelectNodeSql();
        this.createTableDDL = this.constructCreateTableDDL();
        this.dropTableDDL = this.constructDropTableDDL();
        this.connectionFactoryClass = props.getProperty("cache.jdbc.connection.factory", "org.jboss.cache.loader.NonManagedConnectionFactory");
    }

    private String constructDropTableDDL() {
        return "DROP TABLE " + this.table;
    }

    private String constructCreateTableDDL() {
        return "CREATE TABLE " + this.table + "(" + this.fqnColumn + " " + this.fqnType + " NOT NULL, " + this.nodeColumn + " " + this.nodeType + ", " + this.parentColumn + " " + this.fqnType + ", PRIMARY KEY (" + this.fqnColumn + "))";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdjListJDBCCacheLoaderConfig && this.equalsExcludingProperties(obj)) {
            AdjListJDBCCacheLoaderConfig other = (AdjListJDBCCacheLoaderConfig)obj;
            return this.createTable == other.createTable && Util.safeEquals(this.createTableDDL, other.createTableDDL) && Util.safeEquals(this.datasourceName, other.datasourceName) && Util.safeEquals(this.deleteAllSql, other.deleteAllSql) && Util.safeEquals(this.deleteNodeSql, other.deleteNodeSql) && Util.safeEquals(this.driverClass, other.driverClass) && this.dropTable == other.dropTable && Util.safeEquals(this.dropTableDDL, other.dropTableDDL) && Util.safeEquals(this.insertNodeSql, other.insertNodeSql) && Util.safeEquals(this.jdbcPassword, other.jdbcPassword) && Util.safeEquals(this.jdbcURL, other.jdbcURL) && Util.safeEquals(this.jdbcUser, other.jdbcUser) && Util.safeEquals(this.selectChildFqnsSql, other.selectChildFqnsSql) && Util.safeEquals(this.selectChildNamesSql, other.selectChildNamesSql) && Util.safeEquals(this.selectNodeSql, other.selectNodeSql) && Util.safeEquals(this.table, other.table) && Util.safeEquals(this.updateNodeSql, other.updateNodeSql) && Util.safeEquals(this.updateTableSql, other.updateTableSql) && Util.safeEquals(this.connectionFactoryClass, other.connectionFactoryClass) && Util.safeEquals(this.primaryKey, other.primaryKey) && Util.safeEquals(this.nodeType, other.nodeType) && Util.safeEquals(this.fqnType, other.fqnType) && Util.safeEquals(this.parentColumn, other.parentColumn);
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingProperties();
        result = 31 * result + (this.createTable ? 0 : 1);
        result = 31 * result + (this.createTableDDL == null ? 0 : this.createTableDDL.hashCode());
        result = 31 * result + (this.datasourceName == null ? 0 : this.datasourceName.hashCode());
        result = 31 * result + (this.deleteAllSql == null ? 0 : this.deleteAllSql.hashCode());
        result = 31 * result + (this.deleteNodeSql == null ? 0 : this.deleteNodeSql.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.dropTable ? 0 : 1);
        result = 31 * result + (this.dropTableDDL == null ? 0 : this.dropTableDDL.hashCode());
        result = 31 * result + (this.insertNodeSql == null ? 0 : this.insertNodeSql.hashCode());
        result = 31 * result + (this.jdbcPassword == null ? 0 : this.jdbcPassword.hashCode());
        result = 31 * result + (this.jdbcUser == null ? 0 : this.jdbcUser.hashCode());
        result = 31 * result + (this.jdbcURL == null ? 0 : this.jdbcURL.hashCode());
        result = 31 * result + (this.selectChildFqnsSql == null ? 0 : this.selectChildFqnsSql.hashCode());
        result = 31 * result + (this.selectChildNamesSql == null ? 0 : this.selectChildNamesSql.hashCode());
        result = 31 * result + (this.selectNodeSql == null ? 0 : this.selectNodeSql.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.updateNodeSql == null ? 0 : this.updateNodeSql.hashCode());
        result = 31 * result + (this.updateTableSql == null ? 0 : this.updateTableSql.hashCode());
        result = 31 * result + (this.connectionFactoryClass == null ? 0 : this.connectionFactoryClass.hashCode());
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (this.fqnType == null ? 0 : this.fqnType.hashCode());
        result = 31 * result + (this.parentColumn == null ? 0 : this.parentColumn.hashCode());
        return result;
    }

    public AdjListJDBCCacheLoaderConfig clone() throws CloneNotSupportedException {
        return (AdjListJDBCCacheLoaderConfig)super.clone();
    }

    private String constructSelectNodeSql() {
        return "SELECT " + this.nodeColumn + " FROM " + this.table + " WHERE " + this.fqnColumn + " = ?";
    }

    private String constructUpdateNodeSql() {
        return "UPDATE " + this.table + " SET " + this.nodeColumn + " = ? WHERE " + this.fqnColumn + " = ?";
    }

    private String constructDeleteAllSql() {
        return "DELETE FROM " + this.table;
    }

    private String constructDeleteNodeSql() {
        return "DELETE FROM " + this.table + " WHERE " + this.fqnColumn + " = ?";
    }

    private String constructSelectChildNamesSql() {
        return "SELECT " + this.fqnColumn + " FROM " + this.table + " WHERE " + this.parentColumn + " = ?";
    }

    private String constructExistsSql() {
        return "SELECT '1' FROM " + this.table + " WHERE " + this.fqnColumn + " = ?";
    }

    private String constructInsertNodeSql() {
        return "INSERT INTO " + this.table + " (" + this.fqnColumn + ", " + this.nodeColumn + ", " + this.parentColumn + ") SELECT ?, ?, ? FROM " + this.table + "_D WHERE NOT EXISTS (SELECT " + this.fqnColumn + " FROM " + this.table + " WHERE " + this.fqnColumn + " = ?)";
    }

    public String getDummyTableCreationDDL() {
        return "CREATE TABLE " + this.table + "_D (i CHAR)";
    }

    public String getDummyTableRemovalDDL() {
        return "DROP TABLE " + this.table + "_D";
    }

    public String getDummyTablePopulationSql() {
        return "INSERT INTO " + this.table + "_D VALUES ('x')";
    }
}

