/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeData<K, V>
implements Externalizable {
    private Fqn fqn = null;
    private Map<K, V> attrs = null;
    static final long serialVersionUID = -7571995794010294485L;

    public NodeData() {
    }

    public NodeData(Fqn fqn) {
        this.fqn = fqn;
    }

    public NodeData(Fqn fqn, Map<K, V> attrs, boolean mapSafe) {
        this.fqn = fqn;
        this.attrs = mapSafe || attrs == null ? attrs : new HashMap<K, V>(attrs);
    }

    public NodeData(String fqn, Map<K, V> attrs, boolean mapSafe) {
        this(Fqn.fromString(fqn), attrs, mapSafe);
    }

    public Map<K, V> getAttributes() {
        return this.attrs;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public boolean isMarker() {
        return false;
    }

    public boolean isExceptionMarker() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fqn);
        if (this.attrs != null) {
            out.writeBoolean(true);
            out.writeObject(this.attrs);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fqn = (Fqn)in.readObject();
        if (in.readBoolean()) {
            this.attrs = (Map)in.readObject();
        }
    }

    public String toString() {
        return "NodeData {fqn: " + this.fqn + ", attrs=" + this.attrs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeData nodeData = (NodeData)o;
        if (this.attrs != null ? !((Object)this.attrs).equals(nodeData.attrs) : nodeData.attrs != null) {
            return false;
        }
        return !(this.fqn != null ? !this.fqn.equals(nodeData.fqn) : nodeData.fqn != null);
    }

    public int hashCode() {
        int result = this.fqn != null ? this.fqn.hashCode() : 0;
        result = 31 * result + (this.attrs != null ? ((Object)this.attrs).hashCode() : 0);
        return result;
    }
}

