/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.interception.RedirectPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@ServerInterceptor
@RedirectPrecedence
public class ServerCacheHitInterceptor
implements PreProcessInterceptor {
    protected ServerCache cache;
    public static final String DO_NOT_CACHE_RESPONSE = "DO NOT CACHE RESPONSE";
    @Context
    protected Request validation;

    public ServerCacheHitInterceptor(ServerCache cache) {
        this.cache = cache;
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        MediaType chosenType;
        if (!request.getHttpMethod().equalsIgnoreCase("GET")) {
            return null;
        }
        String key = request.getUri().getRequestUri().toString();
        ServerCache.Entry entry = this.cache.get(key, chosenType = method.matchByType(request.getHttpHeaders().getAcceptableMediaTypes()));
        if (entry != null) {
            if (entry.isExpired()) {
                this.cache.remove(key);
                return null;
            }
            Response.ResponseBuilder builder = this.validation.evaluatePreconditions(new EntityTag(entry.getEtag()));
            CacheControl cc = new CacheControl();
            cc.setMaxAge(entry.getExpirationInSeconds());
            if (builder != null) {
                return (ServerResponse)builder.cacheControl(cc).build();
            }
            ServerResponse serverResponse = new ServerResponse();
            serverResponse.setEntity((Object)entry.getCached());
            MultivaluedMapImpl headers = new MultivaluedMapImpl();
            headers.putAll(entry.getHeaders());
            headers.putSingle((Object)"Cache-Control", (Object)cc);
            serverResponse.setMetadata((MultivaluedMap)headers);
            request.setAttribute(DO_NOT_CACHE_RESPONSE, (Object)true);
            return serverResponse;
        }
        return null;
    }
}

