/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@ServerInterceptor
public class ServerCacheInterceptor
implements MessageBodyWriterInterceptor {
    protected ServerCache cache;
    @Context
    protected HttpRequest request;
    @Context
    protected Request validation;
    private static final String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public ServerCacheInterceptor(ServerCache cache) {
        this.cache = cache;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        byte ch = 0;
        StringBuffer out = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            ch = (byte)(b & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(b & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    protected String createHash(byte[] entity) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            byte[] abyte0 = messagedigest.digest(entity);
            return ServerCacheInterceptor.byteArrayToHexString(abyte0);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        if (!this.request.getHttpMethod().equalsIgnoreCase("GET") || this.request.getAttribute("DO NOT CACHE RESPONSE") != null) {
            context.proceed();
            return;
        }
        Object occ = context.getHeaders().getFirst((Object)"Cache-Control");
        if (occ == null) {
            context.proceed();
            return;
        }
        CacheControl cc = null;
        cc = occ instanceof CacheControl ? (CacheControl)occ : CacheControl.valueOf((String)occ.toString());
        if (cc.isNoCache()) {
            context.proceed();
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        OutputStream old = context.getOutputStream();
        try {
            context.setOutputStream((OutputStream)buffer);
            context.proceed();
            byte[] entity = buffer.toByteArray();
            Object etagObject = context.getHeaders().getFirst((Object)"ETag");
            String etag = null;
            if (etagObject == null) {
                etag = this.createHash(entity);
                context.getHeaders().putSingle((Object)"ETag", (Object)etag);
            } else {
                etag = etagObject.toString();
            }
            this.cache.add(this.request.getUri().getRequestUri().toString(), context.getMediaType(), cc, (MultivaluedMap<String, Object>)context.getHeaders(), entity, etag);
            Response.ResponseBuilder validatedResponse = this.validation.evaluatePreconditions(new EntityTag(etag));
            if (validatedResponse != null) {
                throw new NoLogWebApplicationException(validatedResponse.status(Response.Status.NOT_MODIFIED).cacheControl(cc).header("ETag", (Object)etag).build());
            }
            old.write(entity);
        }
        finally {
            context.setOutputStream(old);
        }
    }
}

