/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.api.crd;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class QueryInformation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20056394248095452L;
    public static final int QUERY_TYPE_QUEYR = 1;
    public static final int QUERY_TYPE_PARAMETER = 2;
    private CatalogKey catalogKey;
    private String dataSource;
    private String queryName;
    private String bvName;
    private int queryType;
    private boolean isBV;
    private boolean isCube;
    private Locale locale;
    private Map paramValues;
    private Map paramLocales;
    private Hashtable jndiNames;
    private Hashtable jdbcUrls;
    private Hashtable userNames;
    private Hashtable passwords;
    private Hashtable databaseMetadataInfoMap;
    private Hashtable connectionInfoMap;
    private Integer id;

    public QueryInformation(CatalogKey catalogKey, String string, int n, String string2, Map map, Locale locale) {
        this.catalogKey = catalogKey;
        this.queryName = string;
        this.queryType = n;
        this.isBV = false;
        this.dataSource = string2;
        this.paramValues = map;
        this.locale = locale;
    }

    public QueryInformation(CatalogKey catalogKey, String string, int n, boolean bl, String string2, Map map, Locale locale) {
        this.catalogKey = catalogKey;
        this.queryName = string;
        this.queryType = n;
        this.isBV = bl;
        this.dataSource = string2;
        this.paramValues = map;
        this.locale = locale;
    }

    public QueryInformation(QueryInformation queryInformation) {
        this.SEDU(queryInformation);
    }

    private void SEDU(QueryInformation queryInformation) {
        this.catalogKey = queryInformation.catalogKey;
        this.dataSource = queryInformation.dataSource;
        this.queryName = queryInformation.queryName;
        this.queryType = queryInformation.queryType;
        this.isBV = queryInformation.isBV;
        this.isCube = queryInformation.isCube;
        this.locale = queryInformation.locale;
        this.paramValues = queryInformation.paramValues;
        this.jndiNames = queryInformation.jndiNames;
        this.jdbcUrls = queryInformation.jdbcUrls;
        this.userNames = queryInformation.userNames;
        this.passwords = queryInformation.passwords;
        this.databaseMetadataInfoMap = queryInformation.databaseMetadataInfoMap;
        this.connectionInfoMap = queryInformation.connectionInfoMap;
        this.paramLocales = queryInformation.paramLocales;
    }

    public CatalogKey getCatalogKey() {
        return this.catalogKey;
    }

    public String getName() {
        return this.queryName;
    }

    public String getBVName() {
        return this.bvName;
    }

    public void setBVName(String string) {
        this.bvName = string;
    }

    public int getType() {
        return this.queryType;
    }

    public boolean isBV() {
        return this.isBV;
    }

    public void setBV(boolean bl) {
        this.isBV = bl;
    }

    public boolean isCube() {
        return this.isCube;
    }

    public void setCube(boolean bl) {
        this.isCube = bl;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public long getCatalogLastModified() {
        return this.catalogKey.getLastModified();
    }

    public String getCatalogPath() {
        return this.catalogKey.getPath();
    }

    public int getCatalogVersionNumber() {
        return this.catalogKey.getVersionNumber();
    }

    public Map getParamValues() {
        return this.paramValues;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Hashtable getDatabaseMetadataInfos() {
        return this.databaseMetadataInfoMap;
    }

    public void setDatabaseMetadataInfoMap(Hashtable hashtable) {
        this.databaseMetadataInfoMap = hashtable;
    }

    public Hashtable getConnectionInfos() {
        return this.connectionInfoMap;
    }

    public void setConnectionInfoMap(Hashtable hashtable) {
        this.connectionInfoMap = hashtable;
    }

    public Hashtable getJndiNames() {
        return this.jndiNames;
    }

    public Map getRuntimeJndiNames() {
        return this.add(this.jndiNames, true, "jndi", "jrs.jndi_datasource");
    }

    private Map add(Map hashMap, boolean bl, String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (hashMap != null) {
            arrayList.addAll(hashMap.keySet());
        } else {
            hashMap = new HashMap();
        }
        if (this.connectionInfoMap != null) {
            for (Object object : this.connectionInfoMap.keySet()) {
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (String string3 : arrayList) {
            Properties properties;
            String string4 = (String)hashMap.get(string3);
            String string5 = string4 = string4 == null ? "" : string4;
            if (string4.equals("") && (properties = (Properties)this.connectionInfoMap.get(string3)) != null) {
                String string6 = properties.getProperty("jrs.catalog_connection_type");
                if (!bl || string6.equalsIgnoreCase(string)) {
                    string4 = (String)properties.get(string2);
                }
            }
            if (string != null && !string.equals("jdbc")) continue;
            hashMap2.put(string3, string4);
        }
        return hashMap2;
    }

    public void setJndiNames(Hashtable hashtable) {
        this.jndiNames = hashtable;
    }

    public Hashtable getJdbcUrls() {
        return this.jdbcUrls;
    }

    public Map getRuntimeJdbcUrls() {
        return this.add(this.jdbcUrls, true, "jdbc", "jrs.jdbc_url");
    }

    public void setJdbcUrls(Hashtable hashtable) {
        this.jdbcUrls = hashtable;
    }

    public Hashtable getUsers() {
        return this.userNames;
    }

    public Map getRuntimeUsers() {
        return this.add(this.userNames, false, null, "jrs.ds_user");
    }

    public void setUsers(Hashtable hashtable) {
        this.userNames = hashtable;
    }

    public Hashtable getPwds() {
        return this.passwords;
    }

    public Map getRuntimePwds() {
        return this.add(this.passwords, false, null, "jrs.ds_pswd");
    }

    public void setPwds(Hashtable hashtable) {
        this.passwords = hashtable;
    }

    public void setParameterLocales(Map map) {
        this.paramLocales = map;
    }

    public Map getParameterLocales() {
        if (this.paramLocales == null && this.paramValues != null) {
            this.paramLocales = new HashMap(this.paramValues.size());
            for (String string : this.paramValues.keySet()) {
                this.paramLocales.put(string, this.locale);
            }
        }
        return this.paramLocales;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public final QueryInformation clone() {
        QueryInformation queryInformation = null;
        try {
            queryInformation = (QueryInformation)super.clone();
            queryInformation.SEDU(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return queryInformation;
    }

    public int getId() {
        if (this.id == null) {
            int n = 17;
            if (!this.isEmpty(this.dataSource)) {
                n = 37 * n + this.dataSource.hashCode();
            }
            if (!this.isEmpty(this.catalogKey.getPath())) {
                n = 37 * n + this.catalogKey.getPath().hashCode();
            }
            if (!this.isEmpty(this.queryName)) {
                n = 37 * n + this.queryName.hashCode();
            }
            if (!this.isEmpty(this.bvName)) {
                n = 37 * n + this.bvName.hashCode();
            }
            n = 37 * n + new Integer(this.queryType).hashCode();
            n = 37 * n + new Boolean(this.isBV).hashCode();
            n = 37 * n + new Boolean(this.isCube).hashCode();
            this.id = n;
        }
        return this.id;
    }

    public String toString() {
        int n;
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append("queryName=" + this.queryName);
        stringBuffer.append(", queryType=" + this.queryType);
        stringBuffer.append(", catalogPath:").append(this.catalogKey.getPath());
        stringBuffer.append(", catalogVersion:").append(this.catalogKey.getVersionNumber());
        stringBuffer.append(", catalogModified:").append(this.catalogKey.getLastModified());
        stringBuffer.append(", bvName=" + this.bvName);
        stringBuffer.append(", isCube=").append(this.isCube);
        stringBuffer.append(", isBV=").append(this.isBV);
        if (this.userNames != null && !this.userNames.isEmpty()) {
            stringBuffer.append(", userNames=" + this.userNames);
        }
        if (this.passwords != null && !this.passwords.isEmpty()) {
            stringBuffer.append(", passwords=******");
        }
        if (!this.isEmpty(this.dataSource)) {
            stringBuffer.append(", dataSource=" + this.dataSource);
        }
        if (this.jdbcUrls != null && !this.jdbcUrls.isEmpty()) {
            stringBuffer.append(", jdbcUrls=" + this.jdbcUrls);
        }
        if (this.jndiNames != null && !this.jndiNames.isEmpty()) {
            stringBuffer.append(", jndiNames=" + this.jndiNames);
        }
        if (this.locale != null) {
            stringBuffer.append(", locale=" + this.locale);
        }
        if (this.paramValues != null && this.paramValues.size() > 0) {
            stringBuffer.append(", paramValues:{");
            Iterator iterator = this.paramValues.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (String[])this.paramValues.get(object2);
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object2).append(":[");
                n = 0;
                for (String string : object) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    ++n;
                }
                stringBuffer.append("]");
                ++n2;
            }
            stringBuffer.append("}");
        }
        if (this.connectionInfoMap != null && this.connectionInfoMap.size() > 0) {
            stringBuffer.append(", connectionInfos:{");
            for (String string : this.connectionInfoMap.keySet()) {
                stringBuffer.append("connName=").append(string).append(", ");
                object2 = (Properties)this.connectionInfoMap.get(string);
                stringBuffer.append("{");
                if (object2 != null && ((Properties)object2).size() > 0) {
                    object = ((Properties)object2).keySet().iterator();
                    n = 0;
                    while (object.hasNext()) {
                        Object e = object.next();
                        Object object3 = ((Properties)object2).get(e);
                        if (n > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(e).append(":").append(object3);
                        ++n;
                    }
                }
                stringBuffer.append("}");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("}");
        stringBuffer.append(", databaseMetadataInfo = " + this.databaseMetadataInfoMap);
        return stringBuffer.toString();
    }
}

