/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.component.service.util;

import chart.ChartDefinition;
import chart.ChartShowValueInfo;
import chart.properties.ChartMessageProperties;
import com.jinfonet.web.Context;
import com.jinfonet.web.UserInfo;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.ResourceTypes;
import com.jinfonet.web.beans.WebRptObject;
import com.jinfonet.web.beans.report.ReportClass;
import com.jinfonet.web.beans.report.TemplatePoolHolder;
import com.jinfonet.web.beans.report.WebTemplate;
import com.jinfonet.web.modules.component.client.layout.chart.ChartDefObject;
import com.jinfonet.web.modules.component.service.WebReport;
import com.jinfonet.web.modules.component.service.util.DataKit;
import com.jinfonet.web.modules.component.service.util.LinkKit;
import com.jinfonet.web.modules.component.service.util.NLSKit;
import com.jinfonet.web.modules.component.service.util.TemplateKit;
import com.jinfonet.web.modules.resource.service.util.CatalogKeyImpl;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetFont;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.ireport.IDataContainer;
import jet.naming.PropertyNames;
import jet.report.JetLink;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptDBField;
import jet.report.JetRptDataContainer;
import jet.report.JetRptField;
import jet.report.JetRptFilterControl;
import jet.report.JetRptMsgToActionItem;
import jet.report.JetRptMultiValueContainer;
import jet.report.JetRptObject;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPageStart;
import jet.report.JetRptSortContainer;
import jet.report.JetRptTOC;
import jet.report.JetRptView;
import jet.report.JetRptViewComponent;
import jet.report.JetRptViews;
import jet.report.Renderable;
import jet.report.chart.JetRptChartComponent;
import jet.report.chart.JetRptChartGroupRectTitle;
import jet.report.chart.JetRptChartLabel;
import jet.report.chart.JetRptChartLegend;
import jet.report.chart.JetRptChartPaper;
import jet.report.chart.JetRptChartPlatform;
import jet.report.chart.JetRptChartShValBehaviourFunction;
import jet.report.chart.JetRptChartShowValueFunc;
import jet.report.conditionalFormatting.JetRptConditionalFormatSet;
import jet.report.conditionalFormatting.JetRptReportFormulaClassSet;
import jet.report.filter.JetRptTypedFilterExpression;
import jet.report.geomap.JetRptGeoArea;
import jet.report.geomap.JetRptGeoMarker;
import jet.report.gmap.JetRptGMap;
import jet.report.gmap.JetRptGMarker;
import jet.report.link.Linkable;
import jet.report.mode.JetRptMode;
import jet.report.mode.actions.JetRptAction;
import jet.report.mode.common.RptAtomicAction;
import jet.report.mode.common.RptEventToActionItem;
import jet.report.mode.common.argExpression.AtomicParamArgExp;
import jet.report.mode.common.cusAction.CustomAtomicAction;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.JetRptQueryFlyFormula;
import jet.report.onTheFlyFormula.Scope;
import jet.report.paragraph.build.JetRptParaTextSegment;
import jet.report.specialFunc.SpecialFunction;
import jet.report.specialFunc.grpByRange.DateTimeIntervalGrpBy;
import jet.report.table.JetRptNewTable;
import jet.report.vct.JetRptVCTDisplayType;
import jet.report.vct.JetRptVCTLegend;
import jet.report.vct.JetRptVCTObject;
import jet.report.vct.disp.JetRptVCTDispTypeAuto;
import jet.reportLogic.objectLogic.ComponentFormulaTool;
import jet.reportset.JetRptDataSets;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.util.FontSets;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSApplyParam;
import jet.util.nls.meta.MetaNLSKit;
import toolkit.db.gui.MappingSQLType;

public class ReportConverterTool {
    public static final Set ignoreTemplate;
    static final String[] CHART_PAPER_FONTNAMES;
    static final String[] CHART_PAPER_FONTSTYLES;
    static final String[] CHART_LABEL_FONTNAMES;
    static final String[] CHART_LABEL_FONTSTYLES;
    private static final HashSet AGGREGATION;

    public static void init() {
    }

    public static WebTemplate convertJetRpt2WebRptV2(JetObject jetObject, TemplatePoolHolder templatePoolHolder, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, WebReport webReport) {
        if (ignoreTemplate.contains(jetObject.getClass())) {
            return null;
        }
        String string = ReportConverterTool.Background(jetObject);
        WebTemplate webTemplate = null;
        if (string != null) {
            try {
                webTemplate = (WebTemplate)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webTemplate == null) {
            webTemplate = new WebTemplate();
        }
        ReportConverterTool.BorderColor(jetObject, webTemplate, jetRptReport, jetUUniverse, webReport, nLSApplyParam);
        NLSKit.applyWebRptNLS(jetObject, webTemplate, nLSApplyParam);
        ReportConverterTool.AnchorDispValue(jetObject, webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        webTemplate.initProperties();
        if (templatePoolHolder != null) {
            templatePoolHolder.putTemplate(webTemplate.getInstanceName(), webTemplate);
        }
        if (jetObject instanceof JetRptVCTObject) {
            ReportConverterTool.AGGREGATION(jetObject, webTemplate, templatePoolHolder, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        } else if (jetObject instanceof JetContainable) {
            WebTemplate webTemplate2 = null;
            ArrayList<WebTemplate> arrayList = new ArrayList<WebTemplate>();
            webTemplate.setChildren(arrayList);
            Vector vector = ((JetContainable)jetObject).getChildren();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                JetObject jetObject2 = (JetObject)vector.get(i);
                webTemplate2 = webTemplate instanceof TemplatePoolHolder ? ReportConverterTool.convertJetRpt2WebRptV2(jetObject2, (TemplatePoolHolder)((Object)webTemplate), jetRptReport, jetUUniverse, nLSApplyParam, webReport) : ReportConverterTool.convertJetRpt2WebRptV2(jetObject2, templatePoolHolder, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
                if (webTemplate2 == null) continue;
                arrayList.add(webTemplate2);
            }
            webTemplate.customChildren();
        }
        return webTemplate;
    }

    private static void AGGREGATION(JetObject jetObject, WebTemplate webTemplate, TemplatePoolHolder templatePoolHolder, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, WebReport webReport) {
        WebTemplate webTemplate2 = null;
        WebTemplate webTemplate3 = null;
        ArrayList<WebTemplate> arrayList = new ArrayList<WebTemplate>();
        ArrayList<WebTemplate> arrayList2 = new ArrayList<WebTemplate>();
        webTemplate.setChildren(arrayList2);
        JetRptVCTObject jetRptVCTObject = (JetRptVCTObject)jetObject;
        Vector vector = jetRptVCTObject.getChildren();
        for (JetObject jetObject2 : vector) {
            webTemplate2 = ReportConverterTool.convertJetRpt2WebRptV2(jetObject2, templatePoolHolder, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
            if (jetObject2 instanceof JetRptVCTDisplayType) {
                if (jetObject2 instanceof JetRptVCTDispTypeAuto) {
                    JetRptVCTDisplayType jetRptVCTDisplayType = jetRptVCTObject.getCalculatedAutoDispType((JetRptVCTDispTypeAuto)jetObject2);
                    if (jetRptVCTDisplayType != null) {
                        int n;
                        List list = jetRptVCTDisplayType.getSortedLegends();
                        if (list != null && (n = list.size()) > 0) {
                            String[] stringArray = new String[n];
                            for (int i = 0; i < n; ++i) {
                                stringArray[i] = Integer.toString(((JetRptVCTLegend)list.get(i)).getLegendType());
                            }
                            JSONObject jSONObject = (JSONObject)webTemplate2.getPropertyByName("SortedLegends");
                            jSONObject.put("vector", (Object)stringArray);
                        }
                        webTemplate2.setObjectType(jetRptVCTDisplayType.getClass().getName());
                        webTemplate2.put("isAuto", "1");
                        Vector vector2 = jetRptVCTDisplayType.getChildren();
                        webTemplate2.setChildren(arrayList);
                        for (JSONObject jSONObject : vector2) {
                            webTemplate3 = ReportConverterTool.convertJetRpt2WebRptV2((JetObject)jSONObject, templatePoolHolder, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
                            arrayList.add(webTemplate3);
                        }
                    }
                } else {
                    webTemplate2.put("isAuto", "0");
                }
            }
            arrayList2.add(webTemplate2);
        }
    }

    private static void AnchorDispValue(JetObject jetObject, WebTemplate webTemplate, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, WebReport webReport) {
        List list;
        ChartMessageProperties chartMessageProperties;
        ChartMessageProperties chartMessageProperties2;
        Object object;
        JetRptAction jetRptAction;
        if (jetObject instanceof Renderable && !(jetObject instanceof JetRptChartGroupRectTitle) && !(jetObject.getParent() instanceof JetRptMultiValueContainer)) {
            jetRptAction = ((Renderable)jetObject).getCurrentUsedRenderer();
            object = new WebRptObject();
            ReportConverterTool.BorderColor((JetObject)jetRptAction, (WebRptObject)object, jetRptReport, jetUUniverse, webReport, nLSApplyParam);
            ReportConverterTool.getSupportEvents(jetRptAction.getSupportEvents(), (WebRptObject)object, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
            webTemplate.put("render", object);
        }
        if (jetObject instanceof JetRptMsgToActionItem) {
            jetRptAction = (JetRptAction)((JetRptMsgToActionItem)jetObject).getRefAction();
            ReportConverterTool.expandAndGetAllAtomicAction(jetRptAction, webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
        if (jetObject instanceof JetRptChartLegend && (object = (jetRptAction = (JetRptChartLegend)jetObject).getLegendEventToAction()) != null) {
            ReportConverterTool.getSupportEvents(object.getMessage(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
        if (jetObject instanceof JetRptChartPlatform && (jetRptAction = (JetRptChartPlatform)jetObject).getChartDefinition().isHeatMapChart() && (chartMessageProperties2 = jetRptAction.getShowValueFunction((ChartShowValueInfo)(object = new ChartShowValueInfo(0, 19, 0, "")))) != null && (chartMessageProperties = chartMessageProperties2.getRptShowValueBehaviourFunctionInst()) != null && (list = (JetRptMode)chartMessageProperties.getShowValueModeProperty().getObject()) != null) {
            ReportConverterTool.getSupportEvents(list.getCurrentRender().getSupportEvents(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
        if (jetObject instanceof JetRptChartPaper) {
            jetRptAction = (JetRptChartPaper)jetObject;
            object = (JetRptChartPlatform)jetRptAction.getParent();
            chartMessageProperties2 = jetRptAction.getAxisXEventToAction();
            if (chartMessageProperties2 != null) {
                ReportConverterTool.getSupportEvents(chartMessageProperties2.getMessage(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, "_AxisX", webReport);
            }
            if ((chartMessageProperties = jetRptAction.getAxisZEventToAction()) != null) {
                ReportConverterTool.getSupportEvents(chartMessageProperties.getMessage(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, "_AxisZ", webReport);
            }
            if ((list = object.getChartDefinition().getShowValueInfoList()).size() > 0) {
                JSONArray jSONArray = new JSONArray();
                webTemplate.put("getSupportEvents_Graphic", jSONArray);
                ChartShowValueInfo chartShowValueInfo = null;
                JetRptChartShowValueFunc jetRptChartShowValueFunc = null;
                JetRptChartShValBehaviourFunction jetRptChartShValBehaviourFunction = null;
                WebRptObject webRptObject = null;
                WebRptObject webRptObject2 = null;
                for (int i = 0; i < list.size(); ++i) {
                    chartShowValueInfo = (ChartShowValueInfo)list.get(i);
                    webRptObject2 = new WebRptObject();
                    webRptObject2.put("chartType", chartShowValueInfo.getChartType());
                    webRptObject2.put("aixsType", chartShowValueInfo.getAixsType());
                    webRptObject2.put("vdname", chartShowValueInfo.getValueDisplayName());
                    webRptObject2.put("voname", chartShowValueInfo.getValueOrignName());
                    webRptObject2.put("vt", chartShowValueInfo.getValueType());
                    webRptObject = new WebRptObject();
                    webRptObject.put("valueInfo", webRptObject2);
                    jetRptChartShowValueFunc = object.getShowValueFunction(chartShowValueInfo);
                    if (null == jetRptChartShowValueFunc || null == (jetRptChartShValBehaviourFunction = jetRptChartShowValueFunc.getRptShowValueBehaviourFunctionInst())) continue;
                    ReportConverterTool.getSupportEvents(jetRptChartShValBehaviourFunction.getEventToActionItemAsList(), webRptObject, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
                    jSONArray.add((Object)webRptObject);
                }
            }
        }
        if (jetObject instanceof JetRptGMarker) {
            jetRptAction = (JetRptGMarker)jetObject;
            ReportConverterTool.getSupportEvents(jetRptAction.getEventToActionItemList(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
        if (jetObject instanceof JetRptGeoArea) {
            jetRptAction = (JetRptGeoArea)jetObject;
            ReportConverterTool.getSupportEvents(jetRptAction.getEventToActionItemList(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
        if (jetObject instanceof JetRptGeoMarker) {
            jetRptAction = (JetRptGeoMarker)jetObject;
            ReportConverterTool.getSupportEvents(jetRptAction.getEventToActionItemList(), webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
        }
    }

    private static void getSupportEvents(List list, WebRptObject webRptObject, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, WebReport webReport) {
        ReportConverterTool.getSupportEvents(list, webRptObject, jetRptReport, jetUUniverse, nLSApplyParam, "", webReport);
    }

    private static void getSupportEvents(List list, WebRptObject webRptObject, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, String string, WebReport webReport) {
        JSONArray jSONArray = new JSONArray();
        for (RptEventToActionItem rptEventToActionItem : list) {
            WebTemplate webTemplate = ReportConverterTool.convertJetRpt2WebRptV2((JetObject)rptEventToActionItem, null, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
            JetRptAction jetRptAction = (JetRptAction)rptEventToActionItem.getRefAction();
            ReportConverterTool.expandAndGetAllAtomicAction(jetRptAction, webTemplate, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
            jSONArray.add((Object)webTemplate);
        }
        if (jSONArray.size() > 0) {
            webRptObject.put("getSupportEvents" + string, jSONArray);
        }
    }

    private static void expandAndGetAllAtomicAction(JetRptAction jetRptAction, WebRptObject webRptObject, JetRptReport jetRptReport, JetUUniverse jetUUniverse, NLSApplyParam nLSApplyParam, WebReport webReport) {
        JSONArray jSONArray = new JSONArray();
        if (null != jetRptAction) {
            RptAtomicAction[] rptAtomicActionArray;
            for (RptAtomicAction rptAtomicAction : rptAtomicActionArray = jetRptAction.expandAndGetAllAtomicAction()) {
                AtomicParamArgExp atomicParamArgExp;
                WebTemplate webTemplate = ReportConverterTool.convertJetRpt2WebRptV2((JetObject)rptAtomicAction, null, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
                if (rptAtomicAction instanceof CustomAtomicAction && null != (atomicParamArgExp = ((CustomAtomicAction)rptAtomicAction).getApplyTo())) {
                    WebTemplate webTemplate2 = ReportConverterTool.convertJetRpt2WebRptV2((JetObject)atomicParamArgExp, null, jetRptReport, jetUUniverse, nLSApplyParam, webReport);
                    webTemplate.put("getApplyTo", webTemplate2);
                }
                jSONArray.add((Object)webTemplate);
            }
        }
        if (jSONArray.size() > 0) {
            webRptObject.put("expandAndGetAllAtomicAction", jSONArray);
        }
    }

    private static String Background(JetObject jetObject) {
        String string = jetObject.getClass().getName();
        if (ReportClass.MAPPING.containsKey(string)) {
            return (String)ReportClass.MAPPING.get(string);
        }
        return null;
    }

    private static void BorderColor(JetObject jetObject, WebRptObject webRptObject, JetRptReport jetRptReport, JetUUniverse jetUUniverse, WebReport webReport, NLSApplyParam nLSApplyParam) {
        Object object;
        Object object2;
        Object object3;
        String string;
        CatalogKeyImpl catalogKeyImpl;
        Object object4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        webRptObject.setFormulaQueue(arrayList);
        boolean bl = false;
        if (jetObject instanceof Linkable) {
            bl = LinkKit.hasLink((Linkable)jetObject);
        }
        String string2 = jetObject.getInstName();
        webRptObject.setInstanceName(string2);
        webRptObject.setObjectType(jetObject.getClass().getName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        webRptObject.setProperties(hashMap);
        Iterator iterator = ReportConverterTool.CHART_LABEL_FONTNAMES(jetObject, webRptObject);
        String string3 = null;
        JetProperty jetProperty = null;
        JSONObject jSONObject = null;
        String string4 = null;
        String string5 = "t";
        String string6 = "v";
        String string7 = "a";
        ComponentFormulaTool componentFormulaTool = new ComponentFormulaTool(jetObject);
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            jetProperty = jetObject.nameToProperty(string3);
            if (jetProperty == null) continue;
            jSONObject = new JSONObject();
            jSONObject.put(string5, (Object)jetProperty.getPropType());
            if (jetProperty.isSetRuntimeChgBy()) {
                object4 = jetProperty.getRuntimeChangeBy().toString();
                jSONObject.put("r", object4);
                catalogKeyImpl = jetProperty.getCurrentValue();
                int n = catalogKeyImpl.getValueType();
                if (n == 0 || n == 2) {
                    string4 = (String)catalogKeyImpl.getValueObj();
                }
                if ((string = componentFormulaTool.getComponentFormular(string3, string4, n == 2)) != null && string.isAnonymousFormula()) {
                    jSONObject.put("exp", (Object)string.getFormulaExpression());
                }
                if (!ReportConverterTool.ExportToXLS(jetObject, string3)) {
                    arrayList.add(object4);
                }
            } else {
                if (jetProperty.isChagneByFmtt()) {
                    object4 = jetProperty.getChangeByFmtt().toString();
                    jSONObject.put("c", object4);
                    if (!ReportConverterTool.ExportToXLS(jetObject, string3)) {
                        arrayList.add(object4);
                    }
                }
                if (jetProperty.isChangeByBL()) {
                    object4 = jetProperty.getChangeByBL().toString();
                    jSONObject.put("b", object4);
                    if (!ReportConverterTool.ExportToXLS(jetObject, string3)) {
                        arrayList.add(object4);
                    }
                }
                if (jetProperty.isEnableAutoValue()) {
                    jSONObject.put(string7, (Object)1);
                    if (jetProperty.isCurrentAutoValue()) {
                        jSONObject.put("av", (Object)1);
                    } else {
                        jSONObject.put("av", (Object)0);
                    }
                } else {
                    jSONObject.put(string7, (Object)0);
                }
                if (jetProperty.isChangeByOther()) {
                    object4 = jetProperty.getChangeByObject().toString();
                    jSONObject.put("f", object4);
                    if (!ReportConverterTool.ExportToXLS(jetObject, string3)) {
                        arrayList.add(object4);
                    }
                }
            }
            string4 = jetProperty.toUnitString();
            if (jetProperty instanceof JetVector) {
                jSONObject.put("vector", jetProperty.getValue());
            }
            if (string3.equalsIgnoreCase("Link")) {
                if (!bl || (object4 = ReportConverterTool.I((JetLink)jetProperty, arrayList, jetUUniverse, (JetRptObject)jetObject)) == null) continue;
                hashMap.put("Link", object4);
                continue;
            }
            jSONObject.put(string6, (Object)string4);
            hashMap.put(jetProperty.getName(), jSONObject);
        }
        if (jetObject instanceof JetRptReportSet) {
            object4 = Context.getActionEnv();
            catalogKeyImpl = (CatalogKeyImpl)webReport.getCatalogID();
            String string8 = catalogKeyImpl.getID().toString();
            string = object4.getCatalogDir(string8).getPath();
            ReportConverterTool.CHART_PAPER_FONTNAMES("catalogPath", string, hashMap);
            object3 = object4.getRptsetDir();
            if (object3 != null && (object2 = object4.getRptsetDir().getFile(jetRptReport.getInstName())) != null) {
                object = object2.getFile("temp").getPath();
                ReportConverterTool.CHART_PAPER_FONTNAMES("reportTempPath", (String)object, hashMap);
            }
        } else if (jetObject instanceof JetRptDBField) {
            object4 = (IDataContainer)TemplateKit.getMatchedParentComponent((JetRptObject)jetObject, TemplateKit.DCs);
            if (object4 != null) {
                boolean bl2 = ReportConverterTool.isSummaryField((JetRptDBField)jetObject, (IDataContainer)object4, jetUUniverse);
                ReportConverterTool.CHART_PAPER_FONTNAMES("IsSummary", Boolean.toString(bl2), hashMap);
            }
            if (TemplateKit.isRunningTotalField((JetRptDBField)jetObject, jetUUniverse, jetRptReport)) {
                ReportConverterTool.CHART_PAPER_FONTNAMES("IsRunningTotal", Boolean.toString(true), hashMap);
            }
        }
        if (jetObject instanceof JetRptCTAggField) {
            ReportConverterTool.CHART_PAPER_FONTNAMES("IsBlank", Boolean.toString(((JetRptCTAggField)jetObject).isBlank()), hashMap);
        }
        if (jetObject instanceof JetRptFilterControl) {
            object4 = (JetRptFilterControl)jetObject;
            SpecialFunction specialFunction = object4.getSpecialFunction();
            int n = -1;
            int n2 = -1;
            if (specialFunction != null && (n = specialFunction.getFunctionType()) == 1) {
                n2 = ((DateTimeIntervalGrpBy)specialFunction).getIntervalUnit();
            }
            ReportConverterTool.CHART_PAPER_FONTSTYLES("func", String.valueOf(n2), hashMap, 5);
            object3 = object4.getArtificialDataType();
            if (object3 != null && ((String)object3).trim().length() > 0) {
                int n3 = MappingSQLType.mergeParamTypeToSQLType((String)object3);
                ReportConverterTool.CHART_PAPER_FONTSTYLES("SQLType", String.valueOf(n3), hashMap, 5);
            } else {
                ReportConverterTool.CHART_PAPER_FONTSTYLES("SQLType", String.valueOf(12), hashMap, 5);
            }
        } else if (jetObject instanceof JetRptChartPlatform) {
            object4 = webReport.getReportInfo().getOwner();
            JetRptChartPlatform jetRptChartPlatform = (JetRptChartPlatform)jetObject;
            JSONArray jSONArray = ReportConverterTool.getChartDisplayValueNames(jetRptChartPlatform, jetUUniverse, (UserInfo)object4, nLSApplyParam);
            ReportConverterTool.CHART_PAPER_FONTNAMES("DisplayValueNames", jSONArray.toString(), hashMap);
            string = ReportConverterTool.getChartDisplayGroupNames(jetRptChartPlatform, jetUUniverse, (UserInfo)object4, nLSApplyParam);
            ReportConverterTool.CHART_PAPER_FONTNAMES("DisplayGroupNames", string.toString(), hashMap);
            object3 = LinkKit.getAllChartShowValueLinkObject(jetRptChartPlatform);
            ReportConverterTool.CHART_PAPER_FONTNAMES("GraphLinks", object3.toString(), hashMap);
            object2 = (String)jetRptChartPlatform.nameToProperty("ChartDefinition").getValue();
            object = new ChartDefObject((String)object2);
            ReportConverterTool.CHART_PAPER_FONTNAMES("ISSPType1", ((ChartDefObject)object).isSPType1().toString(), hashMap);
            ReportConverterTool.CHART_PAPER_FONTNAMES("ISSPType2", ((ChartDefObject)object).isSPType2().toString(), hashMap);
        } else if (jetObject instanceof JetRptChartPaper) {
            int n;
            object4 = ReportConverterTool.DCs((JetRptChartComponent)((JetRptChartPaper)jetObject), CHART_PAPER_FONTNAMES, CHART_PAPER_FONTSTYLES);
            int n4 = CHART_PAPER_FONTNAMES.length;
            for (n = 0; n < n4; n += 1) {
                ReportConverterTool.CHART_PAPER_FONTNAMES(CHART_PAPER_FONTNAMES[n], (String)object4[n], hashMap);
            }
            n = LinkKit.hasChartAxisLinkObject((JetRptChartPaper)jetObject, 3) ? 1 : 0;
            n4 = LinkKit.hasChartAxisLinkObject((JetRptChartPaper)jetObject, 4) ? 1 : 0;
            ReportConverterTool.CHART_PAPER_FONTNAMES("HasXLink", Boolean.toString(n != 0), hashMap);
            ReportConverterTool.CHART_PAPER_FONTNAMES("HasZLink", Boolean.toString(n4 != 0), hashMap);
        } else if (jetObject instanceof JetRptChartLegend || jetObject instanceof JetRptChartLabel) {
            object4 = ReportConverterTool.DCs((JetRptChartComponent)jetObject, CHART_LABEL_FONTNAMES, CHART_LABEL_FONTSTYLES);
            int n = CHART_LABEL_FONTNAMES.length;
            for (int i = 0; i < n; ++i) {
                ReportConverterTool.CHART_PAPER_FONTNAMES(CHART_LABEL_FONTNAMES[i], (String)object4[i], hashMap);
            }
        }
        if (bl) {
            ReportConverterTool.CHART_PAPER_FONTNAMES("HasLink", Boolean.toString(bl), hashMap);
        }
        if (jetObject instanceof JetRptField) {
            object4 = (JetRptField)jetObject;
            JetFont jetFont = ((JetRptField)object4).fontName;
            if (!jetFont.isSetRuntimeChgBy()) {
                boolean bl3;
                String string9 = ((JetRptField)object4).fontName.get();
                boolean bl4 = bl3 = string9.charAt(0) == '*';
                if (bl3) {
                    object3 = ReportConverterTool.ENGLISH(string9, ((JetRptField)object4).bold.get(), ((JetRptField)object4).italic.get());
                    int n = ReportConverterTool.ExportToCSV(string9, ((JetRptField)object4).bold.get(), ((JetRptField)object4).italic.get());
                    ReportConverterTool.CHART_PAPER_FONTNAMES("TFF", (String)object3, hashMap);
                    ReportConverterTool.CHART_PAPER_FONTNAMES("TFS", String.valueOf(n), hashMap);
                }
            }
        }
    }

    private static Iterator CHART_LABEL_FONTNAMES(JetObject jetObject, WebRptObject webRptObject) {
        Iterator iterator = webRptObject.getUsedPropertyNames();
        if (iterator == null) {
            if (jetObject instanceof JetRptParaTextSegment) {
                JetRptParaTextSegment jetRptParaTextSegment = (JetRptParaTextSegment)jetObject;
                iterator = jetRptParaTextSegment.getStyles(true).keySet().iterator();
            } else {
                iterator = jetObject.getProperties().keySet().iterator();
            }
        }
        return iterator;
    }

    private static void CHART_LABEL_FONTSTYLES(WebRptObject webRptObject, JetObject jetObject) {
        jetObject.setEditable();
        Map map = webRptObject.getProperties();
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            JetProperty jetProperty = jetObject.nameToProperty(string);
            if (jetProperty == null) continue;
            string2 = string2.substring(1, string2.length() - 1);
            List list = StringUtil.split((String)string2, (char)',', (String[])new String[]{"\"", "\""});
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)list.get(i);
                int n2 = string3.indexOf(58);
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1, string3.length());
                if (string4.indexOf(99) != -1) {
                    jetProperty.setCanChangeByFmtt(true);
                    jetProperty.setChangeByFmtt((Object)string5.substring(1, string5.length() - 1));
                }
                if (string4.indexOf(98) != -1) {
                    jetProperty.setCanChangeByBL(true);
                    jetProperty.setChangeByFmtt((Object)string5.substring(1, string5.length() - 1));
                }
                if (string4.indexOf(102) != -1) {
                    jetProperty.setCanChangeByOthers(true);
                    jetProperty.setChangeByObject((Object)string5.substring(1, string5.length() - 1));
                }
                if (string4.indexOf(118) == -1) continue;
                jetProperty.setUnitValue(string5.substring(1, string5.length() - 1));
            }
        }
    }

    public static String escapeJSONString(String string) {
        int n;
        if (string == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n2 = n = cArray == null ? 0 : cArray.length;
        block9: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\\\b");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\\\n");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\\\r");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\\\f");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static JSONObject CHART_PAPER_FONTNAMES(String string, String string2, Map map) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("v", (Object)string2);
        map.put(string, jSONObject);
        return jSONObject;
    }

    private static void CHART_PAPER_FONTSTYLES(String string, String string2, Map map, int n) {
        JSONObject jSONObject = ReportConverterTool.CHART_PAPER_FONTNAMES(string, string2, map);
        jSONObject.put("t", (Object)n);
    }

    public static boolean isSummaryField(JetRptDBField jetRptDBField, IDataContainer iDataContainer, JetUUniverse jetUUniverse) {
        int n = TemplateKit.getFieldResIntType(jetRptDBField, jetUUniverse);
        return n == ResourceTypes.AGGREGATION.intType();
    }

    public static JSONArray getChartDisplayValueNames(JetRptChartPlatform jetRptChartPlatform, JetUUniverse jetUUniverse, UserInfo userInfo, NLSApplyParam nLSApplyParam) {
        JSONArray jSONArray = new JSONArray();
        ChartDefinition chartDefinition = jetRptChartPlatform.getChartDefinition();
        String[] stringArray = chartDefinition.getIndexedValueNames();
        if (stringArray != null) {
            Scope scope = DataKit.buildBusinessScope(jetUUniverse, (IDataContainer)jetRptChartPlatform);
            String string = scope.getDataSourceName();
            Map map = DataKit.getDyBVElementDisplayName(userInfo);
            boolean bl = MetaNLSKit.isEmptyMetaDataNLS((NLSApplyParam)nLSApplyParam);
            INLSMap iNLSMap = bl ? null : nLSApplyParam.createNLSTable(null);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                try {
                    BLNode bLNode = DataKit.getBLNode(scope, string2);
                    String string3 = DataKit.getNodeDispalyName(bLNode, string, map, iNLSMap);
                    jSONArray.add(i, (Object)string3);
                    continue;
                }
                catch (WRException wRException) {
                    Logger.logE(wRException);
                }
            }
        }
        return jSONArray;
    }

    public static JSONObject getChartDisplayGroupNames(JetRptChartPlatform jetRptChartPlatform, JetUUniverse jetUUniverse, UserInfo userInfo, NLSApplyParam nLSApplyParam) {
        String string;
        BLNode bLNode;
        INLSMap iNLSMap;
        JSONObject jSONObject = new JSONObject();
        ChartDefinition chartDefinition = jetRptChartPlatform.getChartDefinition();
        String string2 = chartDefinition.getCategory();
        String string3 = chartDefinition.getSeries();
        Scope scope = DataKit.buildBusinessScope(jetUUniverse, (IDataContainer)jetRptChartPlatform);
        String string4 = scope.getDataSourceName();
        Map map = DataKit.getDyBVElementDisplayName(userInfo);
        boolean bl = MetaNLSKit.isEmptyMetaDataNLS((NLSApplyParam)nLSApplyParam);
        INLSMap iNLSMap2 = iNLSMap = bl ? null : nLSApplyParam.createNLSTable(null);
        if (string2 != null) {
            try {
                bLNode = DataKit.getBLNode(scope, string2);
                string = DataKit.getNodeDispalyName(bLNode, string4, map, iNLSMap);
                jSONObject.put("categoryDIS", (Object)string);
            }
            catch (WRException wRException) {
                Logger.logE(wRException);
            }
        }
        if (string3 != null) {
            try {
                bLNode = DataKit.getBLNode(scope, string3);
                string = DataKit.getNodeDispalyName(bLNode, string4, map, iNLSMap);
                jSONObject.put("seriesDIS", (Object)string);
            }
            catch (WRException wRException) {
                Logger.logE(wRException);
            }
        }
        return jSONObject;
    }

    private static String[] DCs(JetRptChartComponent jetRptChartComponent, String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string = stringArray[i];
            String string2 = (String)jetRptChartComponent.getPropertyByName(string).getObject();
            boolean bl2 = bl = string2.charAt(0) == '*';
            if (bl) {
                int n2 = ((Number)jetRptChartComponent.getPropertyByName(stringArray2[i]).getObject()).intValue();
                boolean bl3 = n2 == 1 || n2 == 3;
                boolean bl4 = n2 == 2 || n2 == 3;
                string2 = ReportConverterTool.ENGLISH(string2, bl3, bl4);
            }
            stringArray3[i] = string2;
        }
        return stringArray3;
    }

    private static String ENGLISH(String string, boolean bl, boolean bl2) {
        String string2;
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        if ((string2 = FontSets.getFont((String)string, (int)n, (int)16).getFamily(Locale.ENGLISH)) != null && string2.charAt(0) == '*') {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private static int ExportToCSV(String string, boolean bl, boolean bl2) {
        if (string.startsWith("*")) {
            int n = 0;
            if (bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            n = FontSets.getTrueFontStyleForUser((String)string, (int)n);
            return n;
        }
        return -1;
    }

    private static boolean ExportToXLS(JetObject jetObject, String string) {
        return (jetObject instanceof JetRptNewTable || jetObject instanceof JetRptCTCrossTab || jetObject instanceof JetRptChartPlatform || jetObject instanceof JetRptGMap) && AGGREGATION.contains(string);
    }

    private static JSONObject I(JetLink jetLink, List list, JetUUniverse jetUUniverse, JetRptObject jetRptObject) {
        JetRptDataContainer jetRptDataContainer;
        List list2;
        int n = jetLink.getLinkType();
        if ((n == 1 || n == 3) && (list2 = jetLink.getURLBLColumnNames()) != null && (jetRptDataContainer = (JetRptDataContainer)TemplateKit.getMatchedParentComponent(jetRptObject, TemplateKit.DCs)) != null && jetRptDataContainer.getBindedDataSet() != null) {
            Scope scope = DataKit.buildBusinessScope(jetUUniverse, (IDataContainer)jetRptDataContainer);
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (String string : list2) {
                BLNode bLNode;
                if (string == null || string.trim().length() == 0 || jetRptDataContainer == null || !((bLNode = scope.getBLNodeByQualifiedDisplayName(string)) instanceof DataElementInfo)) continue;
                String string2 = ((DataElementInfo)bLNode).getRefMappingName();
                list.add(string2);
                jSONArray.put((Object)string2);
            }
            jSONObject.put("r", (Object)jSONArray);
            return jSONObject;
        }
        return null;
    }

    static {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(JetRptViewComponent.class);
        hashSet.add(JetRptTypedFilterExpression.class);
        hashSet.add(JetRptSortContainer.class);
        hashSet.add(JetRptDataSets.class);
        hashSet.add(JetRptReportFormulaClassSet.class);
        hashSet.add(JetRptConditionalFormatSet.class);
        hashSet.add(JetRptTOC.class);
        hashSet.add(JetRptViews.class);
        hashSet.add(JetRptView.class);
        hashSet.add(JetRptPageStart.class);
        hashSet.add(JetRptPageEnd.class);
        hashSet.add(JetRptFlyFormula.class);
        hashSet.add(JetRptQueryFlyFormula.class);
        hashSet.add(JetRptFlyMeasure.class);
        ignoreTemplate = Collections.unmodifiableSet(hashSet);
        CHART_PAPER_FONTNAMES = new String[]{"AxisXLabelTextFontName", "AxisYLabelTextFontName", "AxisY2LabelTextFontName", "AxisZLabelTextFontName", "HintTextFontName"};
        CHART_PAPER_FONTSTYLES = new String[]{"AxisXLabelTextFontStyle", "AxisYLabelTextFontStyle", "AxisY2LabelTextFontStyle", "AxisZLabelTextFontStyle", "HintTextFontStyle"};
        CHART_LABEL_FONTNAMES = new String[]{"LabelTextFontName"};
        CHART_LABEL_FONTSTYLES = new String[]{"LabelTextFontStyle"};
        AGGREGATION = new HashSet(11);
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.Background));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.Invisible));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.Suppressed));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.SuppressedIfNoRecords));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.TOCAnchor));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.ExportToCSV));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.ExportToXLS));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.AnchorDispValue));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.BorderColor));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.SelectStartPosition));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.RecordLocation));
        AGGREGATION.add(PropertyNames.getDefinitionName((int)PropertyNames.SuppressEmpty));
    }
}

