/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.dashboard.service.util;

import com.jinfonet.web.UserInfo;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.DashNLSResource;
import com.jinfonet.web.beans.DashNLSResourceImpl;
import com.jinfonet.web.beans.FilterControlDef;
import com.jinfonet.web.beans.ResourceDef;
import com.jinfonet.web.modules.dashboard.Dashboard;
import com.jinfonet.web.modules.dashboard.Gadget;
import com.jinfonet.web.modules.dashboard.Module;
import com.jinfonet.web.modules.dashboard.service.util.DashboardLoader;
import com.jinfonet.web.modules.resource.service.util.DashboardUpgrade;
import com.jinfonet.web.modules.resource.service.util.ResourceKit;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.css.CssParser;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONObject;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.intf.jrs.ExResourceManager;

public class DashboardProvider {
    private static DashboardProvider SEDU = null;
    private static String add = "header";
    private static String addAll = "font-family";
    private static String addDisplay = "body";

    private DashboardProvider() {
    }

    public static synchronized DashboardProvider getInstance() {
        if (SEDU == null) {
            SEDU = new DashboardProvider();
        }
        return SEDU;
    }

    public Dashboard getDashboard(String string, UserInfo userInfo, ResourceDef resourceDef) throws WRException {
        Dashboard dashboard = this.getDashboard(userInfo, resourceDef);
        int n = dashboard.getSerial();
        if (n < 65793) {
            DashboardUpgrade.upgrade(dashboard, string, userInfo, 65793, true);
        }
        return dashboard;
    }

    public Dashboard getUrlDashboard(UserInfo userInfo) throws WRException {
        InputStream inputStream = null;
        try {
            inputStream = Tools.getResourceAsStream((String)"urldashboard.dsh");
        }
        catch (IOException iOException) {
            throw new WRException(65537, (Throwable)iOException, new String[0]);
        }
        DashboardLoader dashboardLoader = new DashboardLoader();
        Dashboard dashboard = dashboardLoader.load(inputStream);
        return dashboard;
    }

    public static List getDashboardResource(String string) throws WRException {
        Dashboard dashboard = DashboardLoader.load(string);
        List list = dashboard.getPanel(add).getAllGadgets();
        return DashboardProvider.SEDU(list);
    }

    private static List SEDU(List list) throws WRException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Gadget gadget : list) {
            String string;
            Module module = gadget.getModule();
            if ("image".equals(module.getParameter("contentType")) && (Integer)module.getParameter("type") != 1) {
                string = module.getUrl();
                if (string.indexOf(47) > 0) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                arrayList.add(string);
                continue;
            }
            if (!"native".equals(module.getType())) continue;
            string = (JSONArray)module.getParameter("resources");
            for (int i = 0; i < string.size(); ++i) {
                JSONObject jSONObject = (JSONObject)string.get(i);
                if (!"image".equals(jSONObject.getString("contentType")) || jSONObject.getInt("type") == 1) continue;
                arrayList.add(jSONObject.getString("src"));
            }
        }
        return arrayList;
    }

    public static List getTTF(String string) throws WRException {
        List list = ResourceKit.getTTFonts();
        if (list.size() > 0) {
            Dashboard dashboard = DashboardLoader.load(string);
            List list2 = dashboard.getPanel(add).getAllGadgets();
            return DashboardProvider.add(list2);
        }
        return list;
    }

    private static List add(List list) throws WRException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List list2 = ResourceKit.getTTFonts();
        for (Gadget object : list) {
            String string;
            LinkedHashMap linkedHashMap;
            String string2;
            Module module = object.getModule();
            if (!"com.jinfonet.ui.Label".equals(module.getParameter("classType")) || (string2 = (String)(linkedHashMap = CssParser.parseDeclaration(string = (String)module.getParameter("css"))).get(addAll)) == null || arrayList2.contains(string2)) continue;
            arrayList2.add(string2);
        }
        if (arrayList2.size() > 0) {
            for (String string : arrayList2) {
                if (!list2.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static List getDashboardRelatedRes(String string) throws WRException {
        ArrayList<List> arrayList = new ArrayList<List>();
        Dashboard dashboard = DashboardLoader.load(string);
        List list = dashboard.getPanel(add).getAllGadgets();
        arrayList.add(DashboardProvider.add(list));
        list.addAll(dashboard.getPanel(addDisplay).getAllGadgets());
        arrayList.add(0, DashboardProvider.SEDU(list));
        return arrayList;
    }

    public static DashNLSResource getDashboardNLSRes(String string) {
        String string2;
        Object object;
        Module module;
        DashNLSResourceImpl dashNLSResourceImpl = new DashNLSResourceImpl();
        Dashboard dashboard = DashboardLoader.load(string);
        List list = dashboard.getPanel(add).getAllGadgets();
        for (Gadget gadget : list) {
            module = gadget.getModule();
            object = (String)module.getParameter("classType");
            if (!"com.jinfonet.ui.Label".equals(object)) continue;
            string2 = (String)module.getParameter("contentType");
            String string3 = (String)module.getParameter("text");
            if (string2.equalsIgnoreCase("text")) {
                dashNLSResourceImpl.addDisplay(0, string3);
            }
            String string4 = (String)module.getParameter("css");
            Font font = DashboardProvider.addAll(string4);
            dashNLSResourceImpl.addFont(font);
            Object object2 = module.getParameter("format");
            if (object2 == null) continue;
            dashNLSResourceImpl.addFormat((String)object2);
        }
        list = dashboard.getPanel(addDisplay).getAllGadgets();
        for (Gadget gadget : list) {
            if (gadget.isResGadget()) continue;
            module = gadget.getModule();
            object = gadget.getLCDef();
            string2 = null;
            string2 = object instanceof FilterControlDef ? ((FilterControlDef)object).getTitle() : (String)module.getParameter("title");
            if (string2 == null || string2.isEmpty()) continue;
            dashNLSResourceImpl.addDisplay(7, string2);
        }
        return dashNLSResourceImpl;
    }

    private static Font addAll(String string) {
        LinkedHashMap linkedHashMap = CssParser.parseDeclaration(string);
        String[] stringArray = ((String)linkedHashMap.get(addAll)).split(",");
        String string2 = stringArray.length > 0 ? stringArray[0] : "Default";
        int n = 0;
        String string3 = (String)linkedHashMap.get("font-size");
        string3 = string3.substring(0, string3.indexOf("px")).trim();
        int n2 = Integer.parseInt(string3);
        double d = Unit.convertPixelToInch((int)n2);
        int n3 = (int)Math.round(d *= 72.0);
        Font font = new Font(string2, n, n3);
        return font;
    }

    public boolean isUpgrade(Dashboard dashboard) {
        return dashboard.getSerial() < 65793;
    }

    public Dashboard upgrade(Dashboard dashboard, UserInfo userInfo, int n) {
        if (n == -1) {
            n = 65793;
        }
        return DashboardUpgrade.upgrade(dashboard, null, userInfo, n, false);
    }

    public Dashboard getDashboard(UserInfo userInfo, ResourceDef resourceDef) throws WRException {
        String string = null;
        try {
            string = ResourceKit.updateResourceDef(userInfo, resourceDef, new ExResourceManager[0]).getRealPath();
        }
        catch (RptServerException rptServerException) {
            throw new WRException(262164, (Throwable)((Object)rptServerException), new String[0]);
        }
        DashboardLoader dashboardLoader = new DashboardLoader(string);
        Dashboard dashboard = dashboardLoader.load();
        dashboard.setResourceDef(resourceDef);
        boolean bl = false;
        PathInfo pathInfo = null;
        String string2 = (String)resourceDef.getDependent("rptPath");
        if (!resourceDef.isRealPath() && string2 != null) {
            pathInfo = ResourceKit.getResourcePathInfo(userInfo, string2, new ExResourceManager[0]);
            bl = pathInfo.isDynamic();
        }
        if (resourceDef.isRealPath() || bl) {
            List list = dashboard.getAllGadgets();
            for (Gadget gadget : list) {
                ResourceDef resourceDef2 = gadget.getLCRes();
                if (resourceDef2 == null || !resourceDef2.isRealPath() || new File(resourceDef2.getFullPath()).exists()) continue;
                String string3 = null;
                try {
                    string3 = bl ? pathInfo.getRealPath() : resourceDef.getPath();
                }
                catch (RptServerException rptServerException) {
                    throw new WRException(262164, (Throwable)((Object)rptServerException), new String[0]);
                }
                string3 = FileUtil.getFilePath((String)string3);
                File file = new File(string3, FileUtil.getFileName((String)resourceDef2.getFullPath()));
                resourceDef2.setPath(file.getAbsolutePath());
            }
        }
        return dashboard;
    }
}

