/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.service;

import com.jinfonet.api.objectmanager.ObjectManager;
import com.jinfonet.web.ActionFactory;
import com.jinfonet.web.NLSProvider;
import com.jinfonet.web.NLSProviderImpl;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.PrinterInfoImpl;
import com.jinfonet.web.modules.component.service.GeoProxyManager;
import com.jinfonet.web.modules.resource.service.util.ResourceKit;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.JProperties;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.vfs.HostDir;
import com.jinfonet.web.vfs.MemvDir;
import com.jinfonet.web.vfs.Process;
import com.jinfonet.web.vfs.VFile;
import com.jinfonet.web.vfs.VFileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.ReportEnv;
import jet.dataservice.api.JDataService;
import jet.server.api.ExpiryListener;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.http.HttpUtil;
import jet.server.jrserver.JRRptServer;
import jet.server.service.ManagedService;
import jet.server.service.ServiceEnv;
import jet.server.service.ServiceSummary;
import jet.util.SystemTools;

public final class ServiceContext {
    private static ServiceContext SEDU = null;
    private ServiceEnv T = null;
    private VFileSystem Z = null;
    private File add;
    private Map addSessionExpiryListener;
    private JProperties append;
    private List copyDetailTableTemplate;
    private SessionExpiredListener decreaseNumber;
    private SheetCounter delete;
    private GeoProxyManager destroy;

    public static ServiceContext getInstance() {
        return SEDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext(ServiceEnv serviceEnv) {
        Class<ServiceContext> clazz = ServiceContext.class;
        synchronized (ServiceContext.class) {
            if (SEDU != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.T = serviceEnv;
            File file = new File(serviceEnv.getTempPath(), "webos");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.add = file;
            this.Z = this.SEDU(new File(serviceEnv.getReportHome()), file);
            this.addSessionExpiryListener = new HashMap();
            this.append = Tools.getProperties((String)"factory.properties");
            for (Map.Entry entry : this.append.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                try {
                    this.addSessionExpiryListener.put(string2, (ActionFactory)Class.forName(string2).newInstance());
                }
                catch (Exception exception) {
                    WRException wRException = new WRException(0xFF0001, (Throwable)exception, new String[0]);
                    Logger.logE(wRException);
                }
            }
            try {
                ResourceKit.copyDetailTableTemplate(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.logE(new WRException(65538, (Throwable)fileNotFoundException, new String[0]));
            }
            catch (IOException iOException) {
                Logger.logE(new WRException(65537, (Throwable)iOException, new String[0]));
            }
            catch (Exception exception) {
                Logger.logE(new WRException(0xFF0001, (Throwable)exception, new String[0]));
            }
            int n = ReportEnv.getR();
            this.delete = new SheetCounter(n);
            this.destroy = GeoProxyManager.getInstance();
            SEDU = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getServiceHome() {
        String string = this.T.getReportHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public VFileSystem getVFS() {
        return this.Z;
    }

    public ActionFactory getActionFactory(String string) {
        return (ActionFactory)this.addSessionExpiryListener.get(this.append.get((Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VFileSystem SEDU(File file, File file2) {
        VFile vFile;
        VFileSystem vFileSystem = VFileSystem.getFileSystem();
        VFile vFile2 = vFile = vFileSystem.getRoot();
        synchronized (vFile2) {
            if (vFileSystem.getTemp() == null) {
                new HostDir(vFile, "temp", file2, new boolean[0]);
            }
            if (vFile.getFile("usersession") == null) {
                new MemvDir(vFile, "usersession");
            }
            if (vFileSystem.getHome() == null) {
                new HostDir(vFile, "svrhome", file, false);
            }
        }
        return vFileSystem;
    }

    public JRRptServer getJRRptServer() {
        return this.T.getRptServer();
    }

    public GeoProxyManager getGeoProxyManager() {
        return this.destroy;
    }

    public ObjectManager getObjectManager() {
        return this.getJRRptServer().getObjectManager();
    }

    public void registerSessionListener() {
        JRRptServer jRRptServer = this.getJRRptServer();
        UserSessionManager userSessionManager = jRRptServer.getUserSessionManager();
        if (userSessionManager != null) {
            this.decreaseNumber = new SessionExpiredListener();
            userSessionManager.addSessionExpiryListener(this.decreaseNumber);
        } else {
            Logger.logW(new WRException(262164, (Throwable)new NullPointerException("UserSessionManager is null"), new String[0]));
        }
    }

    public int getServerID() {
        int n = -1;
        JRRptServer jRRptServer = this.getJRRptServer();
        if (jRRptServer.isClusterEnable()) {
            n = jRRptServer.getClusterService().getLocalMember().getID();
        }
        return n;
    }

    public JDataService getDataService(String string) {
        List list = this.getJRRptServer().getServiceManager().listServices(string, "jet.dataservice.api.JDataService");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ManagedService managedService = (ManagedService)list.get(i);
            ServiceSummary serviceSummary = managedService.getSummary();
            if (serviceSummary != null) continue;
            return (JDataService)managedService;
        }
        return null;
    }

    public File getTempDir() {
        return this.add;
    }

    public int getCPUs() {
        int n = ReportEnv.getCPU();
        int n2 = Math.min(SystemTools.getCPUs(), n == 0 ? Integer.MAX_VALUE : n);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAvailablePrinters() {
        ServiceContext serviceContext = this;
        synchronized (serviceContext) {
            if (this.copyDetailTableTemplate == null) {
                this.copyDetailTableTemplate = new ArrayList();
                JRRptServer jRRptServer = this.getJRRptServer();
                Hashtable hashtable = jRRptServer.getMediaTray();
                for (String string : jRRptServer.getPrinters()) {
                    PrinterInfoImpl printerInfoImpl = new PrinterInfoImpl(string);
                    Vector vector = (Vector)hashtable.get(string);
                    int n = vector.size();
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = (String)vector.get(i);
                    }
                    printerInfoImpl.setMediaTrayNames(stringArray);
                    this.copyDetailTableTemplate.add(printerInfoImpl);
                }
            }
        }
        return this.copyDetailTableTemplate;
    }

    public NLSProvider getNLSProvider(Locale locale) {
        boolean bl = HttpUtil.isStandaloneServer();
        String string = bl ? ReportEnv.homePath : "";
        return NLSProviderImpl.getNLSProvider(locale, bl, string);
    }

    public void destroy() {
        JRRptServer jRRptServer = this.getJRRptServer();
        UserSessionManager userSessionManager = jRRptServer.getUserSessionManager();
        userSessionManager.removeSessionExpiryListener(this.decreaseNumber);
        this.destroy.destroy();
        this.destroy = null;
        this.Z.destroy();
    }

    public void killProcess(Process process) {
        Object object;
        if (process == null) {
            return;
        }
        String string = process.getName();
        String string2 = (String)process.getAttribute("ussid", new Object[0]);
        String string3 = (String)process.getAttribute("http-session", new Object[0]);
        VFile vFile = this.Z.getRoot().getFile("usersession").getFile(string2);
        if (vFile != null && (object = vFile.delete(string)) != null) {
            object.destroy();
        }
        if ((process = (Process)this.Z.getProc().delete(string)) != null) {
            process.destroy();
        }
        if (Logger.T) {
            object = new StringBuilder();
            ((StringBuilder)object).append("A-0-KillProcess");
            ((StringBuilder)object).append(" session=").append(string3).append(":").append(string2);
            ((StringBuilder)object).append(" pid=").append(string);
            StringWriter stringWriter = new StringWriter();
            new Throwable("TRACE Caller:").printStackTrace(new PrintWriter((Writer)stringWriter, true));
            ((StringBuilder)object).append("\n").append(stringWriter.getBuffer().toString());
            Logger.logT((StringBuilder)object);
        }
    }

    public int getCanOpenNumber() {
        return this.delete.getCanOpenNumber();
    }

    public int increaseNumber(int n) {
        return this.delete.increaseNumber(n);
    }

    public void decreaseNumber(int n) {
        this.delete.decreaseNumber(n);
    }

    private static class SheetCounter {
        int maxNumer;
        int count;
        Object lock = new Object();

        SheetCounter(int n) {
            this.maxNumer = n;
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getCanOpenNumber() {
            Object object = this.lock;
            synchronized (object) {
                return this.maxNumer <= 0 ? -1 : this.maxNumer - this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int increaseNumber(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (this.maxNumer <= 0) {
                this.count += n;
                return n;
            }
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < n; ++i) {
                    ++this.count;
                    if (this.count <= this.maxNumer) continue;
                    this.count = this.maxNumer;
                    return i;
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decreaseNumber(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            Object object = this.lock;
            synchronized (object) {
                this.count -= n;
                if (this.count <= 0) {
                    this.count = 0;
                }
            }
        }
    }

    private class SessionExpiredListener
    implements ExpiryListener {
        private StringBuilder SEDU = new StringBuilder();

        @Override
        public void expire(UserSession userSession) {
            String string = userSession.getID();
            VFile vFile = ServiceContext.this.Z.getRoot();
            if (vFile == null) {
                return;
            }
            VFile vFile2 = vFile.getFile("usersession");
            VFile vFile3 = vFile2.getFile(string);
            if (vFile3 == null) {
                return;
            }
            String string2 = (String)vFile3.getAttribute("http-session", new Object[0]);
            List list = vFile3.listFiles(null);
            Iterator iterator = list.iterator();
            VFile vFile4 = ServiceContext.this.Z.getProc();
            while (iterator.hasNext()) {
                String string3 = ((VFile)iterator.next()).getName();
                Process process = (Process)vFile4.getFile(string3);
                ServiceContext.this.killProcess(process);
            }
            if (Logger.T) {
                this.SEDU.delete(0, this.SEDU.length());
                this.SEDU.append("A-O-ExpiredListener@Server");
                this.SEDU.append(" session=").append(string2).append(":").append(string);
                this.SEDU.append(" ussns=").append(vFile2.listFiles(null).size());
                this.SEDU.append(" procs=").append(ServiceContext.this.Z.getProc().listFiles(null).size());
                Logger.logT(this.SEDU);
            }
        }
    }
}

