/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgent {
    public String kernel;
    public String kver;
    public String appName;
    public String appVersion;
    public boolean isMobile = false;
    public String userAgent;
    private static Pattern SEDU = Pattern.compile("Firefox[ \\/]([\\d.]+)", 2);
    private static Pattern compile = Pattern.compile("rv:([\\d.]+)", 2);
    private static Pattern equals = Pattern.compile("Chrome[ \\/]([\\d.]+)", 2);
    private static Pattern find = Pattern.compile("Presto[ \\/]([\\d.]+).*?Version[ \\/]([\\d.]+)", 2);
    private static Pattern group = Pattern.compile("Safari[ \\/]([\\d.]+)", 2);
    private static Pattern indexOf = Pattern.compile("Version[ \\/]([\\d.]+)", 2);
    private static Pattern matcher = Pattern.compile("Trident[ \\/]([\\d.]+)", 2);
    private static Pattern parseFloat = Pattern.compile("MSIE ([\\d.]+)", 2);
    private static Pattern valueOf = Pattern.compile("(\\w+)[ \\/]([\\d.]+)\\s*$", 2);

    public String toString() {
        return this.userAgent;
    }

    public UserAgent(String string) {
        this.userAgent = string;
        Matcher matcher = SEDU.matcher(string);
        matcher = SEDU.matcher(string);
        if (matcher.find()) {
            this.appName = "firefox";
            this.appVersion = matcher.group(1);
            this.kernel = "gecko";
            matcher = compile.matcher(string);
            if (matcher.find()) {
                this.kver = matcher.group(1);
            }
        } else {
            matcher = equals.matcher(string);
            if (matcher.find()) {
                this.appName = "chrome";
                this.appVersion = matcher.group(1);
                this.kernel = "webkit";
                this.isMobile = string.indexOf("Android") != -1;
            } else {
                matcher = find.matcher(string);
                if (matcher.find()) {
                    this.appName = "opera";
                    this.appVersion = matcher.group(2);
                    this.kver = matcher.group(1);
                    this.kernel = "presto";
                } else {
                    matcher = group.matcher(string);
                    if (matcher.find()) {
                        this.appName = "safari";
                        matcher = indexOf.matcher(string);
                        if (matcher.find()) {
                            this.appVersion = matcher.group(1);
                        }
                        this.kernel = "webkit";
                        this.isMobile = string.indexOf("Mobile") != -1;
                    } else {
                        matcher = UserAgent.matcher.matcher(string);
                        if (matcher.find()) {
                            this.appName = "ie";
                            this.appVersion = String.valueOf((int)(Float.parseFloat(matcher.group(1)) + 4.0f));
                            this.isMobile = string.indexOf("IEMobile") != -1 || string.indexOf("WPDesktop") != -1;
                        } else {
                            matcher = parseFloat.matcher(string);
                            if (matcher.find()) {
                                this.appName = "ie";
                                this.appVersion = matcher.group(1);
                            } else {
                                matcher = valueOf.matcher(string);
                                if (matcher.find()) {
                                    this.appName = matcher.group(1);
                                    this.appVersion = matcher.group(2);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isIE() {
        return "ie".equals(this.appName);
    }

    public int getIEVersion() {
        return (int)Float.parseFloat(this.appVersion);
    }

    public boolean isFireFox() {
        return "firefox".equals(this.appName);
    }

    public boolean isOpera() {
        return "opera".equals(this.appName);
    }

    public boolean isChrome() {
        return "chrome".equals(this.appName);
    }

    public boolean isSafari() {
        return "safari".equals(this.appName);
    }

    public boolean isMobile() {
        return this.isMobile;
    }
}

