/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.template;

import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.ID;
import com.jinfonet.web.util.ObjectWrapper;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.WrapperManager;
import com.jinfonet.web.util.template.Templates;
import com.jinfonet.web.util.template.ViewLogic;
import com.jinfonet.web.util.template.core.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;

public final class TemplateAssembler {
    public static Templates load(String string) throws IOException, ParseException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return TemplateAssembler.load(FileUtil.getResource((String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Templates load(URL uRL) throws IOException, ParseException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        Templates templates = null;
        ID iD = Tools.getUniqueID((String[])new String[]{uRL.toString()});
        long l = TemplateAssembler.SEDU(uRL);
        WrapperManager wrapperManager = WrapperManager.getInstance();
        ObjectWrapper objectWrapper = wrapperManager.getObjectWrapper(iD);
        if (objectWrapper == null) {
            objectWrapper = new ObjectWrapper(iD, templates);
        } else {
            templates = (Templates)objectWrapper.getObject();
        }
        if (templates == null || templates.lastModified() < l) {
            BufferedReader bufferedReader = null;
            try {
                InputStream inputStream = uRL.openStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                templates = TemplateAssembler.load(bufferedReader);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            templates.setLastModified(l);
            objectWrapper.setObject(templates);
            wrapperManager.putObjectWrapper(objectWrapper);
        }
        return templates;
    }

    public static Templates load(BufferedReader bufferedReader) throws IOException, ParseException {
        if (bufferedReader == null) {
            throw new IllegalArgumentException();
        }
        return Parser.parse(bufferedReader);
    }

    private static long SEDU(URL uRL) {
        String string = uRL.getFile();
        File file = new File(string);
        return file.lastModified();
    }

    public static ViewLogic createViewLogic(Templates templates) {
        if (templates == null) {
            throw new IllegalArgumentException();
        }
        if (templates.getType() != -2147483645) {
            throw new IllegalArgumentException();
        }
        return Parser.parse(templates);
    }

    public static void write(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        if (writer == null || templates == null) {
            throw new IllegalArgumentException();
        }
        int n = templates.getType();
        switch (n) {
            case -2147483645: {
                TemplateAssembler.append(writer, templates, viewLogic);
                viewLogic.reset();
                break;
            }
            case 3: {
                TemplateAssembler.close(writer, templates, viewLogic);
                break;
            }
            case 1: {
                TemplateAssembler.flush(writer, templates, viewLogic);
                break;
            }
            case 0: {
                TemplateAssembler.getFile(writer, templates, viewLogic);
                break;
            }
        }
    }

    private static void append(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            Templates templates2 = (Templates)iterator.next();
            ViewLogic viewLogic2 = viewLogic != null ? viewLogic.getViewLogic(templates2.getName()) : null;
            TemplateAssembler.write(writer, templates2, viewLogic2);
        }
        writer.flush();
    }

    private static void close(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        if (viewLogic == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<!-- BEGIN ").append(templates.getName()).append(" -->");
            writer.write(stringBuilder.toString());
            TemplateAssembler.delete(writer, templates, viewLogic);
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append("<!-- END ").append(templates.getName()).append(" -->");
            writer.write(stringBuilder.toString());
            return;
        }
        if (!viewLogic.visible()) {
            return;
        }
        Object object = viewLogic.getValue();
        if (object instanceof String) {
            writer.write((String)object);
            return;
        }
        int n = viewLogic.iterations();
        for (int i = 0; i < n; ++i) {
            TemplateAssembler.delete(writer, templates, viewLogic);
            viewLogic.increase();
        }
    }

    private static void delete(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            Templates templates2 = (Templates)iterator.next();
            ViewLogic viewLogic2 = viewLogic != null ? viewLogic.getViewLogic(templates2.getName()) : null;
            TemplateAssembler.write(writer, templates2, viewLogic2);
            if (viewLogic2 == null) continue;
            viewLogic2.reset();
        }
    }

    private static void flush(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        if (viewLogic == null) {
            writer.write("${" + templates.getName() + "}");
            return;
        }
        if (!viewLogic.visible()) {
            return;
        }
        Object object = viewLogic.getValue();
        if (object == null) {
            object = "";
        }
        writer.write(object.toString());
    }

    private static void getFile(Writer writer, Templates templates, ViewLogic viewLogic) throws IOException {
        writer.write(templates.getStaticText());
    }
}

