/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.template.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class BeanUtil {
    public static final int NULL = 0;
    public static final int STRING = 1;
    public static final int MAP = 2;
    public static final int LIST = 3;
    public static final int ARRAY = 4;
    public static final int BEAN = 5;
    static Hashtable beanGetters = new Hashtable();
    public static final int DIM = 4;

    public static int objectType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof Map) {
            return 2;
        }
        if (object instanceof List) {
            return 3;
        }
        if (object.getClass().isArray()) {
            return 4;
        }
        return 5;
    }

    public static Object getByName(Object object, String string) {
        if (string == null) {
            return null;
        }
        Token token = BeanUtil.parsePropertyName(string);
        return BeanUtil.getByToken(object, token);
    }

    public static Object getByToken(Object object, Token token) {
        if (token == null) {
            return null;
        }
        Object object2 = null;
        int n = BeanUtil.objectType(object);
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                object2 = ((Map)object).get(token.name);
                if (object2 == null || token.index[0] == -1) break;
                Token token2 = new Token("IDX");
                System.arraycopy(token.index, 0, token2.index, 0, 4);
                object2 = BeanUtil.getByToken(object2, token2);
                break;
            }
            case 3: {
                List list = (List)object;
                int n2 = token.index[0];
                if (list.size() <= 0 || n2 == -1 || (object2 = list.get(n2)) == null || token.index[1] == -1) break;
                Token token3 = new Token("IDX");
                System.arraycopy(token.index, 1, token3.index, 0, 3);
                object2 = BeanUtil.getByToken(object2, token3);
                break;
            }
            case 4: {
                int n3 = token.index[0];
                if (Array.getLength(object) <= 0 || n3 == -1 || (object2 = Array.get(object, n3)) == null || token.index[1] == -1) break;
                Token token4 = new Token("IDX");
                System.arraycopy(token.index, 1, token4.index, 0, 3);
                object2 = BeanUtil.getByToken(object2, token4);
                break;
            }
            case 5: {
                Class<?> clazz = object.getClass();
                String string = clazz.getName();
                BeanGetter beanGetter = (BeanGetter)beanGetters.get(string);
                if (beanGetter == null) {
                    beanGetter = new BeanGetter();
                    beanGetter.beanClass = clazz;
                    beanGetters.put(string, beanGetter);
                }
                if ((object2 = beanGetter.get(object, token.name)) == null || token.index[0] == -1) break;
                Token token5 = new Token("IDX");
                System.arraycopy(token.index, 0, token5.index, 0, 4);
                object2 = BeanUtil.getByToken(object2, token5);
                break;
            }
        }
        return object2;
    }

    public static Object getByPath(Object object, String string) {
        int n;
        Object object2;
        if (object == null) {
            return null;
        }
        ArrayList arrayList = BeanUtil.parsePropertyPath(string);
        int n2 = arrayList.size();
        if (n2 == 0) {
            return null;
        }
        Object object3 = object2 = object;
        for (n = 0; n < n2; ++n) {
            Token token = (Token)arrayList.get(n);
            object2 = BeanUtil.getByToken(object3, token);
            if (object2 == null) {
                object2 = object3;
                continue;
            }
            object3 = object2;
        }
        n = BeanUtil.objectType(object3);
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return object3;
    }

    public static ArrayList parsePropertyPath(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 0) continue;
            Token token = BeanUtil.parsePropertyName(stringArray[i]);
            arrayList.add(token);
        }
        return arrayList;
    }

    public static Token parsePropertyName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\[");
        Token token = new Token(stringArray[0]);
        int n = stringArray.length;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                String string2 = stringArray[i];
                string2 = string2.substring(0, string2.length() - 1);
                token.index[i - 1] = Integer.parseInt(string2);
            }
        }
        return token;
    }

    public static final class Token {
        String name = null;
        int[] index = new int[]{-1, -1, -1, -1};

        public Token(String string) {
            this.name = string;
        }
    }

    private static final class PropertyGetter {
        Method method = null;
        Object[] params = null;
        Field field = null;

        private PropertyGetter() {
        }

        public Object get(Object object) {
            try {
                if (this.method != null) {
                    return this.method.invoke(object, this.params);
                }
                if (this.field != null) {
                    return this.field.get(object);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return null;
        }
    }

    private static final class BeanGetter {
        Hashtable propGetters = new Hashtable();
        Class beanClass = null;

        private BeanGetter() {
        }

        public Object get(Object object, String string) {
            if (object == null || string == null) {
                return null;
            }
            PropertyGetter propertyGetter = (PropertyGetter)this.propGetters.get(string);
            if (propertyGetter == null) {
                boolean bl = false;
                Object object2 = null;
                Class<?>[] classArray = null;
                Method method = null;
                Object[] objectArray = null;
                Field field = null;
                String string2 = null;
                String string3 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                if (!bl) {
                    string2 = string;
                    try {
                        method = this.beanClass.getMethod(string2, classArray);
                        object2 = method.invoke(object, objectArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        method = null;
                    }
                }
                if (!bl) {
                    string2 = "get" + string3;
                    try {
                        method = this.beanClass.getMethod(string2, classArray);
                        object2 = method.invoke(object, objectArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        method = null;
                    }
                }
                if (!bl) {
                    string2 = "is" + string3;
                    try {
                        method = this.beanClass.getMethod(string2, classArray);
                        object2 = method.invoke(object, objectArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        method = null;
                    }
                }
                if (!bl) {
                    try {
                        field = this.beanClass.getField(string);
                        object2 = field.get(object);
                        bl = true;
                    }
                    catch (Exception exception) {
                        field = null;
                    }
                }
                if (!bl) {
                    string2 = "get";
                    try {
                        method = this.beanClass.getMethod(string2, String.class);
                        objectArray = new Object[]{string};
                        object2 = method.invoke(object, objectArray);
                        bl = true;
                    }
                    catch (Exception exception) {
                        method = null;
                    }
                }
                if (bl) {
                    propertyGetter = new PropertyGetter();
                    propertyGetter.field = field;
                    propertyGetter.method = method;
                    propertyGetter.params = objectArray;
                    this.propGetters.put(string, propertyGetter);
                }
                return object2;
            }
            return propertyGetter.get(object);
        }
    }
}

