/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.template.core;

import com.jinfonet.web.util.template.Templates;
import com.jinfonet.web.util.template.core.DynamicElement;
import com.jinfonet.web.util.template.core.StaticElement;
import com.jinfonet.web.util.template.core.VariableElement;
import com.jinfonet.web.util.template.core.ViewLogicImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Parser {
    static final Pattern VarTag = Pattern.compile("\\$\\{(\\w+[(\\[\\])-]*(\\.)?)*\\}");
    static final Pattern HBgnTag = Pattern.compile("<!--\\s*BEGIN\\s*[a-zA-Z_0-9-]*\\s*-->");
    static final Pattern HEndTag = Pattern.compile("<!--\\s*END\\s*[a-zA-Z_0-9-]*\\s*-->");
    static final Pattern SBgnTag = Pattern.compile("/\\*{3}\\s*BEGIN\\s*[a-zA-Z_0-9-]*\\s*\\*{2}/");
    static final Pattern SEndTag = Pattern.compile("/\\*{3}\\s*END\\s*[a-zA-Z_0-9-]*\\s*\\*{2}/");
    static final Pattern IgnTag = Pattern.compile("<!--\\s*IGNORED\\s*-->");
    static Pattern[] patterns = new Pattern[]{VarTag, HBgnTag, HEndTag, IgnTag, null, SBgnTag, SEndTag};

    public static Templates parse(BufferedReader bufferedReader) throws IOException, ParseException {
        DynamicElement dynamicElement = new DynamicElement(-2147483645, "__ROOT__");
        Stack<DynamicElement> stack = new Stack<DynamicElement>();
        DynamicElement dynamicElement2 = dynamicElement;
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        boolean bl = false;
        string = bufferedReader.readLine();
        stringBuilder.append(string).append("\n");
        StaticElement staticElement = null;
        while (stringBuilder.length() > 0) {
            Token token = Parser.I(stringBuilder);
            if (bl && token.type != 3) {
                token.type = -1;
            }
            switch (token.type) {
                case 4: {
                    String string2 = stringBuilder.substring(0, token.end);
                    if (string2.length() <= 0) break;
                    if (staticElement == null) {
                        staticElement = new StaticElement(string2);
                        break;
                    }
                    staticElement.append(string2);
                    break;
                }
                case 0: {
                    String string2 = stringBuilder.substring(0, token.start);
                    if (string2.length() > 0) {
                        if (staticElement == null) {
                            staticElement = new StaticElement(string2);
                        } else {
                            staticElement.append(string2);
                        }
                    }
                    if (staticElement != null) {
                        dynamicElement2.append(StaticElement.clone(staticElement));
                        staticElement = null;
                    }
                    string2 = stringBuilder.substring(token.start, token.end);
                    VariableElement variableElement = new VariableElement(Parser.HBgnTag(string2));
                    dynamicElement2.append(variableElement);
                    break;
                }
                case 1: {
                    String string2 = stringBuilder.substring(0, token.start);
                    if (string2.length() > 0) {
                        if (staticElement == null) {
                            staticElement = new StaticElement(string2);
                        } else {
                            staticElement.append(string2);
                        }
                    }
                    if (staticElement != null) {
                        dynamicElement2.append(StaticElement.clone(staticElement));
                        staticElement = null;
                    }
                    string2 = stringBuilder.substring(token.start, token.end);
                    DynamicElement dynamicElement3 = new DynamicElement(3, Parser.HEndTag(string2, "BEGIN"));
                    dynamicElement2.append(dynamicElement3);
                    stack.push(dynamicElement2);
                    dynamicElement2 = dynamicElement3;
                    break;
                }
                case 2: {
                    String string2 = stringBuilder.substring(0, token.start);
                    if (string2.length() > 0) {
                        if (staticElement == null) {
                            staticElement = new StaticElement(string2);
                        } else {
                            staticElement.append(string2);
                        }
                    }
                    if (staticElement != null) {
                        dynamicElement2.append(StaticElement.clone(staticElement));
                        staticElement = null;
                    }
                    string2 = stringBuilder.substring(token.start, token.end);
                    if (!dynamicElement2.getName().equals(Parser.HEndTag(string2, "END"))) {
                        throw new ParseException(dynamicElement2.getName(), -1);
                    }
                    dynamicElement2 = (DynamicElement)stack.pop();
                    break;
                }
                case 3: {
                    String string2;
                    if (!bl) {
                        string2 = stringBuilder.substring(0, token.start);
                        if (string2.length() > 0) {
                            if (staticElement == null) {
                                staticElement = new StaticElement(string2);
                            } else {
                                staticElement.append(string2);
                            }
                        }
                        if (staticElement != null) {
                            dynamicElement2.append(StaticElement.clone(staticElement));
                            staticElement = null;
                        }
                    }
                    bl = !bl;
                    break;
                }
            }
            stringBuilder.delete(0, token.end);
            string = bufferedReader.readLine();
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            if (stringBuilder.length() != 0) continue;
            break;
        }
        if (staticElement != null) {
            dynamicElement2.append(staticElement);
        }
        if (stack.size() > 0) {
            throw new ParseException(dynamicElement2.getName(), -1);
        }
        return dynamicElement;
    }

    private static String HBgnTag(String string) {
        String string2 = string.substring(2, string.length() - 1);
        return string2.trim();
    }

    private static String HEndTag(String string, String string2) {
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length(), string.length() - 3);
        return string3.trim();
    }

    private static Token I(CharSequence charSequence) {
        Token token = new Token(-1);
        int n = patterns.length;
        for (int i = 0; i < n; ++i) {
            Matcher matcher;
            Pattern pattern = patterns[i];
            if (pattern == null || !(matcher = pattern.matcher(charSequence)).find()) continue;
            Token token2 = new Token(i % 4);
            token2.start = matcher.start();
            token2.end = matcher.end();
            if (token2.start >= token.start) continue;
            token = token2;
        }
        if (token.type == -1) {
            token.type = 4;
            token.start = 0;
            token.end = charSequence.length();
        }
        return token;
    }

    public static ViewLogicImpl parse(Templates templates) {
        if (templates == null) {
            throw new NullPointerException();
        }
        ViewLogicImpl viewLogicImpl = new ViewLogicImpl(templates.getType(), templates.getName());
        Iterator iterator = ((DynamicElement)templates).iterator();
        while (iterator.hasNext()) {
            Templates templates2 = (Templates)iterator.next();
            int n = templates2.getType();
            switch (n) {
                case 1: {
                    viewLogicImpl.append(new ViewLogicImpl(n, templates2.getName()));
                    break;
                }
                case 3: {
                    viewLogicImpl.append(Parser.parse(templates2));
                    break;
                }
            }
        }
        return viewLogicImpl;
    }

    static class Token {
        int type = -1;
        int start = Integer.MAX_VALUE;
        int end;

        public Token(int n) {
            this.type = n;
        }
    }
}

