/*
 * Decompiled with CFR 0.152.
 */
package jet.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import jet.cache.CachedInputStream;
import jet.server.log.ServiceLogger;

public class CachedData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -254197553957826433L;
    private static final long SEDU = 1000L;
    protected final String key;
    protected byte[] value;
    protected Object valueObj;
    protected long memorySize;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    protected long hitCount = 0L;
    protected long userCount = 0L;
    private int timeToLive;
    private int timeToIdle;
    private boolean eternal;
    private boolean lifespanSet;

    public CachedData(String string, byte[] byArray) {
        this(string, byArray, false);
    }

    public CachedData(String string, byte[] byArray, boolean bl) {
        this.key = string;
        this.value = byArray;
        this.eternal = bl;
        this.creationTime = System.currentTimeMillis();
        this.valueObj = null;
        this.memorySize = byArray.length;
    }

    public CachedData(String string, Object object, long l) {
        this(string, object, l, false);
    }

    public CachedData(String string, Object object, long l, boolean bl) {
        this.key = string;
        this.valueObj = object;
        this.memorySize = l;
        this.eternal = bl;
        this.creationTime = System.currentTimeMillis();
        this.value = null;
    }

    public CachedData(CachedData cachedData) throws IOException {
        this.key = cachedData.key;
        this.value = cachedData.value;
        this.creationTime = cachedData.creationTime;
        this.eternal = cachedData.eternal;
        this.valueObj = cachedData.valueObj;
        this.memorySize = cachedData.memorySize;
    }

    public CachedData copy() {
        Object object = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException, 2);
        }
        return (CachedData)object;
    }

    public final CachedData clone() {
        CachedData cachedData = null;
        try {
            cachedData = new CachedData(this);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
        }
        cachedData.lastAccessTime = this.lastAccessTime;
        cachedData.nextToLastAccessTime = this.nextToLastAccessTime;
        cachedData.hitCount = this.hitCount;
        return cachedData;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof CachedData)) {
            return false;
        }
        CachedData cachedData = (CachedData)object;
        if (this.key == null || cachedData.getObjectKey() == null) {
            return false;
        }
        return this.key.equals(cachedData.getObjectKey());
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public long getExpirationTime() {
        if (!this.lifespanSet || this.eternal || this.timeToLive == 0 && this.timeToIdle == 0) {
            return Long.MAX_VALUE;
        }
        long l = 0L;
        long l2 = this.creationTime + (long)this.timeToLive * 1000L;
        long l3 = Math.max(this.creationTime, this.nextToLastAccessTime);
        long l4 = l3 + (long)this.timeToIdle * 1000L;
        l = this.timeToLive != 0 && (this.timeToIdle == 0 || this.lastAccessTime == 0L) ? l2 : (this.timeToLive == 0 ? l4 : Math.min(l2, l4));
        return l;
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final long getUserCount() {
        return this.userCount;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final long getMemorySize() {
        if (this.value != null) {
            return this.value.length;
        }
        return this.memorySize;
    }

    public final long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public final String getObjectKey() {
        return this.key;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public int getTimeToIdle() {
        return this.timeToIdle;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isExpired() {
        long l;
        if (!this.lifespanSet) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        return l2 > (l = this.getExpirationTime());
    }

    public boolean isLifespanSet() {
        return this.lifespanSet;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public void setEternal(boolean bl) {
        this.eternal = bl;
        this.lifespanSet = true;
    }

    public void setTimeToIdle(int n) {
        this.timeToIdle = n;
        this.lifespanSet = true;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
        this.lifespanSet = true;
    }

    public ByteArrayInputStream toInputStream() {
        return new CachedInputStream(this);
    }

    public Object getValueObj() {
        return this.valueObj;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ key=").append(this.key).append(", value=").append(Arrays.toString(this.value)).append(", hitCount=").append(this.hitCount).append(", CreationTime=").append(this.getCreationTime()).append(", LastAccessTime=").append(this.getLastAccessTime()).append(", valueObj=").append(this.valueObj.toString()).append(", memorySzie=").append(this.memorySize).append(" ]");
        return stringBuffer.toString();
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }
}

