/*
 * Decompiled with CFR 0.152.
 */
package jet.connect.jdbms;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.connect.DbBufSQLException;
import jet.connect.DbBuffer;
import jet.connect.DbPage;
import jet.connect.DbRecordModel;
import jet.connect.Record;
import jet.connect.jdbms.JDbRecordModel;
import jet.util.RAFile;
import jet.util.RandomInputable;

public class JDbBuffer
extends DbBuffer {
    public JDbBuffer(JDbRecordModel jDbRecordModel, File file) throws IOException {
        this(jDbRecordModel, file, new Hashtable(2));
    }

    public JDbBuffer(JDbRecordModel jDbRecordModel, File file, Hashtable hashtable) throws IOException {
        super(true, (DbRecordModel)jDbRecordModel, hashtable);
        this.file = file;
        this.bufFile = new RAFile(file, "rw");
        this.lastPage = new DbPage((DbBuffer)this, 0);
    }

    public JDbBuffer(JDbRecordModel jDbRecordModel, File file, int n, int n2) throws IOException {
        this(jDbRecordModel, file, new Hashtable(2), n, n2);
    }

    public JDbBuffer(JDbRecordModel jDbRecordModel, File file, Hashtable hashtable, int n, int n2) throws IOException {
        super(true, (DbRecordModel)jDbRecordModel, hashtable, 0, n, n2);
        this.file = file;
        this.bufFile = new RAFile(file, "rw");
        this.lastPage = new DbPage((DbBuffer)this, 0);
    }

    void setBeging(long l) {
        this.offsetBegine = l;
    }

    public long getBeging() {
        return this.offsetBegine;
    }

    void setRecordCount(int n) {
        this.currentEnd = n;
    }

    public void readFirst() throws IOException {
        this.lastPage.readFromFile((RandomInputable)this.bufFile);
        this.currentEnd = ((JDbRecordModel)this.recordModel).getRecordCount();
        this.finish();
        this.setNeedWaitFetch(false);
    }

    public void close() throws SQLException {
        try {
            this.bufFile.close();
            Enumeration enumeration = this.descToBlobFiles.elements();
            while (enumeration.hasMoreElements()) {
                RAFile rAFile = (RAFile)enumeration.nextElement();
                rAFile.close();
            }
        }
        catch (IOException iOException) {
            throw new DbBufSQLException(iOException.getMessage());
        }
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllToFile() throws IOException {
        RAFile rAFile = this.bufFile;
        synchronized (rAFile) {
            long l = this.bufFile.getPosition();
            this.bufFile.seek(l);
            super.refreshAllToFile();
        }
    }

    public synchronized void addRecord(Record record) {
        try {
            int n = this.getPageNumberByRowNumber(this.currentEnd == 0 ? 0 : this.currentEnd - 1);
            if (this.lastPage.getPageNumber() != n) {
                this.lastPage = this.getPageOfTheRow(this.currentEnd == 0 ? 0 : this.currentEnd - 1);
            }
            super.addRecord(record);
        }
        catch (IOException iOException) {
            JDebug.WARNING((Throwable)iOException);
        }
    }
}

