/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.jacl;

import guitools.toolkit.JDebug;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEnumerator;
import jet.cs.jacl.JOwnerImpl;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPermissionImpl;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicy;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;

public class JAclImpl
implements JAcl {
    private Hashtable EXECUTE;
    private Hashtable GRANT;
    private Hashtable READ;
    private Hashtable SCHEDULE;
    private Hashtable SEDU;
    private Hashtable WARNING;
    private String add;
    private JOwnerImpl addElement;
    private boolean addOwner;
    private SecurityData append;
    private boolean checkPermission = false;

    public JAclImpl(Principal principal, String string, SecurityData securityData) {
        this.addElement = new JOwnerImpl(principal);
        this.addOwner = true;
        this.EXECUTE();
        try {
            this.setName(principal, string);
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
        }
        this.append = securityData;
    }

    public JAclImpl(String string, SecurityData securityData) {
        this.addOwner = false;
        this.EXECUTE();
        this.add = string;
        this.append = securityData;
    }

    private void EXECUTE() {
        this.EXECUTE = new Hashtable(23);
        this.GRANT = new Hashtable(23);
        this.READ = new Hashtable(23);
        this.SCHEDULE = new Hashtable(23);
        this.SEDU = new Hashtable(23);
        this.WARNING = new Hashtable(23);
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        this.add = string;
    }

    public String getName() {
        return this.add;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        String string;
        if (aclEntry == null) {
            return false;
        }
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.WARNING(aclEntry);
        if (hashtable.get(string = (principal2 = aclEntry.getPrincipal()).getName()) != null) {
            return false;
        }
        hashtable.put(string, aclEntry);
        return true;
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (aclEntry == null) {
            return false;
        }
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.WARNING(aclEntry);
        Object v = hashtable.remove((principal2 = aclEntry.getPrincipal()).getName());
        return v != null;
    }

    public synchronized Enumeration getPermissions(Principal principal) {
        int n;
        if (principal == null) {
            return null;
        }
        if (!(principal instanceof BaseGroup || principal instanceof BaseUser || principal instanceof BaseRole)) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.READ(principal, vector, vector2);
        this.GRANT(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.SCHEDULE(principal, vector3, vector4);
        for (n = 0; n < vector4.size(); ++n) {
            Object e = vector4.elementAt(n);
            if (!vector.contains(e)) continue;
            vector.removeElement(e);
        }
        for (n = 0; n < vector.size(); ++n) {
            vector3.addElement(vector.elementAt(n));
        }
        return vector3.elements();
    }

    private void GRANT(Principal principal, Vector vector, Vector vector2) {
        BaseRole baseRole;
        int n;
        Object object;
        Vector vector3 = new Vector();
        if (principal instanceof BaseRole) {
            object = this.append.getRole(principal.getName());
            if (object == null) {
                return;
            }
            vector3 = object.getParentRoleNames();
            if (vector3 == null || vector3.size() == 0) {
                return;
            }
        } else if (principal instanceof BaseUser) {
            object = this.append.getUser(principal.getName());
            if (object == null) {
                return;
            }
            vector3 = object.getParentRoleNames();
            if (vector3 == null || vector3.size() == 0) {
                return;
            }
        } else if (principal instanceof BaseGroup) {
            object = this.append.getGroup(principal.getName());
            if (object == null) {
                return;
            }
            vector3 = object.getRoleNames();
            if (vector3 == null || vector3.size() == 0) {
                return;
            }
        }
        object = new Vector();
        Vector vector4 = new Vector();
        for (n = 0; n < vector3.size(); ++n) {
            Object e;
            int n2;
            baseRole = this.append.getRole((String)vector3.get(n));
            this.GRANT(baseRole, vector, vector2);
            this.SCHEDULE(baseRole, (Vector)object, vector4);
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                e = ((Vector)object).elementAt(n2);
                if (vector.contains(e)) continue;
                vector.addElement(e);
            }
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                e = vector4.elementAt(n2);
                if (vector2.contains(e)) continue;
                vector2.addElement(e);
            }
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            baseRole = vector.elementAt(n);
            if (!vector2.contains(baseRole)) continue;
            vector.removeElement(baseRole);
            vector2.removeElement(baseRole);
        }
    }

    private void READ(Principal principal, Vector vector, Vector vector2) {
        String string;
        int n;
        Object object;
        Vector vector3 = new Vector();
        if (principal instanceof BaseRole) {
            return;
        }
        if (principal instanceof BaseUser) {
            object = this.append.getUser(principal.getName());
            if (object == null) {
                return;
            }
            vector3 = object.getGroupNames();
            if (vector3 == null || vector3.size() == 0) {
                return;
            }
        } else if (principal instanceof BaseGroup) {
            object = this.append.getGroup(principal.getName());
            if (object == null) {
                return;
            }
            vector3 = object.getParentGroupNames();
            if (vector3 == null || vector3.size() == 0) {
                return;
            }
        }
        object = new Vector();
        Vector vector4 = new Vector();
        for (n = 0; n < vector3.size(); ++n) {
            Object e;
            int n2;
            string = (String)vector3.get(n);
            BaseGroup baseGroup = this.append.getGroup(string);
            if (baseGroup == null) continue;
            this.READ(baseGroup, vector, vector2);
            this.GRANT(baseGroup, vector, vector2);
            this.SCHEDULE(baseGroup, (Vector)object, vector4);
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                e = ((Vector)object).elementAt(n2);
                if (vector.contains(e)) continue;
                vector.addElement(e);
            }
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                e = vector4.elementAt(n2);
                if (vector2.contains(e)) continue;
                vector2.addElement(e);
            }
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            string = vector.elementAt(n);
            if (!vector2.contains(string)) continue;
            vector.removeElement(string);
            vector2.removeElement(string);
        }
    }

    private void SCHEDULE(Principal principal, Vector vector, Vector vector2) {
        Object object;
        vector.removeAllElements();
        vector2.removeAllElements();
        String string = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (principal instanceof BaseUser && !this.checkPermission) {
            string = principal.getName();
            object = this.append.getUser(string);
            if (object == null) {
                return;
            }
            hashtable = this.EXECUTE;
            hashtable2 = this.SCHEDULE;
        } else if (principal instanceof BaseRole) {
            string = principal.getName();
            object = this.append.getRole(string);
            if (object == null) {
                return;
            }
            hashtable = this.GRANT;
            hashtable2 = this.SEDU;
        } else if (!this.checkPermission) {
            string = principal.getName();
            object = this.append.getGroup(string);
            if (object == null) {
                return;
            }
            hashtable = this.READ;
            hashtable2 = this.WARNING;
        }
        if (hashtable != null) {
            Object object2;
            object = (JAclEntry)hashtable.get(string);
            if (object != null) {
                object2 = object.permissions();
                while (object2.hasMoreElements()) {
                    vector.addElement(object2.nextElement());
                }
            }
            if ((object2 = (JAclEntry)hashtable2.get(string)) != null) {
                Enumeration enumeration = object2.permissions();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
            }
        }
    }

    public Enumeration entries() {
        return new JAclEnumerator(this, this.EXECUTE, this.GRANT, this.READ, this.SCHEDULE, this.SEDU, this.WARNING);
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        if (principal == null || permission == null) {
            return false;
        }
        Enumeration enumeration = this.getPermissions(principal);
        while (enumeration.hasMoreElements()) {
            Permission permission2 = (Permission)enumeration.nextElement();
            if (permission2.equals(JPermissionImpl.GRANT)) {
                return true;
            }
            if ((permission2.equals(JPermissionImpl.EXECUTE) || permission2.equals(JPermissionImpl.SCHEDULE)) && permission.equals(JPermissionImpl.READ)) {
                return true;
            }
            if (!permission.equals(permission2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRoleBased(boolean bl) {
        this.checkPermission = bl;
    }

    @Override
    public JPermission getPolicyPermission(Principal principal, String string, int n) throws JPermissionLinkException, JPolicyLinkException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (principal == null || string == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.READ(principal, vector, vector2);
        this.GRANT(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.SCHEDULE(principal, vector3, vector4);
        for (int i = 0; i < vector4.size(); ++i) {
            object5 = vector4.elementAt(i);
            if (!vector.contains(object5)) continue;
            vector.removeElement(object5);
        }
        Enumeration enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (JPermissionImpl)enumeration.nextElement();
            ((JPermissionImpl)object5).setPolicyIndividual(true);
        }
        for (int i = 0; i < vector.size(); ++i) {
            vector3.addElement(vector.elementAt(i));
        }
        Enumeration enumeration2 = vector3.elements();
        if (enumeration2 == null || !enumeration2.hasMoreElements()) {
            return null;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<Object, Vector> hashtable2 = new Hashtable<Object, Vector>();
        while (enumeration2.hasMoreElements()) {
            Vector vector5;
            object4 = enumeration2.nextElement();
            if (!(object4 instanceof JPermission)) continue;
            object3 = (JPermission)object4;
            int n2 = object3.getType();
            object2 = object3.getName();
            object = (String)object2 + n2;
            if (!hashtable.containsKey(object)) {
                hashtable.put(object, object3);
            }
            if (n == -1) continue;
            if (!hashtable2.containsKey(object)) {
                vector5 = new Vector();
                vector5.add(object3.getPolicy());
                hashtable2.put(object, vector5);
                continue;
            }
            vector5 = (Vector)hashtable2.get(object);
            vector5.add(object3.getPolicy());
        }
        object4 = hashtable2.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            Vector vector6 = (Vector)hashtable2.get(object3);
            object2 = null;
            if (!vector6.isEmpty()) {
                while (object2 == null && vector6.size() >= 1) {
                    object2 = (JPolicy)vector6.get(0);
                    vector6.remove(0);
                }
                object = vector6.elements();
                if (object2 != null && object.hasMoreElements()) {
                    object2 = object2.unionJPolicies((Enumeration)object);
                }
            }
            object = (JPermission)hashtable.get(object3);
            object.setPolicy((JPolicy)object2);
        }
        object3 = string + n;
        Object v = hashtable.get(object3);
        if (v != null && v instanceof JPermission) {
            return (JPermission)v;
        }
        return null;
    }

    @Override
    public JAclEntry getJAclEntry(Principal principal, boolean bl) {
        String string = principal.getName();
        if (principal instanceof BaseUser) {
            if (bl) {
                return this.SEDU(string, this.EXECUTE);
            }
            return this.SEDU(string, this.SCHEDULE);
        }
        if (principal instanceof BaseRole) {
            if (bl) {
                return this.SEDU(string, this.GRANT);
            }
            return this.SEDU(string, this.SEDU);
        }
        if (principal instanceof BaseGroup) {
            if (bl) {
                return this.SEDU(string, this.READ);
            }
            return this.SEDU(string, this.WARNING);
        }
        return null;
    }

    private JAclEntry SEDU(String string, Hashtable hashtable) {
        return (JAclEntry)hashtable.get(string);
    }

    @Override
    public void removeJAclEntry(Principal principal, boolean bl) {
        String string = principal.getName();
        if (principal instanceof BaseUser) {
            if (bl) {
                this.EXECUTE.remove(string);
            } else {
                this.SCHEDULE.remove(string);
            }
        } else if (principal instanceof BaseRole) {
            if (bl) {
                this.GRANT.remove(string);
            } else {
                this.SEDU.remove(string);
            }
        } else if (principal instanceof BaseGroup) {
            if (bl) {
                this.READ.remove(string);
            } else {
                this.WARNING.remove(string);
            }
        }
    }

    @Override
    public void removeJAclEntry(String string, int n) {
        if (n == 1) {
            this.EXECUTE.remove(string);
            this.SCHEDULE.remove(string);
        } else if (n == 2) {
            this.GRANT.remove(string);
            this.SEDU.remove(string);
        } else if (n == 3) {
            this.READ.remove(string);
            this.WARNING.remove(string);
        }
    }

    public void removeJAclEntry(int n) {
        if (n == 1) {
            this.EXECUTE.clear();
            this.SCHEDULE.clear();
        } else if (n == 2) {
            this.GRANT.clear();
            this.SEDU.clear();
        } else if (n == 3) {
            this.READ.clear();
            this.WARNING.clear();
        }
    }

    @Override
    public JPermission getPolicyPermission(Principal principal, SecurityData securityData, String string, int n) throws JPermissionLinkException, JPolicyLinkException {
        if (securityData != null) {
            this.append = securityData;
        }
        return this.getPolicyPermission(principal, string, n);
    }

    @Override
    public boolean checkPermission(Principal principal, SecurityData securityData, JPermission jPermission) {
        if (securityData != null) {
            this.append = securityData;
        }
        return this.checkPermission(principal, jPermission);
    }

    private Hashtable WARNING(AclEntry aclEntry) {
        Principal principal = aclEntry.getPrincipal();
        Hashtable hashtable = principal instanceof BaseRole ? (aclEntry.isNegative() ? this.SEDU : this.GRANT) : (principal instanceof BaseUser ? (aclEntry.isNegative() ? this.SCHEDULE : this.EXECUTE) : (aclEntry.isNegative() ? this.WARNING : this.READ));
        return hashtable;
    }

    public void removeAllEntries() {
        this.EXECUTE.clear();
        this.GRANT.clear();
        this.READ.clear();
        this.SCHEDULE.clear();
        this.SEDU.clear();
        this.WARNING.clear();
    }

    public boolean isOwner(Principal principal) {
        return this.addElement.isOwner(principal);
    }

    public boolean addOwner(Principal principal, Principal principal2) throws NotOwnerException {
        return this.addElement.addOwner(principal, principal2);
    }

    public boolean deleteOwner(Principal principal, Principal principal2) throws NotOwnerException, LastOwnerException {
        return this.addElement.deleteOwner(principal, principal2);
    }
}

