/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.Properties;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataEngineOption;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.JEnvironmentProperties;
import jet.dataengine8.DataServiceEnvironmentProperties;
import jet.dataengine8.core.DataEngineImpl;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.impl.CatalogContainer;
import jet.dataservice.impl.DSTimer;
import jet.dataservice.impl.DataServiceImpl;
import jet.dataservice.impl.QueryFactory;
import jet.dataservice.impl.QueryKeyManager;
import jet.server.service.ManagedService;
import jet.server.service.ServiceEnv;
import jet.server.service.ServiceSummary;

public class ManagedDataServiceImpl
extends DataServiceImpl
implements ManagedService {
    @Override
    public String getType() {
        return "jet.dataservice.api.JDataService";
    }

    @Override
    public ServiceSummary getSummary() {
        return null;
    }

    @Override
    public void init(ServiceEnv serviceEnv) {
        block9: {
            this.cc = new CatalogContainer();
            this.qkm = new QueryKeyManager();
            DataEngineOption dataEngineOption = new DataEngineOption();
            Properties properties = serviceEnv.getConfig();
            try {
                JdbcDriversConfig jdbcDriversConfig = (JdbcDriversConfig)properties.get("JdbcDriversConfig");
                dataEngineOption.setJdbcDriversConfig(jdbcDriversConfig);
                boolean bl = false;
                if (properties.getProperty("SingleTread") != null) {
                    bl = new Boolean(properties.getProperty("SingleTread"));
                    dataEngineOption.setSingleThread(bl);
                }
                boolean bl2 = false;
                if (properties.getProperty("CacheZip") != null) {
                    bl2 = new Boolean(properties.getProperty("CacheZip"));
                    dataEngineOption.setCacheZip(bl2);
                }
                if (serviceEnv.getTempPath() == null || serviceEnv.getTempPath().trim().length() <= 0) {
                    throw new DSException(4171);
                }
                EnvironmentPropertiesFactory.setEnviromentPropertiesClass((JEnvironmentProperties)new DataServiceEnvironmentProperties(serviceEnv.getTempPath()));
                String string = properties.getProperty("SortMemorySize");
                if (string != null && string.trim().length() > 0) {
                    this.sortMemorySize = new Integer(string);
                }
                this.crdm = serviceEnv.getRptServer().getCRDManager();
                if (properties.getProperty("TimeOut") != null) {
                    this.timeout = new Integer(properties.getProperty("TimeOut"));
                }
                SecurityData securityData = (SecurityData)properties.get("SecurityData");
                ResourceStore resourceStore = (ResourceStore)properties.get("ResourceStore");
                int n = 5;
                if (properties.getProperty("ThreadPriority") != null) {
                    n = new Integer(properties.getProperty("ThreadPriority"));
                }
                this.dsc = new DataServiceConfig(jdbcDriversConfig, serviceEnv.getTempPath(), serviceEnv.getRptServer().getInformationBusManager(), resourceStore);
                this.dsc.setSingleThread(bl);
                this.dsc.setCacheZip(bl2);
                this.dsc.setSortMem(this.sortMemorySize);
                this.dsc.setTimeOut(this.timeout);
                this.dsc.setSecurityData(securityData);
                this.dsc.setThreadPriority(n);
                this.dsc.setCRDManager(this.crdm);
                this.del = new DataEngineImpl(dataEngineOption, this.dsc);
                this.qf = new QueryFactory(this.cc, this.qkm, this.del.getQueryManager());
                this.del.setThreadPriority(n);
                this.dst = new DSTimer();
                if (JRLog.isTrace((int)5)) {
                    JRLog.trace((int)5, (Object)("DataService init JdbcDriversConfig:" + dataEngineOption.getjdbcDriversConfig() + " SingleThread:" + dataEngineOption.isSingleThread() + " CacheZip:" + dataEngineOption.isCacheZip() + " ThreadPriority:" + properties.getProperty("ThreadPriority") + " TemporaryPath:" + serviceEnv.getTempPath() + " SortMemorySize:" + this.sortMemorySize + " TimeOut=" + this.timeout + " CRDManager=" + this.crdm + " this=" + this + " SecurityData=" + securityData + " ResourceStore=" + resourceStore));
                }
            }
            catch (Throwable throwable) {
                if (!JRLog.isError((int)1)) break block9;
                JRLog.error((int)1, (Throwable)throwable);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        block2: {
            try {
                this.clear();
            }
            catch (Throwable throwable) {
                if (!JRLog.isError((int)2)) break block2;
                JRLog.error((int)2, (Throwable)throwable);
            }
        }
    }
}

