/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.crd;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDRunDetail;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;

public class CRDInfo
implements Serializable {
    private static final long serialVersionUID = -4736537361985650015L;
    public static final short STATUS_PENDING = 1;
    public static final short STATUS_BUILDING = 2;
    public static final short STATUS_UPDATING = 3;
    public static final short STATUS_COMPLETED = 4;
    public static final short STATUS_DISABLED = 5;
    protected short status = 1;
    public static final int QUERY_TYPE_QUERY = 1;
    public static final int QUERY_TYPE_QUEYR = 1;
    public static final int QUERY_TYPE_STORED_PROCEDURE = 2;
    public static final int QUERY_TYPE_IMPORTED_SQL = 3;
    public static final int QUERY_TYPE_USER_DEFINED = 4;
    public static final int QUERY_TYPE_HIERARCHICAL = 5;
    public static final int QUERY_TYPE_PARAMETER = 6;
    public static final int CACHE_TYPE_DETAIL = 1;
    public static final int CACHE_TYPE_BV = 2;
    public static final int CACHE_TYPE_BVANDDETAIL = 3;
    protected CRDInfoKey crdKey;
    protected String catalogName;
    private Date lastModified;
    private String loginUser;
    private String userName;
    private String password;
    private Map<String, String> userNames;
    private Map<String, String> passwords;
    private String paramFile;
    private boolean lazy;
    private String taskId;
    protected Map<String, String[]> paramValues;
    protected Map<String, String[]> runtimeParamValues;
    protected int cacheType;
    protected Vector<CRDRunDetail> runDetails = null;
    private long createdTime;

    public CRDInfo(String string, String string2, int n, String string3) {
        this.crdKey = new CRDInfoKey(string, string2, n, string3);
        this.cacheType = 1;
    }

    protected CRDInfo() {
    }

    public CRDInfo(String string, String string2, int n, String string3, int n2) {
        this.crdKey = new CRDInfoKey(string, string2, n, string3);
        this.cacheType = n2;
    }

    protected CRDInfo(CRDInfo cRDInfo) {
        this.restoreInfo(cRDInfo);
    }

    protected Map<String, String[]> copyMap(Map<String, String[]> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (String string : map.keySet()) {
            String[] stringArray = map.get(string);
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            hashMap.put(string, stringArray2);
        }
        return hashMap;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long l) {
        this.createdTime = l;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public Map<String, String> getUserNames() {
        return this.userNames;
    }

    public void setUserNames(Map<String, String> map) {
        this.userNames = map;
    }

    public Map<String, String> getPasswords() {
        return this.passwords;
    }

    public void setPasswords(Map<String, String> map) {
        this.passwords = map;
    }

    public String getParamFile() {
        return this.paramFile;
    }

    public void setParamFile(String string) {
        this.paramFile = string;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public String getCatalogPath() {
        return this.crdKey.getCatalogPath();
    }

    public String getDataSource() {
        return this.crdKey.getDataSource();
    }

    public String getQueryName() {
        return this.crdKey.getQueryName();
    }

    public int getQueryType() {
        return this.crdKey.getQueryType();
    }

    public void setCatalogPath(String string) {
        this.crdKey.setCatalogPath(string);
    }

    public void setDataSource(String string) {
        this.crdKey.setDataSource(string);
    }

    public void setQueryName(String string) {
        this.crdKey.setQueryName(string);
    }

    public void setQueryType(int n) {
        this.crdKey.setQueryType(n);
    }

    public Map<String, String[]> getParamValues() {
        return this.paramValues;
    }

    public Map<String, String[]> getRuntimeParamValues() {
        return this.runtimeParamValues;
    }

    public boolean equals(Object object) {
        if (object instanceof CRDInfo) {
            CRDInfo cRDInfo = (CRDInfo)object;
            if (this.crdKey != null && cRDInfo.crdKey != null) {
                return this.crdKey.equals(cRDInfo.crdKey);
            }
        }
        return super.equals(object);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String string) {
        this.taskId = string;
    }

    public CRDInfoKey getCRDKey() {
        return this.crdKey;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int n) {
        this.cacheType = n;
    }

    public int getRunTimes() {
        return this.runDetails == null ? 0 : this.runDetails.size();
    }

    public Vector<CRDRunDetail> getRunDetails() {
        return this.runDetails;
    }

    public String toString() {
        return "{" + this.toStr() + "}";
    }

    protected String toStr() {
        StringBuffer stringBuffer = new StringBuffer().append(this.crdKey.toStr());
        stringBuffer.append(", createdTime:").append(new Date(this.createdTime));
        stringBuffer.append(", lastModified:").append(this.lastModified);
        stringBuffer.append(", status:").append(this.status);
        stringBuffer.append(", runTimes:").append(this.getRunTimes());
        if (this.lazy) {
            stringBuffer.append(", lazy:").append(this.lazy);
        }
        if (!ServerUtil.isEmpty(this.loginUser)) {
            stringBuffer.append(", loginUser:").append(this.loginUser);
        }
        if (this.userNames != null && !this.userNames.isEmpty()) {
            stringBuffer.append(", userName:").append(this.userNames);
        }
        if (!ServerUtil.isEmpty(this.taskId)) {
            stringBuffer.append(", taskId:").append(this.taskId);
        }
        if (!ServerUtil.isEmpty(this.paramFile)) {
            stringBuffer.append(", paramFile:").append(this.paramFile);
        }
        if (this.paramValues != null && this.paramValues.size() > 0) {
            stringBuffer.append(", paramValues:").append(StringUtil.toString(this.paramValues));
        }
        if (this.runtimeParamValues != null && this.runtimeParamValues.size() > 0) {
            stringBuffer.append(", runtimeParamValues:").append(StringUtil.toString(this.runtimeParamValues));
        }
        return stringBuffer.toString();
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String string) {
        this.loginUser = string;
    }

    public short getStatus() {
        return this.status;
    }

    protected void restoreInfo(CRDInfo cRDInfo) {
        this.crdKey = cRDInfo.crdKey;
        this.catalogName = cRDInfo.catalogName;
        this.lastModified = cRDInfo.lastModified;
        this.loginUser = cRDInfo.loginUser;
        this.userName = cRDInfo.userName;
        this.password = cRDInfo.password;
        this.userNames = cRDInfo.userNames;
        this.passwords = cRDInfo.passwords;
        this.paramFile = cRDInfo.paramFile;
        this.lazy = cRDInfo.lazy;
        this.taskId = cRDInfo.taskId;
        this.paramValues = this.copyMap(cRDInfo.paramValues);
        this.runtimeParamValues = this.copyMap(cRDInfo.runtimeParamValues);
        this.cacheType = cRDInfo.cacheType;
        this.createdTime = cRDInfo.createdTime;
        this.status = cRDInfo.status;
        this.runDetails = cRDInfo.runDetails;
    }
}

