/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.Env;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.ServerEnvBuilder;
import jet.server.api.RemoteFileService;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.admin.cfg.ConfigurationCluster;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoRemoteServerException;
import jet.server.api.http.BaseHttpUtil;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.TooManyTimesException;
import jet.server.api.rmi.RemoteDispatcherFactory;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.intf.jrs.RemoteNLSManager;
import jet.server.jrc.http.HttpRptServerDispatcher;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrrmisvr.JRNLSManager;
import jet.server.jrserver.http.JRHttpRptServer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.util.ServerUtil;
import jet.server.util.UploadFileUtil;
import jet.server.util.WebSecurityUtil;
import jet.util.Base64;
import jet.util.HashVector;
import server.servlet.http.HttpResponse;

public class HttpUtil
extends BaseHttpUtil {
    private static boolean LINE = false;
    private static HttpRptServer SEDU = null;
    private static boolean activeCount = false;
    private static String add = null;
    private static String append = null;
    private static String bindRptServer = null;
    private static String build = null;
    private static boolean canRead = true;
    private static String checkAdminLoginEx = null;
    private static String checkLoginEx = null;
    private static String close = null;
    private static String closeAll = null;
    private static String connect = null;
    private static String copyFilesByPrefix = null;
    private static boolean createDispatcher = false;
    private static boolean decodeEsc = false;
    private static boolean destroy = false;
    private static boolean disconnect = false;
    private static String dispatch = "JReport.log";
    private static int encode = 0;
    private static int encodeUrl = 2000;
    private static HashVector endsWith = new HashVector();
    private static HashVector entries = new HashVector();
    private static String equals = null;
    private static String equalsIgnoreCase = null;
    private static RemoteFileService exists = null;
    private static RemoteNLSManager finish = null;
    private static final Object flush = new Object();
    private static List forName = null;
    private static HttpRptServerDispatcher freeMemory = null;
    private static String get = null;
    private static final String[] getAbsolutePath = new String[]{"jrs.submit_schedule_form", "jrs.try_vw", "jrs.web_vw", "jrs.submit_schedule", "jrs.submit_schedule_form_old", "jrs.run_vw", "jrs.run_task"};

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initEnv(Properties properties) {
        String string;
        if (activeCount && disconnect) {
            return;
        }
        String string2 = "reporthome";
        String string3 = "install.root";
        String string4 = "jreport.context";
        Properties properties2 = System.getProperties();
        Properties properties3 = ServerEnvBuilder.servEnv;
        if (destroy) {
            properties2.put(string4, "");
            properties2.remove(string4);
            HttpUtil.getHttpRptServer();
            return;
        }
        decodeEsc = true;
        try {
            Object object;
            block61: {
                if (properties == null) {
                    throw new IllegalArgumentException(" props = null ");
                }
                ServerEnvBuilder.prepare(properties);
                ServerEnvBuilder.build(properties);
                ServerEnvBuilder.mergeServerProperties(properties);
                activeCount = ServerEnvBuilder.isStandalone();
                isRemoteServer = ServerEnvBuilder.isRMIntegrate();
                if (isRemoteServer) {
                    equals = properties2.getProperty("jrs.remote.host");
                    equalsIgnoreCase = properties2.getProperty("jrs.remote.rmiport");
                }
                if ((string = properties3.getProperty(string2)) == null) {
                    string = System.getProperty(string3);
                }
                if (string == null) {
                    string = Env.getReportHome();
                }
                if (string != null) {
                    ServerEnvBuilder.setReporthome(string);
                    checkAdminLoginEx = string;
                    if (!checkAdminLoginEx.endsWith(File.separator)) {
                        checkAdminLoginEx = checkAdminLoginEx + File.separator;
                    }
                }
                String string5 = "temp_dir";
                String string6 = "jrs.dir.temp";
                checkLoginEx = properties.getProperty(string5);
                if (checkLoginEx != null && checkLoginEx.trim().length() > 0) {
                    System.getProperties().put(string6, checkLoginEx.trim());
                } else {
                    checkLoginEx = properties.getProperty(string6);
                }
                String string7 = "history_dir";
                String string8 = "jrs.dir.history";
                close = properties.getProperty(string7);
                if (close != null && close.trim().length() > 0) {
                    System.getProperties().put(string8, close.trim());
                } else {
                    close = properties.getProperty(string8);
                }
                if (!isRemoteServer) {
                    object = "jrs.server_class";
                    build = properties.getProperty((String)object);
                    if (ServiceLogger.isLoggable(4, 6)) {
                        ServiceLogger.logDebug(6670018, build, 6);
                    }
                    SEDU = build == null || build.trim().length() == 0 ? new JRHttpRptServer() : (HttpRptServer)Class.forName(build.trim()).newInstance();
                    SEDU.init(properties);
                    freeMemory = HttpRptServerDispatcher.createDispatcher(SEDU);
                } else {
                    SEDU = RemoteReportServerToolkit.getRemoteWrappedRptServer(equals, equalsIgnoreCase);
                    exists = RemoteReportServerToolkit.getRemoteFileService(equals, equalsIgnoreCase);
                    ServerEnv.initEmptyServerProps();
                    try {
                        finish = (RemoteNLSManager)RemoteObjectFactory.getRemoteObject(equals, Integer.parseInt(equalsIgnoreCase), "nlsManager");
                        UserDataToolkit.setNLSManager(new JRNLSManager(finish));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (SEDU == null) {
                        return;
                    }
                    freeMemory = HttpRptServerDispatcher.createDispatcher(SEDU);
                }
                if (isRemoteServer) {
                    add = String.valueOf(SEDU.getServerEnv().getWebPageOptions().getActiveRealmScheme());
                } else {
                    boolean bl = ServerEnv.isClusterAdminServer();
                    if (bl) {
                        add = properties.getProperty("auth_scheme");
                        if (add != null) {
                            if ((add = add.trim()).equalsIgnoreCase("Digest")) {
                                add = "Digest";
                            } else if (add.equalsIgnoreCase("Basic")) {
                                add = "Basic";
                            } else {
                                add = "Basic";
                                ServiceLogger.logError(2670019, new Object[]{add, "Basic"}, 2);
                            }
                        } else {
                            String string9 = ServerEnv.getActiveRealm();
                            Realm realm = Realm.get(string9);
                            if (realm != null) {
                                add = realm.getScheme() == 0 ? "Basic" : "Digest";
                            } else {
                                add = "Basic";
                                ServiceLogger.logError(2670020, "Basic", 2);
                            }
                        }
                    } else {
                        String string10;
                        ClusterService clusterService = SEDU.getClusterService();
                        Member member = clusterService.getAdminMember();
                        String string11 = member.getHost();
                        MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string11, CSUtil.parseInt(string10 = member.getPort()), "MemberMonitor");
                        add = (String)memberMonitor.getCommonProps().get("jrs.auth_scheme");
                        if (add == null || add.length() == 0) {
                            add = "Basic";
                            ServiceLogger.logError(2670019, new Object[]{add, "Basic"}, 2);
                        }
                    }
                }
                bindRptServer = properties.getProperty("default_doc");
                if (bindRptServer != null) {
                    if (ServiceLogger.isLoggable(4, 6)) {
                        ServiceLogger.logDebug(0x65C6C5, bindRptServer, 6);
                    }
                    if (bindRptServer.trim().length() != 0) {
                        try {
                            object = new File(bindRptServer);
                            if (!((File)object).exists() || ((File)object).isDirectory()) {
                                ServiceLogger.logDebug(4670022, bindRptServer, 4);
                                bindRptServer = null;
                                break block61;
                            }
                            bindRptServer = ((File)object).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException);
                            bindRptServer = null;
                        }
                    } else {
                        bindRptServer = null;
                    }
                }
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6670023, bindRptServer, 6);
            }
            if ((append = properties.getProperty("codebase")) == null || append.length() == 0) {
                append = SEDU.getServerEnv().getHomePath() + "lib";
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6670024, append, 6);
            }
            try {
                object = new File(append);
                if (!((File)object).exists() || ((File)object).isFile()) {
                    append = null;
                    ServiceLogger.logError(2670025, append, 2);
                } else {
                    append = ((File)object).getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                ServiceLogger.logError(2670026, append, 2);
                append = null;
            }
            try {
                canRead = isRemoteServer ? SEDU.getServerEnv().getWebPageOptions().needSecurity() : ServerEnv.needSecurity();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            object = properties.getProperty("isConvertedServletPath");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                LINE = true;
            }
            if (!isRemoteServer) {
                SEDU.start();
            }
            createDispatcher = true;
            destroy = true;
        }
        catch (RuntimeException runtimeException) {
            try {
                HttpUtil.shutdownServer();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(runtimeException);
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        finally {
            decodeEsc = false;
        }
        string = null;
        try {
            string = SEDU.getResourceManager().getRealm();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (ServiceLogger.isLoggable(3, 4)) {
            ServiceLogger.logEvent(4670027, new Object[]{string, checkLoginEx, close, bindRptServer, build, append, closeAll, add, LINE, copyFilesByPrefix, connect, dispatch, canRead}, 4);
        }
    }

    public static boolean isRemoteServer() {
        return isRemoteServer;
    }

    public static RemoteFileService getRemoteFileService() {
        return exists;
    }

    public static RemoteFileService getRemoteFileService(HttpServletRequest httpServletRequest) {
        RemoteFileService remoteFileService = null;
        if (System.getProperty("jrs.remote.dispatcher") != null) {
            if (!destroy) {
                HttpUtil.initEnv(System.getProperties());
            }
            try {
                remoteFileService = RemoteDispatcherFactory.getInstance().getDispatchedFileService(httpServletRequest);
                return remoteFileService;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRptServer getHttpRptServer() {
        if (isRemoteServer) {
            SEDU = RemoteReportServerToolkit.getRemoteWrappedRptServer(equals, equalsIgnoreCase);
            exists = RemoteReportServerToolkit.getRemoteFileService(equals, equalsIgnoreCase);
            Object object = flush;
            synchronized (object) {
                try {
                    if (finish != null) {
                        finish.getAvailableEncoding();
                    }
                }
                catch (RemoteException remoteException) {
                    finish = null;
                }
                try {
                    if (finish == null) {
                        finish = (RemoteNLSManager)RemoteObjectFactory.getRemoteObject(equals, Integer.parseInt(equalsIgnoreCase), "nlsManager");
                        UserDataToolkit.setNLSManager(new JRNLSManager(finish));
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
        return SEDU;
    }

    public static HttpRptServer getHttpRptServer(HttpServletRequest httpServletRequest) {
        HttpRptServer httpRptServer = null;
        if (System.getProperty("jrs.remote.dispatcher") != null) {
            if (!destroy) {
                System.getProperties().put("jreport.context", httpServletRequest.getSession().getServletContext());
                HttpUtil.initEnv(System.getProperties());
            }
            try {
                httpRptServer = RemoteDispatcherFactory.getInstance().getDispatchedServer(httpServletRequest);
                return httpRptServer;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return HttpUtil.getHttpRptServer();
    }

    public static HttpRptServer getHttpRptServer(HttpServletRequest httpServletRequest, int n) {
        HttpRptServer httpRptServer;
        ServiceLogger.logDebug("HttpUtil.getHttpRptServer by MemberId:: clusterMemberId=" + n);
        HttpRptServer httpRptServer2 = httpRptServer = httpServletRequest == null ? HttpUtil.getHttpRptServer() : HttpUtil.getHttpRptServer(httpServletRequest);
        if (!httpRptServer.isClusterEnable() || n == -1) {
            return httpRptServer;
        }
        if (httpRptServer.getClusterService().getLocalMember().getID() == n) {
            return httpRptServer;
        }
        try {
            for (Member member : httpRptServer.getClusterService().getAllMembers()) {
                if (n != member.getID()) continue;
                return RemoteReportServerToolkit.getRemoteWrappedRptServer(member.getHost(), member.getPort());
            }
            ServiceLogger.logError("ClusterNode not found: " + n, 3);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        return httpRptServer;
    }

    public static HttpRptServer dispatchHttpRptServer(HttpServletRequest httpServletRequest) {
        boolean bl;
        boolean bl2 = bl = System.getProperty("jrs.remote.dispatcher") != null;
        if (!bl && SEDU.isClusterEnable()) {
            return freeMemory.dispatch(httpServletRequest);
        }
        return HttpUtil.getHttpRptServer(httpServletRequest);
    }

    public static void bindHttpRptServer(HttpRptServer httpRptServer, String string) {
        freeMemory.bindRptServer(httpRptServer, string);
    }

    public static HttpRptServer getBindedHttpRptServer(String string) {
        return freeMemory.getBindedRptServer(string);
    }

    public static void unbindHttpRptServer(String string) {
        freeMemory.unbindRptServer(string);
    }

    public static String getAuthScheme() {
        return add;
    }

    public static String getDefaultDoc() {
        return bindRptServer;
    }

    public static String getBase(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.SEDU(httpServletRequest, true, bl, false);
    }

    public static String getBaseNoPath(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.SEDU(httpServletRequest, false, bl, false);
    }

    public static String getQueryBase(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.SEDU(httpServletRequest, true, bl, true);
    }

    public static String getQueryBaseNoPath(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.SEDU(httpServletRequest, false, bl, true);
    }

    private static String LINE(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return httpSession.getId();
    }

    private static String SEDU(HttpServletRequest httpServletRequest, boolean bl, boolean bl2, boolean bl3) {
        String string = null;
        if (bl && (string = httpServletRequest.getPathInfo()) != null && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string == null) {
            string = "";
        } else if (string.length() > 0 && !string.startsWith("/")) {
            string = "/" + string;
        }
        String string2 = HttpUtil.getServletPath(httpServletRequest);
        if (string2 == null) {
            string2 = "";
        } else {
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return bl3 && string2.trim().length() == 0 && string.trim().length() == 0 ? "/" : (bl2 ? CSUtil.replWithEsc(string2, false) : string2) + (bl2 ? CSUtil.replWithEsc(string, false) : string);
    }

    public static String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        if (!isRemoteServer) {
            UserSession userSession = SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest);
            if (userSession != null) {
                string = userSession.getUserID();
            }
        } else {
            string = SEDU.getHttpUserSessionManager().getUser(httpServletRequest);
        }
        return string == null ? "" : string;
    }

    public static boolean isSecure() {
        return canRead;
    }

    public static void restartServer() throws Throwable {
        try {
            ServiceLogger.logEvent(4670028, SEDU, 4);
            SEDU.restart(System.getProperties());
            createDispatcher = true;
            ServiceLogger.logEvent(4670029, SEDU, 4);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw throwable;
        }
    }

    public static synchronized void shutdownServer() throws Throwable {
        try {
            if (SEDU == null || HttpUtil.isRemoteServer()) {
                return;
            }
            ServiceLogger.logEvent(4670030, SEDU, 4);
            SEDU.shutdown();
            SEDU = null;
            freeMemory.destroy();
            freeMemory = null;
            if (HttpUtil.destroy()) {
                HttpUtil.createDispatcher();
            }
            ServiceLogger.logEvent(4670031, SEDU, 4);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw throwable;
        }
        finally {
            ServiceLogger.closeAll();
            ServerEnvBuilder.release();
            disconnect = true;
            destroy = false;
            createDispatcher = false;
        }
    }

    public static String getHttpURL() {
        return get;
    }

    public static boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, httpServletResponse, false);
    }

    public static boolean checkLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException, InvalidUserException {
        return HttpUtil.add(httpServletRequest, httpServletResponse, false);
    }

    public static boolean checkLogin(HttpServletRequest httpServletRequest) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, null, false);
    }

    public static boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, httpServletResponse, true);
    }

    public static boolean checkAdminLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException, InvalidUserException {
        return HttpUtil.add(httpServletRequest, httpServletResponse, true);
    }

    public static boolean checkAdminLogin(HttpServletRequest httpServletRequest) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, null, true);
    }

    private static boolean activeCount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        try {
            return HttpUtil.add(httpServletRequest, httpServletResponse, bl);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    private static boolean add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException, InvalidUserException {
        boolean bl2;
        Object object;
        Object object2;
        if (get == null) {
            object2 = httpServletRequest.getRequestURL().substring(0);
            int n = ((String)object2).indexOf(":", "http://".length());
            int n2 = n = n == -1 ? ((String)object2).indexOf("/", "http://".length()) : n;
            if (n != -1) {
                object = InetAddress.getLocalHost().getHostAddress();
                int n3 = ((String)object2).lastIndexOf("/");
                get = "http://" + (String)object + ((String)object2).substring(n, n3 + 1);
            }
        }
        HttpUtil.initEnv(System.getProperties());
        if (isRemoteServer && SEDU == null) {
            object2 = equals == null ? "null" : equals;
            String string = equalsIgnoreCase == null ? "null" : equalsIgnoreCase;
            throw new NoRemoteServerException(670010, new Object[]{object2, string}, null);
        }
        SEDU.getHttpUserSessionManager().removeExpiredUserSessions(httpServletRequest);
        object2 = new Properties();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            ((Properties)object2).put(object, httpServletRequest.getParameter((String)object));
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6670032, SEDU, 6);
            ServiceLogger.logDebug(6670033, SEDU.getHttpUserSessionManager(), 6);
            ServiceLogger.logDebug(6670034, SEDU.getResourceManager(), 6);
        }
        boolean bl3 = bl2 = HttpUtil.isSecure() && SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest) == null;
        if (bl && !SEDU.getHttpUserSessionManager().checkAdminLoginEx(httpServletRequest, httpServletResponse, SEDU.getResourceManager().getRealm(), (Properties)object2)) {
            httpServletRequest.setAttribute("isAdmin", (Object)bl);
            if (httpServletResponse != null) {
                SEDU.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, add, SEDU.getResourceManager().getRealm());
            }
            return false;
        }
        if (!SEDU.getHttpUserSessionManager().checkLoginEx(httpServletRequest, httpServletResponse, SEDU.getResourceManager().getRealm(), (Properties)object2)) {
            if (httpServletResponse != null) {
                SEDU.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, add, SEDU.getResourceManager().getRealm());
            }
            return false;
        }
        if (bl2) {
            HttpUtil.append(httpServletRequest);
        }
        object = SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest);
        try {
            if (object != null) {
                SEDU.getHttpUserSessionManager().refreshLastAccessTime(object.getID());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return true;
    }

    private static void append(HttpServletRequest httpServletRequest) {
        UserSession userSession = SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest);
        Enumeration enumeration = SEDU.getHttpUserSessionManager().getAllUserSessions();
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                UserSession userSession2 = (UserSession)enumeration.nextElement();
                if (!userSession2.getUserID().equals(userSession.getUserID())) continue;
                ++n;
            }
        }
        if (n == 1) {
            SEDU.getResourceManager().loadUserResAliasToMem(userSession.getUserID());
        }
    }

    public static void logout(HttpServletRequest httpServletRequest) {
        if (!HttpUtil.isSecure()) {
            return;
        }
        UserSession userSession = SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest);
        if (userSession == null) {
            return;
        }
        String string = userSession.getUserID();
        HttpUtil.getHttpRptServer().getHttpUserSessionManager().logout(httpServletRequest);
        Enumeration enumeration = SEDU.getHttpUserSessionManager().getAllUserSessions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                UserSession userSession2 = (UserSession)enumeration.nextElement();
                if (!userSession2.getUserID().equals(userSession.getUserID())) continue;
                return;
            }
        }
        SEDU.getResourceManager().rmUserResAliasFromMem(string);
    }

    public static boolean checkPermission(HttpServletRequest httpServletRequest) throws NoPrivilegeException {
        String string;
        Object object;
        String string2;
        String string3;
        SEDU.getTempResultOwnerManager().removeOwnersIfTimeout();
        String string4 = httpServletRequest.getParameter("jrs.cmd");
        if (string4 != null) {
            string4 = string4.trim().toLowerCase();
        } else {
            string4 = httpServletRequest.getParameter("cmd");
            if (string4 != null) {
                string4 = string4.trim().toLowerCase();
            }
        }
        if (string4 != null && SEDU.getHttpUserSessionManager().isExtraChannel(httpServletRequest)) {
            for (int i = 0; i < getAbsolutePath.length; ++i) {
                if (!string4.equals(getAbsolutePath[i])) continue;
                throw new NoPrivilegeException(630008);
            }
        }
        if ((string3 = httpServletRequest.getParameter("jrs.path")) == null || string3.length() == 0) {
            String string5 = HttpUtil.decodeEsc(httpServletRequest.getParameter("jrs.catalog"));
            string3 = string5 != null && string5.length() > 0 && string5.lastIndexOf("/") != -1 ? string5.substring(0, string5.lastIndexOf("/") + 1) : ((string2 = HttpUtil.decodeEsc(httpServletRequest.getParameter("jrs.lc"))) != null && string2.length() > 0 && string2.lastIndexOf("/") != -1 ? string2.substring(0, string2.lastIndexOf("/") + 1) : ((object = HttpUtil.decodeEsc(httpServletRequest.getParameter("jrs.report"))) != null && ((String)object).length() > 0 && ((String)object).lastIndexOf("/") != -1 ? ((String)object).substring(0, ((String)object).lastIndexOf("/") + 1) : "/"));
        }
        boolean bl = false;
        if (string4 != null && (string4.equalsIgnoreCase("jrs.try_vw") || string4.equalsIgnoreCase("jrs.web_vw"))) {
            string2 = httpServletRequest.getParameter("jrs.report");
            if (string2 != null) {
                string3 = string2;
            }
            if (null != (object = httpServletRequest.getParameter("jrd_dashboard_mode")) && ((String)object).equals("edit")) {
                bl = true;
            }
        }
        if (string3.indexOf("/") == -1) {
            string3 = HttpUtil.decodeEsc(string3);
        }
        int n = CSUtil.parseInt(httpServletRequest.getParameter("jrs.version_number"), -1);
        if (ServiceLogger.isLoggable(3, 6)) {
            ServiceLogger.logEvent(6670035, new Object[]{string4, string3, new Integer(n)}, 6);
        }
        object = SEDU.getHttpUserSessionManager().getUserSession(httpServletRequest);
        try {
            if (object != null) {
                SEDU.getHttpUserSessionManager().refreshLastAccessTime(object.getID());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6670036, SEDU, 6);
            ServiceLogger.logDebug(6670037, SEDU.getHttpUserSessionManager(), 6);
            ServiceLogger.logDebug(6670038, SEDU.getHttpUserSessionManager().getAuthenticator(), 6);
            ServiceLogger.logDebug(6670039, object, 6);
        }
        String string6 = string = object != null ? object.getUserID() : "";
        if (string3.startsWith("/USERFOLDERPATH") && !string3.startsWith("/USERFOLDERPATH/" + string)) {
            string3 = "/USERFOLDERPATH/" + string;
        }
        return object != null && HttpUtil.bindRptServer(object.getRealm(), string, string3, n, bl ? "jrs.edit_dashboard" : (string4 == null ? httpServletRequest.getMethod() : string4));
    }

    private static boolean bindRptServer(String string, String string2, String string3, int n, String string4) {
        if (n == -1) {
            return SEDU.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string, string2, string3, string4);
        }
        return SEDU.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string, string2, string3, n, string4);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws IOException {
        Object object;
        Object object2;
        boolean bl;
        String string;
        if (!file.exists()) {
            throw new IOException(JSvrResource.getMessage("SLT_ERR_71", file.getName()));
        }
        if (file.length() <= 0L) {
            ServiceLogger.logDebug(4670126, file.getName(), 4);
        } else {
            if (file.isDirectory()) {
                throw new IOException(JSvrResource.getMessage("SLT_ERR_72", file.getName()));
            }
            if (!file.canRead()) {
                throw new IOException(JSvrResource.getMessage("SLT_ERR_73", file.getName()));
            }
        }
        String string2 = file.getName();
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        if ((string = SEDU.getResourceManager().getMIMEType(string3)) == null || string.trim().length() == 0) {
            string = "application/octet-stream";
        }
        if (!(bl = ServerUtil.isFileNotModified(file, httpServletRequest, httpServletResponse))) {
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType(string);
            httpServletResponse.setContentLength((int)file.length());
            object2 = new FileInputStream(file);
            object = new byte[65536];
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                int n2 = ((FileInputStream)object2).read((byte[])object);
                while (n2 >= 0) {
                    if (n2 > 0) {
                        servletOutputStream.write((byte[])object, 0, n2);
                    }
                    n2 = ((FileInputStream)object2).read((byte[])object);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            ((FileInputStream)object2).close();
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        if (ServiceLogger.isLoggable(0, 5)) {
            object2 = httpServletRequest.getSession(false);
            object = object2 == null ? null : object2.getId();
            ServiceLogger.logAccessSuccessEvent(SEDU.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), (String)object, 5670100, new Object[]{file.getCanonicalPath(), bl ? " 304" : " 200"}, 5);
        }
    }

    public static void sendBytes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, byte[] byArray, String string) throws IOException {
        String string2;
        if (byArray.length == 0) {
            ServiceLogger.logDebug(4670156, 6);
            return;
        }
        String string3 = string;
        String string4 = "";
        int n = string3.lastIndexOf(46);
        if (n > 0) {
            string4 = string3.substring(n);
        }
        if ((string2 = SEDU.getResourceManager().getMIMEType(string4)) == null || string2.trim().length() == 0) {
            string2 = "application/octet-stream";
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(string2);
        httpServletResponse.setContentLength(byArray.length);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[65536];
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            int n2 = byteArrayInputStream.read(byArray2);
            while (n2 >= 0) {
                if (n2 > 0) {
                    servletOutputStream.write(byArray2, 0, n2);
                }
                n2 = byteArrayInputStream.read(byArray2);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        ((InputStream)byteArrayInputStream).close();
        servletOutputStream.flush();
        servletOutputStream.close();
        if (ServiceLogger.isLoggable(0, 5)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            String string5 = httpSession == null ? null : httpSession.getId();
            ServiceLogger.logAccessSuccessEvent(SEDU.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), string5, 5670157, new Object[]{string}, 5);
        }
    }

    public static void sendRemoteFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2;
        if (!HttpUtil.getRemoteFileService().exists(string) || HttpUtil.getRemoteFileService().length(string) <= 0L) {
            throw new IOException(JSvrResource.getMessage("SLT_ERR_71", string));
        }
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string3 = string.substring(n);
        }
        if ((string2 = SEDU.getResourceManager().getMIMEType(string3)) == null || string2.trim().length() == 0) {
            string2 = "application/octet-stream";
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(string2);
        httpServletResponse.setContentLength((int)HttpUtil.getRemoteFileService().length(string));
        FileInputStream fileInputStream = (FileInputStream)HttpUtil.getRemoteFileService().readFile(string);
        byte[] byArray = new byte[65536];
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            int n2 = fileInputStream.read(byArray);
            while (n2 >= 0) {
                if (n2 > 0) {
                    servletOutputStream.write(byArray, 0, n2);
                }
                n2 = fileInputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        fileInputStream.close();
        servletOutputStream.flush();
        servletOutputStream.close();
        if (ServiceLogger.isLoggable(0, 5)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            String string4 = httpSession == null ? null : httpSession.getId();
            ServiceLogger.logAccessSuccessEvent("", HttpUtil.getUser(httpServletRequest), string4, 5670100, new Object[]{string, " 304"}, 5);
        }
    }

    private static String build(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string.indexOf("?") != -1) {
            string = string.substring(0, string.indexOf("?"));
        }
        return string;
    }

    public static String getServletPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServletPath();
        if (activeCount) {
            return string;
        }
        if (string == null) {
            string = "";
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        String string2 = httpServletRequest.getRequestURI();
        if (string2 != null && string2.length() > 0) {
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() > 0 && string.length() > 0) {
                int n = string2.toLowerCase().indexOf(string.toLowerCase());
                if (n > 1) {
                    string = string2.substring(0, n + string.length());
                } else {
                    String string3 = httpServletRequest.getContextPath();
                    if (!string.startsWith(string3)) {
                        string = string3 + string;
                    }
                }
            }
        }
        return string;
    }

    public static long getReportWaitTimeouts() {
        if (!isRemoteServer) {
            return ServerEnv.getReportWaitTimeouts();
        }
        return SEDU.getServerEnv().getWebPageOptions().getReportWaitTimeouts();
    }

    public static boolean isPublishTempToVersion() {
        if (!isRemoteServer) {
            return ServerEnv.isPublishTempToVersion();
        }
        return SEDU.getServerEnv().getWebPageOptions().isPublishTempToVersion();
    }

    public static boolean isPublishTempToVersion(String string) {
        if (!isRemoteServer) {
            return ServerEnv.isPublishTempToVersion(string);
        }
        return SEDU.getServerEnv().getWebPageOptions().isPublishTempToVersion(string);
    }

    public static boolean isEnableDynamicResource() {
        if (!isRemoteServer) {
            return ServerEnv.isEnableDynamicResource();
        }
        return SEDU.getServerEnv().getWebPageOptions().isEnableDynamicResource();
    }

    public static boolean isEnableTaskDuration() {
        if (!isRemoteServer) {
            return ServerEnv.isEnableTaskDuration();
        }
        return SEDU.getServerEnv().getWebPageOptions().isEnableTaskDuration();
    }

    public static void copyFilesByPrefix(String string, String string2, String string3, String string4) throws Exception {
        SchdTools.copyFilesByPrefix(string, string2, string3, string4);
    }

    private static RandomAccessFile canRead(String string) throws IOException {
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = (RandomAccessFile)entries.get((Object)string);
        if (randomAccessFile == null) {
            randomAccessFile = new RandomAccessFile(WebSecurityUtil.validateFilePath(string), "r");
            if (endsWith.size() > encodeUrl) {
                RandomAccessFile randomAccessFile2 = (RandomAccessFile)endsWith.get(endsWith.elementAt(0));
                endsWith.remove(endsWith.elementAt(0));
                randomAccessFile2.close();
            }
            endsWith.put((Object)string, (Object)randomAccessFile);
        }
        return randomAccessFile;
    }

    public static void processPartialRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, Hashtable hashtable) throws Exception {
        RandomAccessFile randomAccessFile = null;
        String string = httpServletRequest.getHeader("Range");
        if (!file.exists()) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JSvrResource.getMessage("SLT_ERR_35", file.getCanonicalPath()));
            return;
        }
        if (string == null) {
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, file);
            return;
        }
        if (string.indexOf("bytes") < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        int n = string.indexOf(61);
        if (n < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        if ((n = (string = string.substring(n + 1, string.length())).indexOf(45)) < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        int n2 = -1;
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
            }
        }
        int n3 = -1;
        string2 = string.substring(n + 1, string.length()).trim();
        if (string2.length() == 0) {
            n3 = -1;
        } else {
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
            }
        }
        try {
            randomAccessFile = HttpUtil.canRead(file.getCanonicalPath());
            if (n3 == -1) {
                n3 = (int)randomAccessFile.length();
            }
            int n4 = Math.min(n3 - n2 + 1, (int)randomAccessFile.length() - n2);
            byte[] byArray = new byte[n4];
            randomAccessFile.seek(n2);
            int n5 = randomAccessFile.read(byArray, 0, n4);
            if (ServiceLogger.isLoggable(0, 5)) {
                ServiceLogger.logAccessSuccessEvent(SEDU.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), HttpUtil.LINE(httpServletRequest), 5670101, new Object[]{file.getCanonicalPath(), String.valueOf(n2), String.valueOf(n5), String.valueOf(randomAccessFile.length())}, 5);
            }
            HttpUtil.checkAdminLoginEx(httpServletRequest, httpServletResponse, byArray, n2, n5, (int)randomAccessFile.length(), "application/octet-stream", "chunked", true);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }

    private static void checkAdminLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, byte[] byArray, int n, int n2, int n3, String string, String string2, boolean bl) throws Exception {
        httpServletResponse.setStatus(206);
        httpServletResponse.setHeader("Content-Range", "bytes " + n + "-" + (n + n2 - 1) + "/" + n3);
        httpServletResponse.setContentType(string);
        httpServletResponse.setContentLength(n2);
        httpServletResponse.getOutputStream().write(byArray, 0, n2);
    }

    private static boolean checkLoginEx(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getPathInfo();
        if (string != null) {
            string = HttpUtil.decodeEsc(string);
            return string.toLowerCase().endsWith(".jsp");
        }
        String string2 = httpServletRequest.getRequestURI();
        if (string2 != null) {
            return string2.toLowerCase().endsWith(".jsp");
        }
        return false;
    }

    public static boolean isShowNameWithPostfix() {
        boolean bl = false;
        try {
            bl = SEDU.getServerEnv().getWebPageOptions().isShowNameWithPostfix();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return bl;
    }

    public static String getJSPWebAppName(String string) {
        String string2 = ServerEnv.getJSPWebAppName(string);
        if (isRemoteServer && (string2 == null || string2.trim().length() == 0)) {
            return SEDU.getServerEnv().getWebPageOptions().getJSPWebAppName(string);
        }
        return string2;
    }

    public static boolean useRelativeWebAppUrl() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().useRelativeWebAppUrl();
        }
        return ServerEnv.useRelativeAppUrl();
    }

    public static String getWebAppUrl(HttpServletRequest httpServletRequest, String string) {
        String string2 = "";
        if (HttpUtil.useRelativeWebAppUrl()) {
            String string3;
            int n;
            String string4 = HttpUtil.build(httpServletRequest);
            string4 = string4.substring(0, string4.lastIndexOf("/"));
            String string5 = string;
            if (!string5.startsWith("/")) {
                return string5;
            }
            string5 = HttpUtil.close(string5);
            string4 = HttpUtil.close(string4);
            while ((n = string5.indexOf("/", 1)) != -1 && string4.startsWith(string3 = string5.substring(0, n))) {
                string4 = string4.substring(n);
                string5 = string5.substring(n);
            }
            n = 0;
            if (string4.equals("/")) {
                string4 = "";
            }
            while ((n = string4.indexOf("/", n)) != -1) {
                string2 = string2 + "../";
                ++n;
            }
            string2 = string2 + string5.substring(1);
        } else {
            string2 = string;
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
        }
        return string2;
    }

    private static String close(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("/").append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private static ClassLoader closeAll() {
        class Probe {
            Probe() {
            }
        }
        ClassLoader classLoader = new Probe().getClass().getClassLoader();
        return classLoader;
    }

    private static void connect() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (activeCount) {
            string = checkAdminLoginEx + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException("Can not found language resource, Path:" + string);
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory()) continue;
                String string2 = file2.getName();
                arrayList.add(string2.replace('-', '_'));
            }
        } else {
            String string3 = "resources/jrnlslocator.txt";
            string = ServerUtil.getZipFilePath(string3);
            if (string != null) {
                String string4;
                Object object;
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    int n;
                    object = HttpUtil.closeAll();
                    string4 = "languages.jar";
                    InputStream inputStream = ((ClassLoader)object).getResourceAsStream(string4);
                    String string5 = System.getProperty("java.io.tmpdir");
                    SecureRandom secureRandom = new SecureRandom();
                    String string6 = "tmp" + Integer.toHexString(secureRandom.nextInt());
                    File file = new File(string5, string6);
                    file.mkdir();
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string4));
                    byte[] byArray = new byte[512000];
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    string = file.getAbsolutePath() + File.separator + string4;
                    zipFile = new ZipFile(string);
                }
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = ((Object)enumeration.nextElement()).toString();
                    if (object == null || !((String)object).endsWith("/properties/")) continue;
                    string4 = ((String)object).substring(0, ((String)object).indexOf("/properties/"));
                    string4 = string4.substring(string4.lastIndexOf("/") + 1);
                    arrayList.add(string4.replace('-', '_'));
                }
            } else {
                throw new IOException("Can not found language resource, Path:" + string);
            }
        }
        forName = arrayList;
    }

    public static List getLanguageList() {
        if (forName == null) {
            try {
                HttpUtil.connect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return forName;
    }

    public static boolean isPipeline() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().isPipeline();
        }
        return ServerEnv.isPipeline();
    }

    public static boolean isShowVersionParamContents() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().isShowVersionParamContents();
        }
        return ServerEnv.isShowVersionParamContents();
    }

    private static String copyFilesByPrefix(long l) {
        StringBuffer stringBuffer = new StringBuffer("" + l);
        int n = stringBuffer.length();
        if (n > 3) {
            for (int i = n - 3; i > 0; i -= 3) {
                stringBuffer.insert(i, ",");
            }
        }
        return stringBuffer.toString();
    }

    public static String getProductVersionInfo() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = string + "Version " + ReportEnv.getVerWithoutProducteInfo();
        return string2;
    }

    public static String getInternalBuildLable() {
        String string = "" + ReportEnv.internalBuildLable;
        return string;
    }

    public static String getProductLicense(SimpleDateFormat simpleDateFormat) {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;" + ReportEnv.getProductLicense((String)"<br>&nbsp;&nbsp;&nbsp;&nbsp;", (SimpleDateFormat)simpleDateFormat);
        return string;
    }

    public static String getProductSystemInfo() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = "<br>";
        String string3 = "";
        Runtime runtime = Runtime.getRuntime();
        string3 = string3 + string + "Total memory available for objects: " + HttpUtil.copyFilesByPrefix(runtime.totalMemory()) + " bytes (" + HttpUtil.copyFilesByPrefix(runtime.freeMemory()) + " bytes free)" + System.getProperty("line.separator") + string2;
        string3 = string3 + string + "Active threads count: " + Thread.activeCount();
        return string3;
    }

    public static String getAdhocServletPath() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAdhocServletPath();
        }
        return ServerEnv.getAdhocServletPath();
    }

    public static String getAdhocJspPath() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAdhocJspPath();
        }
        return ServerEnv.getAdhocJspPath();
    }

    public static String getJRServletPath() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getJRServletPath();
        }
        return ServerEnv.getJRServletPath();
    }

    public static boolean isEnableMonitorLink() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().isEnableMonitorLink();
        }
        return ServerEnv.isEnableMonitorLink();
    }

    public static String getProductSystemProp() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = "<br>";
        String string3 = "";
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.indexOf(".separator") >= 0) continue;
            string3 = string3 + string + string4 + ": " + (String)properties.get(string4) + string2;
        }
        return string3;
    }

    public static boolean getAdHoc() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAdHoc();
        }
        return ServerEnv.getAdHocUser() > 0;
    }

    public static String getLogInfoBeforeService(ServletRequest servletRequest, ServletResponse servletResponse) {
        StringBuffer stringBuffer = new StringBuffer(servletRequest.getClass().getName() + "@" + Integer.toHexString(servletRequest.hashCode()) + "->" + servletResponse.getClass().getName() + "@" + Integer.toHexString(servletResponse.hashCode()));
        if (!(servletRequest instanceof HttpServletRequest)) {
            return stringBuffer.append(" " + servletRequest.getProtocol()).toString();
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        stringBuffer.append(CSUtil.LINE + "\t" + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " " + httpServletRequest.getProtocol());
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("Authorization")) {
                    stringBuffer.append(CSUtil.LINE + "\t" + string + ":(username and password)");
                    continue;
                }
                stringBuffer.append(CSUtil.LINE + "\t" + string + ":" + httpServletRequest.getHeader(string));
            }
        }
        if (activeCount) {
            stringBuffer.append(CSUtil.LINE + "\t" + "(Content length:" + httpServletRequest.getContentLength() + ")");
            if (servletResponse instanceof HttpResponse) {
                ((HttpResponse)servletResponse).setLogging(true);
            }
        }
        return stringBuffer.toString();
    }

    public static String getLogInfoAfterService(ServletRequest servletRequest, ServletResponse servletResponse) {
        StringBuffer stringBuffer = new StringBuffer(servletRequest.getClass().getName() + "@" + Integer.toHexString(servletRequest.hashCode()) + "->" + servletResponse.getClass().getName() + "@" + Integer.toHexString(servletResponse.hashCode()));
        if (!(servletResponse instanceof HttpServletResponse)) {
            return stringBuffer.append(servletResponse.toString()).toString();
        }
        if (activeCount && servletResponse instanceof HttpResponse) {
            try {
                String string;
                HttpResponse httpResponse = (HttpResponse)servletResponse;
                httpResponse.finish();
                byte[] byArray = httpResponse.getLog();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "ISO-8859-1"));
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(CSUtil.LINE + "\t" + string);
                    if (string.length() != 0) continue;
                    stringBuffer.append(CSUtil.LINE + "\t" + "(Contents...)");
                    break;
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
        return stringBuffer.toString();
    }

    public static Properties uploadSkinFile(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.uploadSkinFile(httpServletRequest, string);
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string);
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string, boolean bl) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string, bl);
    }

    public static boolean isStandaloneServer() {
        return activeCount;
    }

    public static void updateServletPaths(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        if (!activeCount && servletContext.getAttribute("jreport_servlet_paths_updated") == null) {
            ServerEnv.updateServletPaths(httpServletRequest);
            servletContext.setAttribute("jreport_servlet_paths_updated", (Object)"true");
        }
    }

    private static void createDispatcher() {
        ServiceLogger.logDebug(4670040, 4);
        HttpUtil.decodeEsc();
        ServiceLogger.logDebug(4670041, 4);
    }

    private static void decodeEsc() {
        ServiceLogger.logDebug(4670042, 4);
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Thread thread : map.keySet()) {
            try {
                String string = thread.getName();
                if (string.equalsIgnoreCase("AWT-EventQueue-0") || string.equalsIgnoreCase("AWT-Shutdown") || string.indexOf("ExecutorPool") >= 0 || string.equalsIgnoreCase("Java2D Disposer") || string.equalsIgnoreCase("AWT-Windows") || string.equalsIgnoreCase("ObjectManagerImplTimer") || string.equalsIgnoreCase("RMI Reaper")) {
                    ServiceLogger.logDebug(4670043, string, 4);
                    thread.interrupt();
                    thread.stop();
                    ServiceLogger.logDebug(4670044, string, 4);
                    continue;
                }
                StackTraceElement[] stackTraceElementArray = map.get(thread);
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].toString().indexOf("jet.server.jrc.TaskStatisticRecorder") <= -1 && stackTraceElementArray[i].toString().indexOf("jet.server.jrc.track.Tracker") <= -1 && stackTraceElementArray[i].toString().indexOf("jet.dataservice.impl.QueryKeyManager") <= -1 && stackTraceElementArray[i].toString().indexOf("server.servlet.http.HttpDateUpdater") <= -1) continue;
                    ServiceLogger.logDebug(4670043, string, 4);
                    thread.interrupt();
                    thread.stop();
                    ServiceLogger.logDebug(4670044, string, 4);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private static boolean destroy() {
        String string = "jet.server.servlets.";
        String string2 = "org.apache.catalina.startup.Bootstrap";
        String string3 = "org.apache.catalina.core.StandardContext.stop";
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            String string4 = new String();
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            string4 = stringWriter.toString();
            if (string4.indexOf("jet.server.servlets.") >= 0 && (string4.indexOf("org.apache.catalina.startup.Bootstrap") >= 0 || string4.indexOf("org.apache.catalina.core.StandardContext.stop") >= 0)) {
                ServiceLogger.logDebug(4670045, 4);
                return true;
            }
            ServiceLogger.logDebug(4670046, 4);
            return false;
        }
    }

    public static String getRealmDir() {
        ConfigurationCluster configurationCluster = SEDU.getAdminService().getConfigService().getConfigurationCluster();
        String string = configurationCluster.getShareRealmDirectory();
        String string2 = string == null || string.length() == 0 ? SEDU.getServerEnv().getHomePath() + "realm" : string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidMonitoringURL(String string, String string2, String string3) {
        boolean bl = false;
        string2 = HttpUtil.getHostAddress(string2);
        HttpURLConnection httpURLConnection = null;
        HttpURLConnection httpURLConnection2 = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 401) {
                int n;
                String string4 = httpURLConnection.getHeaderField("MonitoredTo");
                if (string4 != null && string2.equals(string4.substring(0, n = string4.indexOf(":"))) && string3.equals(string4.substring(n + 1))) {
                    bl = true;
                }
            } else {
                int n = string.indexOf(".jsp");
                n = string.lastIndexOf("/", n);
                String string5 = string.substring(0, n) + "/getServerStatus.jsp";
                uRL = new URL(string5);
                httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
                httpURLConnection2.connect();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection2.getInputStream()));
                String string6 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl2 = false;
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (string6.indexOf("Admin") >= 0) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    if (string6.indexOf("</tr>") >= 0) break;
                    arrayList.add(0, string6);
                }
                int n2 = 0;
                int n3 = 0;
                bl2 = false;
                String string7 = null;
                String string8 = null;
                int n4 = arrayList.size();
                for (int i = 0; i < n4; ++i) {
                    string6 = (String)arrayList.get(i);
                    if (string6.indexOf("Admin") >= 0) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl2 || (n2 = string6.indexOf(">")) <= 0) continue;
                    n3 = string6.indexOf("<", n2);
                    if (string8 == null) {
                        string8 = string6.substring(n2 + 1, n3).trim();
                        continue;
                    }
                    string7 = string6.substring(n2 + 1, n3).trim();
                    break;
                }
                if (string2.equals(string7) && string3.equals(string8)) {
                    bl = true;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                if (httpURLConnection2 != null) {
                    httpURLConnection2.disconnect();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return bl;
    }

    public static boolean isValidMonitoringURL(String string) {
        if (isRemoteServer) {
            return HttpUtil.isValidMonitoringURL(string, equals, equalsIgnoreCase);
        }
        return HttpUtil.isValidMonitoringURL(string, ServerEnv.getLocalRMIHost(), String.valueOf(ServerEnv.getActiveRMIPort()));
    }

    public static String getValidMonitoringURL() {
        return SEDU.getServerEnv().getWebPageOptions().getMonitoringWebURL();
    }

    public static String getValidMonitoringURL(String string, String string2) {
        String string3 = null;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "RemoteMonitorService");
            if (remoteMonitorService != null) {
                string3 = remoteMonitorService.getMonitorServerURL();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static String getHostAddress(String string) {
        String string2 = null;
        try {
            string2 = string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        return string2;
    }

    public static int getAutoRecoverTaskMaxTimes() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAutoRecoverTaskMaxTimes();
        }
        return ServerEnv.getAutoRecoverTaskMaxTimes();
    }

    public static long getAutoRecoverTaskInterval() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAutoRecoverTaskInterval();
        }
        return ServerEnv.getAutoRecoverTaskInterval();
    }

    public static boolean getAutoRecoverTaskRedoAll() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getAutoRecoverTaskRedoAll();
        }
        return ServerEnv.getAutoRecoverTaskRedoAll();
    }

    public static String getJspUri(HttpServletRequest httpServletRequest, String string) {
        if (HttpUtil.isStandaloneServer()) {
            return string;
        }
        if (string.startsWith("/")) {
            return httpServletRequest.getContextPath() + string;
        }
        return string;
    }

    public static String getOndemandJspUri(HttpServletRequest httpServletRequest) {
        return HttpUtil.getJspUri(httpServletRequest, "/jinfonet/getOndemand.jsp");
    }

    public static String filterXSS(String string) {
        if (string != null) {
            int n = -1;
            while ((n = string.indexOf("+", n + 1)) >= 0) {
                int n2 = string.lastIndexOf("'", n);
                if (n2 < 0) {
                    n2 = string.lastIndexOf("\"", n);
                }
                if (n2 < 0) continue;
                int n3 = string.indexOf("'", n);
                if (n3 < 0) {
                    n3 = string.indexOf("\"", n);
                }
                if (n3 <= 0) continue;
                string = string.substring(0, n2) + string.substring(n3 + 1);
            }
        }
        return string;
    }

    public static int getOndemandTaskInitPriority() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getOndemandTaskInitPriority();
        }
        return ServerEnv.getOndemandTaskInitPriority();
    }

    public static int getScheduleTaskInitPriority() {
        if (isRemoteServer) {
            return SEDU.getServerEnv().getWebPageOptions().getScheduleTaskInitPriority();
        }
        return ServerEnv.getScheduleTaskInitPriority();
    }

    public static String getReferer(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("http_header_referer");
        ServiceLogger.logDebug("HttpUtil::getReferer: http_header_referer(request parameter) = " + string, 6);
        if (string == null || string.trim().length() == 0) {
            String string2 = httpServletRequest.getHeader("referer");
            String string3 = httpServletRequest.getHeader("host");
            String string4 = ServerUtil.getSiteFromUrl(string2);
            if (string2 != null) {
                string = string2.substring(string4.length());
                String string5 = httpServletRequest.getContextPath();
                ServiceLogger.logDebug("HttpUtil::getReferer: referer = " + string + ", headerReferer = " + string2 + ", host = " + string3 + ", contextPath = " + string5, 6);
            }
        }
        if (string == null) {
            string = "";
        }
        return ServerUtil.encodeUrl(string);
    }

    public static String printURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getRequestURI());
        stringBuffer.append("?");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            for (String string2 : stringArray = httpServletRequest.getParameterValues(string)) {
                stringBuffer.append("&" + string + "=" + string2);
            }
        }
        return stringBuffer.toString();
    }

    public static void handleFileNameByBrowserTypeForDownload(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string2;
        String string3;
        if (null == string || 0 == string.length() || null == httpServletRequest || null == httpServletResponse) {
            throw new Exception("Download file name, request or response can not be null");
        }
        int n = ServerUtil.getBrowserTypeByUserAgent(httpServletRequest);
        if (0 == n) {
            int n2;
            string3 = -1 != string.lastIndexOf(".") ? string.substring(0, string.lastIndexOf(".")) : string;
            String string4 = -1 != string.lastIndexOf(".") ? string.substring(string.lastIndexOf(".")) : "";
            String string5 = URLEncoder.encode(string3, "UTF-8");
            if (-1 != string5.lastIndexOf("%0A")) {
                string5 = string5.substring(0, string5.length() - 3);
            }
            if ((n2 = 150 - string4.length()) < string5.length() && -1 != (string5 = URLEncoder.encode(string3.substring(0, Math.min(string3.length(), n2 / 9)), "UTF-8")).lastIndexOf("%0A")) {
                string5 = string5.substring(0, string5.length() - 3);
            }
            string2 = string5.replace("+", "%20") + string4;
        } else {
            string2 = 1 == n || 2 == n ? "=?UTF-8?B?" + new String(Base64.encode((byte[])string.getBytes("UTF-8"))) + "?=" : (3 == n ? (null != CSUtil.getUrlEncoding() && 0 < CSUtil.getUrlEncoding().length() ? new String(string.getBytes(CSUtil.getUrlEncoding()), "ISO-8859-1") : string) : string);
        }
        string3 = URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string2 + "\";filename*=UTF-8''" + string3 + "");
    }
}

