/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.paramlist;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.server.api.paramlist.ParamValue;

public abstract class ParamList
implements Serializable {
    private static final long serialVersionUID = -3972830994661275693L;
    protected String name;
    protected Map<String, String> attributes;
    protected List<ParamValue> paramValues;
    protected Map<String, ParamValue> paramValueMap;

    public List<ParamValue> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List<ParamValue> list) {
        this.paramValues = list;
        if (this.paramValues != null) {
            this.paramValueMap = new HashMap<String, ParamValue>();
            for (ParamValue paramValue : this.paramValues) {
                this.paramValueMap.put(paramValue.getName(), paramValue);
            }
        } else {
            this.paramValueMap = null;
        }
    }

    public void addParamValue(ParamValue paramValue) {
        if (paramValue == null) {
            return;
        }
        if (this.paramValues == null) {
            this.paramValues = new LinkedList<ParamValue>();
            this.paramValueMap = new HashMap<String, ParamValue>();
        }
        this.paramValues.add(paramValue);
        this.paramValueMap.put(paramValue.getName(), paramValue);
    }

    public Map<String, ParamValue> getParamValueMap() {
        return this.paramValueMap;
    }

    public int sizeOfParamValues() {
        return this.paramValues == null ? 0 : this.paramValues.size();
    }

    public ParamValue getParamValue(String string) {
        if (this.paramValueMap != null) {
            return this.paramValueMap.get(string);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> map) {
        this.attributes = map;
    }

    public String get(String string) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes.get(string);
    }

    public void set(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if (string2 != null) {
            this.attributes.put(string, string2);
        }
    }

    public List<ParamValue> sort(String string, String[] stringArray) {
        if (this.paramValueMap == null) {
            return null;
        }
        LinkedList<ParamValue> linkedList = new LinkedList<ParamValue>();
        linkedList.add(this.paramValueMap.get(string));
        for (String string2 : stringArray) {
            if (string2.equalsIgnoreCase(string)) continue;
            linkedList.add(this.paramValueMap.get(string2));
        }
        return linkedList;
    }

    public boolean isParamValuesEquals(List<ParamValue> list) {
        if (this.paramValues == null || this.paramValues.size() == 0) {
            return list == null || list.size() == 0;
        }
        if (list == null || list.size() == 0) {
            return false;
        }
        if (this.paramValues.size() != list.size()) {
            return false;
        }
        for (int i = this.paramValues.size() - 1; i >= 0; --i) {
            ParamValue paramValue = this.paramValues.get(i);
            ParamValue paramValue2 = list.get(i);
            String[] stringArray = paramValue.getValue();
            String[] stringArray2 = paramValue2.getValue();
            if (stringArray == null || stringArray.length == 0) {
                if (stringArray2 == null || stringArray2.length == 0) continue;
                return false;
            }
            if (stringArray2 == null || stringArray2.length == 0) {
                return false;
            }
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (int j = stringArray.length - 1; j >= 0; --j) {
                linkedList.add(stringArray[j]);
                linkedList2.add(stringArray2[j]);
            }
            for (String string : linkedList) {
                if (linkedList2.contains(string)) continue;
                return false;
            }
        }
        return true;
    }
}

