/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.core.memory;

import java.util.Hashtable;
import java.util.Map;
import jet.server.cache.core.intf.CacheAttributes;
import jet.server.cache.core.memory.intf.MemoryCache;
import jet.server.cache.util.CacheShrinker;
import jet.server.cache.util.ThreadCreator;
import jet.server.cache.util.ThreadExecutor;

public abstract class AbstractMemoryCache
implements MemoryCache {
    protected String cacheName;
    protected Map map = new Hashtable();
    private static ThreadExecutor SEDU;
    CacheAttributes cattr;

    @Override
    public synchronized void initialize(CacheAttributes cacheAttributes) {
        this.cattr = cacheAttributes;
        this.cacheName = cacheAttributes.getCacheName();
        if (cacheAttributes.isUseMemoryShrinker() && cacheAttributes.getShrinkerRunTime() > 0) {
            if (SEDU == null) {
                SEDU = new ThreadExecutor(new MyThreadCreator());
            }
            SEDU.executePeriodically(cacheAttributes.getShrinkerRunTime() * 1000, new CacheShrinker(this), false);
        }
    }

    @Override
    public void removeAll() {
        this.map = new Hashtable();
    }

    @Override
    public void dispose() {
        if (SEDU != null) {
            SEDU.shutDown();
        }
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public String getCacheName() {
        return this.cattr.getCacheName();
    }

    class MyThreadCreator
    implements ThreadCreator {
        MyThreadCreator() {
        }

        @Override
        public Thread create(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }
    }
}

