/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster;

import java.net.UnknownHostException;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.jrc.JRMember;
import jet.server.jrc.JRReportMember;
import jet.server.log.ServiceLogger;
import jet.server.schedule.jrtasks.JRTask;

public class ClusterEnv {
    public static final int TIME_OUT = 0;
    private static final JRReportMember SEDU = new JRReportMember();
    private static boolean append;
    private static long currentTimeMillis;

    public static void init() throws ClusterException {
        if (append) {
            return;
        }
        try {
            SEDU.setID(CSUtil.parseInt(ServerEnv.getServerID(), 0));
            SEDU.setHost(ServerEnv.getLocalRMIHost());
            SEDU.setPort(ServerEnv.getServerRMIPort());
            SEDU.setMemberType(1);
            int n = ServerEnv.getQueueSize();
            if (n > 0) {
                SEDU.setMaxConcurrentReports(n);
            } else {
                SEDU.setMaxConcurrentReports(JRTask.getMaxReports());
            }
            SEDU.setServerName(SEDU.getHost() + "(" + SEDU.getPort() + ")");
            ServiceLogger.logDebug(4650033, new Object[]{ClusterEnv.isClusterEnabled(), ClusterEnv.getClusterName(), SEDU, SEDU.getSignature()}, 4);
            append = true;
        }
        catch (UnknownHostException unknownHostException) {
            throw new ClusterException(unknownHostException);
        }
    }

    public static boolean isClusterEnabled() {
        return ServerEnv.isClusterEnabled();
    }

    public static int getShareMemoryNodeNum() {
        return ServerEnv.getShareMemoryNodeNumber();
    }

    public static int getMinShareMemoryNodeNum() {
        return 1;
    }

    public static String getClusterName() {
        return ClusterEnv.isClusterEnabled() ? ServerEnv.getClusterName() : "";
    }

    public static int getMemberID() {
        return SEDU.getID();
    }

    public static String getServerName() {
        return SEDU.getServerName();
    }

    public static String getHost() {
        return SEDU.getHost();
    }

    public static String getRMIPort() {
        return SEDU.getPort();
    }

    public static JRMember getMember() {
        return SEDU;
    }

    public static void setClusterTimeDiff(long l) {
        currentTimeMillis = l;
        ServiceLogger.logDebug("ClusterEnv:: setClusterTimeDiff=" + l);
    }

    public static long getClusterTime() {
        return System.currentTimeMillis() + currentTimeMillis;
    }

    static {
        currentTimeMillis = 0L;
    }
}

