/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import jet.cs.CSUtil;
import jet.server.cluster.ClusteredServerChangeListener;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberListenerAdapter;
import jet.server.cluster.core.MemberService;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class ClusterRemoteObjectLocator
extends MemberListenerAdapter {
    private static ClusterRemoteObjectLocator SEDU = null;
    private HashMap append = new HashMap();
    private MemberService clear;
    private ClusteredServerChangeListener equals;
    private JRMember get;

    public static ClusterRemoteObjectLocator getInstance() {
        return SEDU;
    }

    public static void initInstance(MemberService memberService) {
        if (SEDU == null) {
            SEDU = new ClusterRemoteObjectLocator(memberService);
        }
    }

    public static void clearInstance() {
        SEDU.clear();
        SEDU = null;
    }

    private ClusterRemoteObjectLocator(MemberService memberService) {
        this.clear = memberService;
    }

    public Remote getRemoteObjectInCluster(String string) throws MalformedURLException, RemoteException, NotBoundException {
        Remote remote = (Remote)this.append.get(string);
        if (remote != null) {
            return remote;
        }
        if (this.get == null) {
            this.get = this.clear.getDefaultShareMemoryNode();
            ServiceLogger.logDebug("ClusterRemoteObjectLocator: bindedSharedNode=" + this.get);
        }
        remote = RemoteObjectFactory.getRemoteObject(this.get.getHost(), CSUtil.parseInt(this.get.getPort()), string);
        this.append.put(string, remote);
        return remote;
    }

    private void clear() {
        this.get = null;
        this.append.clear();
        this.append = null;
    }

    public void addListener(ClusteredServerChangeListener clusteredServerChangeListener) {
        this.equals = clusteredServerChangeListener;
    }

    @Override
    public void viewAccepted(JRView jRView) {
        if (this.get == null) {
            return;
        }
        if (this.clear.isShareMemoryNode()) {
            this.equals.rebuildShareMemoryNode();
            this.clear();
            return;
        }
        JRMember[] jRMemberArray = this.clear.getShareMemoryNodes();
        boolean bl = false;
        for (JRMember jRMember : jRMemberArray) {
            if (!jRMember.equals(this.get)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.get = null;
            this.append.clear();
        }
    }
}

