/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterRuntimeException;
import jet.server.cluster.blocks.ClusterMapImpl;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapContainer;
import jet.server.cluster.blocks.MapEvent;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.Topic;
import jet.server.cluster.core.Transceiver;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;

class ClusterMapTransceiver
extends Transceiver
implements MapContainer {
    private static final Topic ALL_NODES = Topic.CLUSTER_MAP;
    private static final int CLUSTER_MAP = 1;
    private static final int SEDU = 2;
    private static final int SHARE_NODES = 3;
    private static final int append = 4;
    private static final int cancelInit = 5;
    private ConcurrentHashMap castMessage = new ConcurrentHashMap();
    private boolean castRequestAndReturnFirstResult = super.getMemberService().isShareMemoryNode();
    private int checkDirectory = -1;
    private Map clear;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterMapTransceiver getInstance() throws ClusterException {
        ClusterMapTransceiver clusterMapTransceiver = (ClusterMapTransceiver)ClusterServer.getTransceiver(ALL_NODES);
        if (clusterMapTransceiver != null) {
            return clusterMapTransceiver;
        }
        Class<ClusterMapTransceiver> clazz = ClusterMapTransceiver.class;
        synchronized (ClusterMapTransceiver.class) {
            clusterMapTransceiver = (ClusterMapTransceiver)ClusterServer.getTransceiver(ALL_NODES);
            if (clusterMapTransceiver == null) {
                clusterMapTransceiver = new ClusterMapTransceiver();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return clusterMapTransceiver;
        }
    }

    public ClusterMapTransceiver() throws ClusterException {
        super(ALL_NODES);
        this.CLUSTER_MAP(this.castRequestAndReturnFirstResult ? 2 : 3);
    }

    public boolean isShareMemoryNode() {
        return this.castRequestAndReturnFirstResult;
    }

    public int getDefaultShareMemoryNode() {
        return super.getMemberService().getDefaultShareMemoryNode().getID();
    }

    private HashMap ALL_NODES() {
        HashMap<String, ClusterMapImpl> hashMap = new HashMap<String, ClusterMapImpl>();
        for (ClusterMapImpl clusterMapImpl : this.castMessage.values()) {
            if (clusterMapImpl.getMapAttr().distributePolicy() != MapAttr.DistributePolicy.SHARE_NODES) continue;
            hashMap.put(clusterMapImpl.getName(), clusterMapImpl);
        }
        return hashMap;
    }

    private void CLUSTER_MAP(int n) throws ClusterException {
        if (!this.isCoordinator()) {
            ServiceLogger.logDebug(4650058, 4);
        }
        JRMessage jRMessage = new JRMessage(n, null);
        jRMessage.setHeader((Serializable)((Object)"MapCmd"), (Serializable)((Object)("GET_MAPS: " + (n == 2 ? "ALL" : (n == 3 ? "PUBLIC" : "SHARE")))));
        Map map = (Map)super.sendRequest(-1, jRMessage, 0L);
        this.SEDU(super.getCoordinator().getID(), map);
    }

    private void SEDU(int n, Map map) {
        if (map != null) {
            for (ClusterMapImpl clusterMapImpl : map.values()) {
                this.getMap(clusterMapImpl.getName()).doInit(n, clusterMapImpl);
            }
        } else {
            for (ClusterMapImpl clusterMapImpl : this.ALL_NODES().values()) {
                ClusterInitLocker.cancelInit(clusterMapImpl.getName());
                clusterMapImpl.doInit(n, null);
            }
        }
    }

    private void SHARE_NODES() {
        if (super.getMemberService().isShareMemoryNode() && super.getMemberService().getShareMemoryNodes().length == 1 && super.getMembers().size() > 1) {
            int n = ((JRMember)super.getMembers().get(1)).getID();
            JRMessage jRMessage = new JRMessage(5, this.ALL_NODES());
            jRMessage.setHeader((Serializable)((Object)"MapCmd"), (Serializable)((Object)"POST_SHARE_MAPS"));
            try {
                super.sendRequest(n, jRMessage, 0L);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    @Override
    public ClusterMapImpl getMap(String string) {
        ClusterMapImpl clusterMapImpl = (ClusterMapImpl)this.castMessage.get(string);
        if (clusterMapImpl == null) {
            this.castMessage.putIfAbsent(string, new ClusterMapImpl(string, this));
            clusterMapImpl = (ClusterMapImpl)this.castMessage.get(string);
        }
        return clusterMapImpl;
    }

    @Override
    public void viewAccepted(JRView jRView) {
        boolean bl = this.castRequestAndReturnFirstResult;
        this.castRequestAndReturnFirstResult = super.getMemberService().isShareMemoryNode();
        if (jRView.isMergeView()) {
            for (ClusterMapImpl clusterMapImpl : this.castMessage.values()) {
                clusterMapImpl.markDirectoryToVerify();
            }
        }
        if (this.castRequestAndReturnFirstResult && !bl) {
            if (this.clear != null) {
                this.SEDU(this.checkDirectory, this.clear);
            } else {
                try {
                    this.CLUSTER_MAP(4);
                }
                catch (ClusterException clusterException) {
                    ServiceLogger.logError((Throwable)((Object)clusterException));
                }
            }
        }
        this.clear = null;
        this.checkDirectory = -1;
    }

    @Override
    public void checkState() {
        for (ClusterMapImpl clusterMapImpl : this.castMessage.values()) {
            clusterMapImpl.checkDirectory();
        }
    }

    @Override
    public void beforeClose() {
        this.SHARE_NODES();
        for (ClusterMapImpl clusterMapImpl : this.castMessage.values()) {
            clusterMapImpl.doDestroy();
        }
        this.castMessage.clear();
    }

    @Override
    public void handleMessage(JRMessage jRMessage) {
        try {
            this.append(jRMessage);
        }
        catch (ClusterException clusterException) {
            throw new ClusterRuntimeException((Throwable)((Object)clusterException));
        }
    }

    @Override
    public Serializable handleRequest(JRMessage jRMessage) {
        try {
            return this.append(jRMessage);
        }
        catch (ClusterException clusterException) {
            throw new ClusterRuntimeException((Throwable)((Object)clusterException));
        }
    }

    private Serializable append(JRMessage jRMessage) throws ClusterException {
        if (jRMessage.getSource() == this.getLocalMember().getID()) {
            ServiceLogger.logError(new Exception("local member message: " + jRMessage));
            return null;
        }
        switch (jRMessage.getFlag()) {
            case 2: {
                return this.castMessage;
            }
            case 3: {
                HashMap<String, ClusterMapImpl> hashMap = new HashMap<String, ClusterMapImpl>();
                for (ClusterMapImpl clusterMapImpl : this.castMessage.values()) {
                    if (clusterMapImpl.getMapAttr().distributePolicy() != MapAttr.DistributePolicy.ALL_NODES) continue;
                    hashMap.put(clusterMapImpl.getName(), clusterMapImpl);
                }
                return hashMap;
            }
            case 4: {
                return this.ALL_NODES();
            }
            case 5: {
                this.checkDirectory = jRMessage.getSource();
                this.clear = (Map)((Object)jRMessage.getObject());
                return Boolean.valueOf(true);
            }
            case 1: {
                MapEvent mapEvent = (MapEvent)jRMessage.getObject();
                mapEvent.setSourceMember(jRMessage.getSource());
                ClusterMapImpl clusterMapImpl = this.getMap(mapEvent.getMapName());
                return (Serializable)clusterMapImpl.handleMapCommand(mapEvent);
            }
        }
        ServiceLogger.logError(this + ":: Unknown message: " + jRMessage);
        return null;
    }

    private JRMessage cancelInit(MapEvent mapEvent) {
        JRMessage jRMessage = new JRMessage(1, mapEvent);
        jRMessage.setHeader((Serializable)((Object)"MapCmd"), (Serializable)((Object)mapEvent.getCmd().toString()));
        jRMessage.setHeader((Serializable)((Object)"MapName"), (Serializable)((Object)mapEvent.getMapName()));
        return jRMessage;
    }

    public void mapMessage(int n, MapEvent mapEvent) {
        try {
            super.sendMessage(n, this.cancelInit(mapEvent));
        }
        catch (ClusterException clusterException) {
            throw new RuntimeException((Throwable)((Object)clusterException));
        }
    }

    public void mapMessage(List list, MapEvent mapEvent) {
        try {
            if (list == null) {
                super.castMessage(this.cancelInit(mapEvent));
            } else if (!list.isEmpty()) {
                super.castMessage(list, this.cancelInit(mapEvent));
            }
        }
        catch (ClusterException clusterException) {
            throw new RuntimeException((Throwable)((Object)clusterException));
        }
    }

    public Object mapRequest(int n, MapEvent mapEvent) {
        try {
            return super.sendRequest(n, this.cancelInit(mapEvent), 0L);
        }
        catch (ClusterException clusterException) {
            throw new RuntimeException((Throwable)((Object)clusterException));
        }
    }

    public Object mapRequest(List list, MapEvent mapEvent) {
        try {
            return super.castRequestAndReturnFirstResult(list, this.cancelInit(mapEvent), true, 0L);
        }
        catch (ClusterException clusterException) {
            throw new RuntimeException((Throwable)((Object)clusterException));
        }
    }
}

