/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jet.server.ServerEnv;
import jet.server.cluster.blocks.ClusterMapImpl;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapCmd;
import jet.server.cluster.blocks.MapEntry;
import jet.server.cluster.blocks.MapEvent;
import jet.server.cluster.blocks.MapKeyTag;
import jet.server.log.ServiceLogger;

class Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long $SwitchMap$jet$server$cluster$blocks$MapCmd = ServerEnv.getResultLife() * 1000L;
    private ConcurrentHashMap dir = new ConcurrentHashMap();
    private boolean isReady = true;
    private final transient ClusterMapImpl DIR_CMP_AND_GET_LATEST;
    private final transient MapAttr.VerifyPolicy DIR_GET_STATE;
    private final transient boolean LAST_MODIFIER_ALIVE;

    public Directory(ClusterMapImpl clusterMapImpl) {
        this.DIR_CMP_AND_GET_LATEST = clusterMapImpl;
        this.DIR_GET_STATE = clusterMapImpl.getMapAttr().verifyPolicy();
        this.LAST_MODIFIER_ALIVE = this.DIR_GET_STATE == MapAttr.VerifyPolicy.NO_VERIFY;
    }

    private boolean $SwitchMap$jet$server$cluster$blocks$MapCmd() {
        return this.LAST_MODIFIER_ALIVE || !this.DIR_CMP_AND_GET_LATEST.isResourceNode();
    }

    public void initFromRemote(Directory directory) {
        if (directory != null) {
            this.dir.putAll(directory.dir);
            this.isReady = directory.isReady;
            ServiceLogger.logDebug(4650069, new Object[]{this.DIR_CMP_AND_GET_LATEST.name, this.isReady, this.dir.size(), this.DIR_CMP_AND_GET_LATEST.getMapAttr().verifyPolicy()}, 4);
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean bl) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        this.isReady = bl;
        ServiceLogger.logDebug(4650070, new Object[]{this.DIR_CMP_AND_GET_LATEST.name, bl}, 4);
    }

    public void checkDirectory() {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        if (!this.isReady()) {
            this.DIR_CMP_AND_GET_LATEST();
        } else {
            this.NO_VERIFY();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DIR_CMP_AND_GET_LATEST() {
        if (this.isReady()) {
            return;
        }
        Directory directory = this;
        synchronized (directory) {
            ServiceLogger.logDebug(4650071, new Object[]{this.DIR_CMP_AND_GET_LATEST.name}, 4);
            try {
                int n;
                List list = this.DIR_CMP_AND_GET_LATEST.getResourceNodes();
                list.remove(new Integer(this.DIR_CMP_AND_GET_LATEST.transceiver.getLocalMember().getID()));
                if (list.isEmpty()) {
                    ServiceLogger.logDebug(4650080, new Object[]{this.DIR_CMP_AND_GET_LATEST.name}, 4);
                    this.DIR_GET_STATE();
                    return;
                }
                Object object = list.iterator();
                while (object.hasNext()) {
                    int n2 = (Integer)object.next();
                    n = ((Boolean)this.DIR_CMP_AND_GET_LATEST.transceiver.mapRequest(n2, new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.DIR_GET_STATE, null, new Object[0]))).booleanValue() ? 1 : 0;
                    if (n == 0) continue;
                    ServiceLogger.logDebug(4650072, new Object[]{this.DIR_CMP_AND_GET_LATEST.getName(), n2}, 4);
                    Map map = (Map)this.DIR_CMP_AND_GET_LATEST.transceiver.mapRequest(n2, new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.DIR_CMP_AND_GET_LATEST, null, this.dir));
                    this.LAST_MODIFIER_ALIVE(map);
                    return;
                }
                object = new HashMap();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    Map map = (Map)this.DIR_CMP_AND_GET_LATEST.transceiver.mapRequest(n, new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.DIR_CMP_AND_GET_LATEST, null, this.dir));
                    for (Map.Entry entry : map.entrySet()) {
                        MapEntry mapEntry = (MapEntry)object.get(entry.getKey());
                        MapEntry mapEntry2 = (MapEntry)entry.getValue();
                        if (mapEntry != null && mapEntry2.getKeyTag().compareTo(mapEntry.getKeyTag()) <= 0) continue;
                        object.put(entry.getKey(), mapEntry2);
                    }
                }
                ServiceLogger.logDebug(4650073, new Object[]{this.DIR_CMP_AND_GET_LATEST.name, object.size()}, 4);
                this.LAST_MODIFIER_ALIVE((Map)object);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private void DIR_GET_STATE() {
        if (this.DIR_GET_STATE == MapAttr.VerifyPolicy.LAST_MODIFIER_ALIVE) {
            Set set = this.DIR_CMP_AND_GET_LATEST.transceiver.getMembersIdSet();
            for (MapKeyTag mapKeyTag : this.dir.values()) {
                if (set.contains(mapKeyTag.getModifier())) continue;
                mapKeyTag.setDeleted(true);
                Object v = this.DIR_CMP_AND_GET_LATEST.getBackMap().get(mapKeyTag.getKey());
                if (v == null) continue;
                MapEvent mapEvent = new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.REMOVE, mapKeyTag, new Object[0]).unforwardEvent();
                mapEvent.setResult(v);
                this.DIR_CMP_AND_GET_LATEST.doRemove(mapEvent);
            }
        }
        this.setReady(true);
    }

    private void LAST_MODIFIER_ALIVE(Map map) {
        for (MapEntry mapEntry : map.values()) {
            Object object;
            MapKeyTag mapKeyTag = mapEntry.getKeyTag();
            Object object2 = mapEntry.getValue();
            MapKeyTag mapKeyTag2 = (MapKeyTag)this.dir.get(mapKeyTag.getKey());
            if (mapKeyTag2 != null && mapKeyTag.compareTo(mapKeyTag2) <= 0) continue;
            if (mapKeyTag.isDeleted() || object2 == null) {
                mapKeyTag.setDeleted(true);
                object = this.DIR_CMP_AND_GET_LATEST.getBackMap().get(mapKeyTag.getKey());
                if (object != null) {
                    MapEvent mapEvent = new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.REMOVE, mapKeyTag, new Object[0]).unforwardEvent();
                    mapEvent.setResult(object);
                    this.DIR_CMP_AND_GET_LATEST.doRemove(mapEvent);
                    continue;
                }
                this.dir.put(mapKeyTag.getKey(), mapKeyTag);
                continue;
            }
            object = new MapEvent(this.DIR_CMP_AND_GET_LATEST.name, MapCmd.PUT, mapKeyTag, object2).unforwardEvent();
            this.DIR_CMP_AND_GET_LATEST.doPut((MapEvent)object);
        }
        this.DIR_GET_STATE();
    }

    private synchronized void NO_VERIFY() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.dir.values().iterator();
        while (iterator.hasNext()) {
            MapKeyTag mapKeyTag = (MapKeyTag)iterator.next();
            if (!mapKeyTag.isDeleted() || l - mapKeyTag.getTimestamp() <= $SwitchMap$jet$server$cluster$blocks$MapCmd) continue;
            iterator.remove();
        }
    }

    public void destroy() {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        this.dir.clear();
    }

    public void mapPut(MapKeyTag mapKeyTag) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        mapKeyTag.setDeleted(false);
        this.dir.put(mapKeyTag.getKey(), mapKeyTag);
    }

    public void mapPutAll(MapKeyTag mapKeyTag, Map map) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        MapKeyTag mapKeyTag2 = (MapKeyTag)mapKeyTag.clone();
        mapKeyTag2.setFlags(null);
        mapKeyTag2.setDeleted(false);
        for (Object k : map.keySet()) {
            MapKeyTag mapKeyTag3 = (MapKeyTag)mapKeyTag2.clone();
            mapKeyTag3.setKey(k);
            this.dir.put(k, mapKeyTag3);
        }
    }

    public void mapRemove(MapKeyTag mapKeyTag) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        mapKeyTag.setDeleted(true);
        this.dir.put(mapKeyTag.getKey(), mapKeyTag);
    }

    public void mapClear(MapKeyTag mapKeyTag) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        MapKeyTag mapKeyTag2 = (MapKeyTag)mapKeyTag.clone();
        mapKeyTag2.setFlags(null);
        mapKeyTag2.setDeleted(true);
        for (MapKeyTag mapKeyTag3 : this.dir.values()) {
            mapKeyTag3.assignFrom(mapKeyTag2);
        }
    }

    public void mapRemoveAll(MapKeyTag mapKeyTag, Collection collection) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        MapKeyTag mapKeyTag2 = (MapKeyTag)mapKeyTag.clone();
        mapKeyTag2.setFlags(null);
        mapKeyTag2.setDeleted(true);
        for (Object e : collection) {
            MapKeyTag mapKeyTag3 = (MapKeyTag)this.dir.get(e);
            if (mapKeyTag3 == null) continue;
            mapKeyTag3.assignFrom(mapKeyTag2);
        }
    }

    public void mapRetainAll(MapKeyTag mapKeyTag, Collection collection) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        MapKeyTag mapKeyTag2 = (MapKeyTag)mapKeyTag.clone();
        mapKeyTag2.setFlags(null);
        mapKeyTag2.setDeleted(true);
        for (MapKeyTag mapKeyTag3 : this.dir.values()) {
            if (collection.contains(mapKeyTag3.getKey())) continue;
            mapKeyTag3.assignFrom(mapKeyTag2);
        }
    }

    public void mapGetAll() {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        this.DIR_CMP_AND_GET_LATEST();
    }

    public void mapGet(Object object) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return;
        }
        this.DIR_CMP_AND_GET_LATEST();
    }

    public MapKeyTag getKeyTag(Object object) {
        if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
            return null;
        }
        return (MapKeyTag)this.dir.get(object);
    }

    public Object handleMapDirCommand(MapEvent mapEvent) {
        switch (mapEvent.getCmd()) {
            case DIR_GET_STATE: {
                return this.isReady;
            }
            case DIR_CMP_AND_GET_LATEST: {
                Map map = (Map)mapEvent.getArg();
                HashMap<Object, MapEntry> hashMap = new HashMap<Object, MapEntry>();
                for (MapKeyTag mapKeyTag : this.dir.values()) {
                    MapKeyTag mapKeyTag2 = (MapKeyTag)map.get(mapKeyTag.getKey());
                    if (mapKeyTag2 != null && mapKeyTag.compareTo(mapKeyTag2) <= 0) continue;
                    Object v = this.DIR_CMP_AND_GET_LATEST.getBackMap().get(mapKeyTag.getKey());
                    hashMap.put(mapKeyTag.getKey(), new MapEntry(mapKeyTag, v));
                }
                return hashMap;
            }
        }
        return null;
    }
}

