/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import java.io.Serializable;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.MapFlags;

class MapKeyTag
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 1L;
    private Object key;
    private MapFlags flags;
    private boolean isDeleted = false;
    private int modifier;
    private long timestamp;

    public MapKeyTag(Object object, MapFlags mapFlags) {
        this.key = object;
        this.flags = mapFlags;
        this.isDeleted = false;
        this.modify(ClusterEnv.getMemberID());
    }

    public int compareTo(MapKeyTag mapKeyTag) {
        return this.timestamp < mapKeyTag.timestamp ? -1 : (this.timestamp == mapKeyTag.timestamp ? 0 : 1);
    }

    public String toString() {
        return "" + this.key;
    }

    public String printDetails() {
        return this.key + "[" + ", deleted=" + this.isDeleted + ", modifier=" + this.modifier + ", timestamp=" + this.timestamp + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void assignFrom(MapKeyTag mapKeyTag) {
        if (mapKeyTag == this) {
            return;
        }
        this.flags = mapKeyTag.flags;
        this.isDeleted = mapKeyTag.isDeleted;
        this.timestamp = mapKeyTag.timestamp;
        this.modifier = mapKeyTag.modifier;
    }

    public void modify(int n) {
        this.timestamp = ClusterEnv.getClusterTime();
        this.modifier = n;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean bl) {
        this.isDeleted = bl;
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int n) {
        this.modifier = n;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object object) {
        this.key = object;
    }

    public MapFlags getFlags() {
        return this.flags;
    }

    public void setFlags(MapFlags mapFlags) {
        this.flags = mapFlags;
    }
}

