/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.core.JRChannel;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.Topic;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;

class CoreTransceiver {
    private final int CORE = 1;
    private final int SEDU = 2;
    private final int addShareMemoryNode = 3;
    private final int castMessage = 4;
    private final int getFlag = 5;
    private JRChannel getID;
    private ConcurrentHashMap getLocalMember = new ConcurrentHashMap();
    private boolean getMemberService = false;

    public CoreTransceiver(JRChannel jRChannel) {
        this.getID = jRChannel;
    }

    public void notifyShutdown() throws ClusterException {
        JRMessage jRMessage = new JRMessage(1, null);
        jRMessage.setTopic(Topic.CORE);
        jRMessage.setSource(this.getID.getLocalMember().getID());
        jRMessage.setDest(-1);
        this.getID.castMessage(jRMessage);
    }

    public void notifyPenddingReportsChanged(List list, int n) throws ClusterException {
        int n2 = this.getID.getLocalMember().getID();
        Integer n3 = this.getLocalMember.put(n2, n);
        if (n3 != null && n3 == n) {
            return;
        }
        JRMessage jRMessage = new JRMessage(2, Integer.valueOf(n));
        jRMessage.setTopic(Topic.CORE);
        jRMessage.setSource(n2);
        jRMessage.setDest(-1);
        this.getID.castMessage(list, jRMessage);
    }

    public void handleMessage(JRMessage jRMessage) {
        switch (jRMessage.getFlag()) {
            case 1: {
                this.getID.getMemberService().shutdownMember(jRMessage.getSource());
                break;
            }
            case 2: {
                this.getLocalMember.put(jRMessage.getSource(), (Integer)jRMessage.getObject());
                this.getID.getMemberService().setPenddingReports(jRMessage.getSource(), (Integer)jRMessage.getObject());
                break;
            }
            case 5: {
                this.getID.getMemberService().getView0().addShareMemoryNode((JRMember)jRMessage.getObject());
            }
        }
    }

    public Serializable handleRequest(JRMessage jRMessage) {
        switch (jRMessage.getFlag()) {
            case 3: {
                return this.getLocalMember;
            }
            case 4: {
                return this.getID.getMemberService().getView0();
            }
        }
        return null;
    }

    public Map getPenddingReportsMap() {
        if (this.getMemberService) {
            return this.getLocalMember;
        }
        if (this.getID.getMemberService().isCoordinator()) {
            this.getMemberService = true;
            return this.getLocalMember;
        }
        JRMessage jRMessage = new JRMessage(3, null);
        jRMessage.setTopic(Topic.CORE);
        jRMessage.setSource(this.getID.getLocalMember().getID());
        jRMessage.setDest(-1);
        try {
            Map map = (Map)this.getID.sendRequest(jRMessage, 0L);
            this.getMemberService = true;
            if (map != null) {
                this.getLocalMember.putAll(map);
            }
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        return this.getLocalMember;
    }

    public JRView getHistoryView() {
        JRMessage jRMessage = new JRMessage(4, null);
        jRMessage.setTopic(Topic.CORE);
        jRMessage.setSource(this.getID.getLocalMember().getID());
        jRMessage.setDest(-1);
        JRView jRView = null;
        try {
            jRView = (JRView)this.getID.sendRequest(jRMessage, 0L);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        return jRView;
    }

    public void notifyIamShareMemory() {
        JRMessage jRMessage = new JRMessage(5, this.getID.getLocalMember());
        jRMessage.setTopic(Topic.CORE);
        jRMessage.setSource(this.getID.getLocalMember().getID());
        jRMessage.setDest(-1);
        try {
            this.getID.castMessage(jRMessage);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
    }
}

