/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.core.JRChannel;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberListener;
import jet.server.cluster.core.MemberService;
import jet.server.jrc.JRMember;
import jet.server.jrc.JRReportMember;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.rmi.rpc.RpcDispatcher;
import jet.server.rmi.rpc.RpcParam;

public class JRMemberService
implements MemberService,
MemberListener {
    private JRMember SEDU;
    private JRChannel add;
    private List afterShutdown;
    private JRView append;
    private boolean beforeShutdown;
    private boolean call;
    private Set clear = new HashSet();
    private Set clearMem = new HashSet();
    public static final String rpcHandlerName = JRMemberService.class.getName();
    private volatile RpcDispatcher connected;

    public JRMemberService(JRMember jRMember, JRChannel jRChannel) {
        this.SEDU = jRMember;
        this.add = jRChannel;
        this.afterShutdown = new CopyOnWriteArrayList();
    }

    boolean isViewReady() {
        return this.beforeShutdown;
    }

    private boolean SEDU() {
        return this.call;
    }

    void clearMem() {
        if (this.SEDU()) {
            return;
        }
        this.call = true;
        this.afterShutdown.clear();
        this.afterShutdown = null;
        this.SEDU = null;
        this.append = null;
    }

    void setViewReady(boolean bl) {
        this.beforeShutdown = bl;
    }

    JRView getView0() {
        return this.append;
    }

    void setView(JRView jRView) {
        JRView jRView2 = this.getView0();
        this.append = jRView;
        for (JRMember jRMember : this.append.getMembers()) {
            if (jRMember.isServerReady() || jRMember.equals(this.SEDU)) continue;
            try {
                RpcDispatcher rpcDispatcher = RemoteObjectFactory.getRpcDispatcher(jRMember.getHost(), Integer.valueOf(jRMember.getPort()));
                JRMember jRMember2 = (JRMember)rpcDispatcher.call(new RpcParam(rpcHandlerName, "getLocalMember", new Object[0]));
                if (!jRMember2.isServerReady()) continue;
                jRMember.setServerReady(true);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        this.clear.removeAll(this.append.getMembersIdSet());
        Set set = JRView.minus(jRView2, jRView);
        set.removeAll(this.clear);
        this.clearMem = set;
        this.beforeShutdown = true;
        ServiceLogger.logDebug(4650047, new Object[]{jRView.isCoordinator(), jRView.getViewId(), jRView.getMembersIdSet(), JRView.minus(jRView, jRView2), JRView.minus(jRView2, jRView), this.clearMem}, 4);
        ServiceLogger.logDebug("MemberService:: oldView=" + jRView2);
        ServiceLogger.logDebug("MemberService:: newView=" + jRView);
    }

    void shutdownMember(Integer n) {
        if (n != null) {
            this.clear.add(n);
        }
    }

    Set getShutdownMembers() {
        return Collections.unmodifiableSet(this.clear);
    }

    private void add(JRView jRView) {
        if (jRView == null) {
            return;
        }
        for (JRMember jRMember : jRView.getMembers()) {
            Integer n = (Integer)this.add.getCoreTransceiver().getPenddingReportsMap().get(jRMember.getID());
            if (n == null) continue;
            ((JRReportMember)jRMember).setPenddingReports(n);
        }
    }

    void setPenddingReports(int n, int n2) {
        JRReportMember jRReportMember;
        JRView jRView = this.getView0();
        if (jRView != null && (jRReportMember = (JRReportMember)jRView.getMemberById(n)) != null) {
            jRReportMember.setPenddingReports(n2);
        }
    }

    @Override
    public void viewAccepted(JRView jRView) {
        if (this.SEDU()) {
            return;
        }
        JRView jRView2 = this.getView0();
        for (MemberListener memberListener : this.afterShutdown) {
            try {
                ServiceLogger.logDebug("MemberService:: notifyView: listener=" + memberListener);
                memberListener.viewAccepted(jRView2);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    @Override
    public void connected(JRMember jRMember) throws ClusterException {
        if (this.SEDU()) {
            return;
        }
        this.getView();
        this.add(this.append);
        for (MemberListener memberListener : this.afterShutdown) {
            ServiceLogger.logDebug("MemberService:: notifyConnected: listener=" + memberListener);
            memberListener.connected(jRMember);
        }
    }

    @Override
    public void suspect(JRMember jRMember) {
        if (this.SEDU()) {
            return;
        }
        jRMember = this.getView().getMemberById(jRMember.getID());
        ServiceLogger.logDebug(4650048, jRMember, 4);
        for (MemberListener memberListener : this.afterShutdown) {
            try {
                memberListener.suspect(jRMember);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    @Override
    public void beforeShutdown() {
        if (this.SEDU()) {
            return;
        }
        for (MemberListener memberListener : this.afterShutdown) {
            try {
                ServiceLogger.logDebug("MemberService:: NotifyBeforeShutdown: listener=" + memberListener);
                memberListener.beforeShutdown();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    @Override
    public void afterShutdown() {
        if (this.SEDU()) {
            return;
        }
        for (MemberListener memberListener : this.afterShutdown) {
            try {
                ServiceLogger.logDebug("MemberService:: NotifyAfterShutdown: listener=" + memberListener);
                memberListener.afterShutdown();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        this.clearMem();
    }

    @Override
    public boolean addMemberListener(MemberListener memberListener) {
        if (this.SEDU()) {
            return false;
        }
        if (this.afterShutdown.contains(memberListener)) {
            return false;
        }
        ServiceLogger.logDebug("MemberService:: addMemberListener: listener=" + memberListener);
        return this.afterShutdown.add(memberListener);
    }

    @Override
    public boolean removeMemberListener(MemberListener memberListener) {
        if (this.SEDU()) {
            return false;
        }
        ServiceLogger.logDebug("MemberService:: removeMemberListener: listener=" + memberListener);
        return this.afterShutdown.remove(memberListener);
    }

    @Override
    public JRMember getLocalMember() {
        return this.SEDU;
    }

    @Override
    public JRMember getCoordinator() {
        return this.getView().getCoordinator();
    }

    @Override
    public boolean isCoordinator() {
        return this.getView().isCoordinator();
    }

    @Override
    public JRMember getMemberById(int n) {
        if (this.SEDU()) {
            return null;
        }
        return this.getView().getMemberById(n);
    }

    @Override
    public List getMembers() {
        if (this.SEDU()) {
            return null;
        }
        return this.getView().getMembers();
    }

    @Override
    public Set getCrashedMembers() {
        return Collections.unmodifiableSet(this.clearMem);
    }

    @Override
    public Set getMembersIdSet() {
        if (this.SEDU()) {
            return null;
        }
        return this.getView().getMembersIdSet();
    }

    @Override
    public JRView getView() {
        if (!this.isViewReady()) {
            long l = System.currentTimeMillis();
            ServiceLogger.logDebug("MemberService:: waitting view ready...");
            while (!this.isViewReady()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    ServiceLogger.logError(interruptedException);
                }
            }
            ServiceLogger.logDebug("MemberService:: view is ready: waited time=" + (System.currentTimeMillis() - l));
        }
        return this.getView0();
    }

    @Override
    public void setPenddingReports(int n) {
        if (this.SEDU()) {
            return;
        }
        try {
            ((JRReportMember)this.SEDU).setPenddingReports(n);
            this.add.getCoreTransceiver().notifyPenddingReportsChanged(this.getView0().getShareMemoryIds(), n);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
    }

    @Override
    public JRMember getDefaultShareMemoryNode() {
        if (this.SEDU()) {
            return null;
        }
        return this.getView().getDefaultShareMemoryNode();
    }

    @Override
    public boolean isShareMemoryNode() {
        if (this.SEDU()) {
            return false;
        }
        return this.getView().isShareMemoryNode();
    }

    @Override
    public JRMember[] getShareMemoryNodes() {
        if (this.SEDU()) {
            return null;
        }
        return this.getView().getShareMemoryNodes().toArray(new JRMember[0]);
    }

    @Override
    public List getShareMemoryIds() {
        return this.getView().getShareMemoryIds();
    }
}

